/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.search;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UISelectBoolean;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.DataModel;
import javax.faces.model.SelectItem;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.CachingDateFormat;
import org.alfresco.util.ISO9075;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.MapNode;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.bean.search.SearchContext;
import org.alfresco.web.bean.search.SearchProperties;
import org.alfresco.web.config.AdvancedSearchConfigElement;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIModeList;
import org.alfresco.web.ui.common.component.UIPanel;
import org.alfresco.web.ui.repo.component.UIAjaxCategoryPicker;

public class AdvancedSearchDialog
extends BaseDialogBean {
    private static final long serialVersionUID = 3658148969240122732L;
    private transient PermissionService permissionService;
    protected SearchProperties properties;
    private static final String MSG_ALL_FORMATS = "all_formats";
    private static final String MSG_ERROR_RESTORE_SEARCH = "error_restore_search";
    private static final String MSG_SELECT_SAVED_SEARCH = "select_saved_search";
    private static final String MSG_SAVE = "save";
    private static final String OUTCOME_BROWSE = "browse";
    private static final String PANEL_CUSTOM = "custom-panel";
    private static final String PANEL_ATTRS = "attrs-panel";
    private static final String PANEL_CATEGORIES = "categories-panel";
    private static final String PANEL_RESTRICT = "restrict-panel";
    private static final String PANEL_LOCATION = "location-panel";
    private static final String INCLUDE_CHILDREN = "includeChildren";
    private static final String MODE_ALL = "all";
    private static final String MODE_FILES_TEXT = "files_text";
    private static final String MODE_FILES = "files";
    private static final String MODE_FOLDERS = "folders";
    private static final String LOOKIN_ALL = "all";
    private static final String LOOKIN_OTHER = "other";
    private static final String SAVED_SEARCHES_USER = "user";
    private static final String SAVED_SEARCHES_GLOBAL = "global";
    private static final String NO_SELECTION = "NONE";

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.properties.getPanels().put(PANEL_CATEGORIES, false);
        this.properties.getPanels().put(PANEL_ATTRS, false);
        this.properties.getPanels().put(PANEL_CUSTOM, false);
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    protected PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPermissionService();
        }
        return this.permissionService;
    }

    public void setProperties(SearchProperties properties) {
        this.properties = properties;
    }

    public boolean isAllowEdit() {
        boolean allow;
        boolean bl = allow = this.properties.getSavedSearch() != null && !NO_SELECTION.equals(this.properties.getSavedSearch());
        if (allow) {
            NodeRef savedSearchRef = new NodeRef(Repository.getStoreRef(), this.properties.getSavedSearch());
            allow = this.getPermissionService().hasPermission(savedSearchRef, "Write") == AccessStatus.ALLOWED;
        }
        return allow;
    }

    public void setAllowEdit(boolean allowEdit) {
    }

    public DataModel getCategoriesDataModel() {
        if (this.properties.getCategoriesDataModel().getWrappedData() == null) {
            this.properties.getCategoriesDataModel().setWrappedData(this.properties.getCategories());
        }
        return this.properties.getCategoriesDataModel();
    }

    public List<SelectItem> getContentTypes() {
        if (this.properties.getContentTypes() == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            FacesContext context = FacesContext.getCurrentInstance();
            DictionaryService dictionaryService = Repository.getServiceRegistry(context).getDictionaryService();
            this.properties.setContentTypes(new ArrayList<SelectItem>(5));
            this.properties.getContentTypes().add(new SelectItem((Object)ContentModel.TYPE_CONTENT.toString(), dictionaryService.getType(ContentModel.TYPE_CONTENT).getTitle()));
            List<String> types = this.getSearchConfig().getContentTypes();
            if (types != null) {
                for (String type : types) {
                    TypeDefinition typeDef;
                    QName idQName = Repository.resolveToQName(type);
                    if (idQName == null || (typeDef = dictionaryService.getType(idQName)) == null || !dictionaryService.isSubClass(typeDef.getName(), ContentModel.TYPE_CONTENT)) continue;
                    String label = typeDef.getTitle();
                    if (label == null) {
                        label = idQName.getLocalName();
                    }
                    this.properties.getContentTypes().add(new SelectItem((Object)idQName.toString(), label));
                }
            }
        }
        return this.properties.getContentTypes();
    }

    public List<SelectItem> getFolderTypes() {
        if (this.properties.getFolderTypes() == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            FacesContext context = FacesContext.getCurrentInstance();
            DictionaryService dictionaryService = Repository.getServiceRegistry(context).getDictionaryService();
            this.properties.setFolderTypes(new ArrayList<SelectItem>(5));
            this.properties.getFolderTypes().add(new SelectItem((Object)ContentModel.TYPE_FOLDER.toString(), dictionaryService.getType(ContentModel.TYPE_FOLDER).getTitle()));
            List<String> types = this.getSearchConfig().getFolderTypes();
            if (types != null) {
                for (String type : types) {
                    TypeDefinition typeDef;
                    QName idQName = Repository.resolveToQName(type);
                    if (idQName == null || (typeDef = dictionaryService.getType(idQName)) == null || !dictionaryService.isSubClass(typeDef.getName(), ContentModel.TYPE_FOLDER)) continue;
                    String label = typeDef.getTitle();
                    if (label == null) {
                        label = idQName.getLocalName();
                    }
                    this.properties.getFolderTypes().add(new SelectItem((Object)idQName.toString(), label));
                }
            }
        }
        return this.properties.getFolderTypes();
    }

    public List<SelectItem> getContentFormats() {
        if (this.properties.getContentFormats() == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            this.properties.setContentFormats(new ArrayList<SelectItem>(80));
            ServiceRegistry registry = Repository.getServiceRegistry(FacesContext.getCurrentInstance());
            MimetypeService mimetypeService = registry.getMimetypeService();
            Map mimeTypes = mimetypeService.getDisplaysByMimetype();
            for (String mimeType : mimeTypes.keySet()) {
                this.properties.getContentFormats().add(new SelectItem((Object)mimeType, (String)mimeTypes.get(mimeType)));
            }
            QuickSort sorter = new QuickSort(this.properties.getContentFormats(), "label", true, "case-insensitive");
            sorter.sort();
            this.properties.getContentFormats().add(0, new SelectItem((Object)"", Application.getMessage(FacesContext.getCurrentInstance(), MSG_ALL_FORMATS)));
        }
        return this.properties.getContentFormats();
    }

    public void reset(ActionEvent event) {
        this.resetFields();
        this.properties.setSavedSearch(null);
    }

    private void resetFields() {
        this.properties.setText("");
        this.properties.setMode("all");
        this.properties.setLookin("all");
        this.properties.setContentType(null);
        this.properties.setContentFormat(null);
        this.properties.setFolderType(null);
        this.properties.setLocation(null);
        this.properties.setLocationChildren(true);
        this.properties.setCategories(new ArrayList<Node>(2));
        this.properties.setCategoriesDataModel(null);
        this.properties.setTitle(null);
        this.properties.setDescription(null);
        this.properties.setAuthor(null);
        this.properties.setCreatedDateFrom(null);
        this.properties.setCreatedDateTo(null);
        this.properties.setModifiedDateFrom(null);
        this.properties.setModifiedDateTo(null);
        this.properties.setCreatedDateChecked(false);
        this.properties.setModifiedDateChecked(false);
        this.properties.getCustomProperties().clear();
    }

    public String search() {
        Calendar cal;
        SimpleDateFormat df;
        SearchContext search = new SearchContext();
        search.setText(this.properties.getText());
        search.setForceAndTerms(Application.getClientConfig(FacesContext.getCurrentInstance()).getForceAndTerms());
        if (this.properties.getMode().equals("all")) {
            search.setMode(0);
        } else if (this.properties.getMode().equals(MODE_FILES_TEXT)) {
            search.setMode(1);
        } else if (this.properties.getMode().equals(MODE_FILES)) {
            search.setMode(2);
        } else if (this.properties.getMode().equals(MODE_FOLDERS)) {
            search.setMode(3);
        }
        if (this.properties.getDescription() != null && this.properties.getDescription().length() != 0) {
            search.addAttributeQuery(ContentModel.PROP_DESCRIPTION, this.properties.getDescription());
        }
        if (this.properties.getTitle() != null && this.properties.getTitle().length() != 0) {
            search.addAttributeQuery(ContentModel.PROP_TITLE, this.properties.getTitle());
        }
        if (this.properties.getAuthor() != null && this.properties.getAuthor().length() != 0) {
            search.addAttributeQuery(ContentModel.PROP_AUTHOR, this.properties.getAuthor());
        }
        if (this.properties.getContentFormat() != null && this.properties.getContentFormat().length() != 0) {
            search.setMimeType(this.properties.getContentFormat());
        }
        if (this.properties.isCreatedDateChecked()) {
            df = CachingDateFormat.getDateFormat();
            cal = Calendar.getInstance();
            cal.setTime(this.properties.getCreatedDateFrom());
            cal.set(11, cal.getMinimum(11));
            cal.set(12, cal.getMinimum(12));
            cal.set(13, cal.getMinimum(13));
            cal.set(14, cal.getMinimum(14));
            String strCreatedDate = df.format(cal.getTime());
            cal.setTime(this.properties.getCreatedDateTo());
            cal.set(11, cal.getMinimum(11));
            cal.set(12, cal.getMinimum(12));
            cal.set(13, cal.getMinimum(13));
            cal.set(14, cal.getMinimum(14));
            cal.add(6, 1);
            cal.add(14, -1);
            String strCreatedDateTo = df.format(cal.getTime());
            search.addRangeQuery(ContentModel.PROP_CREATED, strCreatedDate, strCreatedDateTo, true);
        }
        if (this.properties.isModifiedDateChecked()) {
            df = CachingDateFormat.getDateFormat();
            cal = Calendar.getInstance();
            cal.setTime(this.properties.getModifiedDateFrom());
            cal.set(11, cal.getMinimum(11));
            cal.set(12, cal.getMinimum(12));
            cal.set(13, cal.getMinimum(13));
            cal.set(14, cal.getMinimum(14));
            String strModifiedDate = df.format(cal.getTime());
            cal.setTime(this.properties.getModifiedDateTo());
            cal.set(11, cal.getMinimum(11));
            cal.set(12, cal.getMinimum(12));
            cal.set(13, cal.getMinimum(13));
            cal.set(14, cal.getMinimum(14));
            cal.add(6, 1);
            cal.add(14, -1);
            String strModifiedDateTo = df.format(cal.getTime());
            search.addRangeQuery(ContentModel.PROP_MODIFIED, strModifiedDate, strModifiedDateTo, true);
        }
        Map<String, DataTypeDefinition> customPropertyLookup = this.getCustomPropertyLookup();
        for (String qname : this.properties.getCustomProperties().keySet()) {
            Object value = this.properties.getCustomProperties().get(qname);
            DataTypeDefinition typeDef = customPropertyLookup.get(qname);
            if (typeDef == null) continue;
            QName typeName = typeDef.getName();
            if (DataTypeDefinition.DATE.equals((Object)typeName) || DataTypeDefinition.DATETIME.equals((Object)typeName)) {
                if (value == null || !Boolean.valueOf(value.toString()).booleanValue()) continue;
                SimpleDateFormat df2 = CachingDateFormat.getDateFormat();
                String strDateFrom = df2.format(this.properties.getCustomProperties().get("from_" + qname));
                String strDateTo = df2.format(this.properties.getCustomProperties().get("to_" + qname));
                search.addRangeQuery(QName.createQName((String)qname), strDateFrom, strDateTo, true);
                continue;
            }
            if (DataTypeDefinition.BOOLEAN.equals((Object)typeName)) {
                if (!((Boolean)value).booleanValue()) continue;
                search.addFixedValueQuery(QName.createQName((String)qname), value.toString());
                continue;
            }
            if (DataTypeDefinition.NODE_REF.equals((Object)typeName) || DataTypeDefinition.CATEGORY.equals((Object)typeName)) {
                if (value == null) continue;
                search.addFixedValueQuery(QName.createQName((String)qname), value.toString());
                continue;
            }
            if (value == null) continue;
            String strVal = value.toString();
            Object item = this.properties.getCustomProperties().get("item_" + qname);
            if (item != null) {
                if (!((Boolean)value).booleanValue()) continue;
                search.addFixedValueQuery(QName.createQName((String)qname), item.toString());
                continue;
            }
            if (strVal == null || strVal.length() == 0) continue;
            if (DataTypeDefinition.INT.equals((Object)typeName) || DataTypeDefinition.LONG.equals((Object)typeName) || DataTypeDefinition.FLOAT.equals((Object)typeName) || DataTypeDefinition.DOUBLE.equals((Object)typeName)) {
                search.addFixedValueQuery(QName.createQName((String)qname), strVal);
                continue;
            }
            search.addAttributeQuery(QName.createQName((String)qname), strVal);
        }
        if (this.properties.getLookin().equals(LOOKIN_OTHER) && this.properties.getLocation() != null) {
            search.setLocation(SearchContext.getPathFromSpaceRef(this.properties.getLocation(), this.properties.isLocationChildren()));
        }
        if (this.properties.getCategories().size() != 0) {
            String[] paths = new String[this.properties.getCategories().size()];
            for (int i = 0; i < paths.length; ++i) {
                Node category = this.properties.getCategories().get(i);
                boolean includeChildren = (Boolean)category.getProperties().get(INCLUDE_CHILDREN);
                paths[i] = SearchContext.getPathFromSpaceRef(category.getNodeRef(), includeChildren);
            }
            search.setCategories(paths);
        }
        if (this.properties.getContentType() != null) {
            search.setContentType(this.properties.getContentType());
        }
        if (this.properties.getFolderType() != null) {
            search.setFolderType(this.properties.getFolderType());
        }
        this.navigator.setSearchContext(search);
        return OUTCOME_BROWSE;
    }

    public String saveNewSearch() {
        this.properties.setSearchDescription(null);
        this.properties.setSearchName(null);
        this.properties.setSearchSaveGlobal(false);
        return "dialog:saveSearch";
    }

    public String saveEditSearch() {
        this.properties.setSearchDescription(null);
        this.properties.setSearchName(null);
        this.properties.setEditSearchName(null);
        try {
            NodeRef searchRef = new NodeRef(Repository.getStoreRef(), this.properties.getSavedSearch());
            Node searchNode = new Node(searchRef);
            if (this.getNodeService().exists(searchRef) && searchNode.hasPermission("Write")) {
                Node node = new Node(searchRef);
                this.properties.setSearchName(node.getName());
                this.properties.setEditSearchName(this.properties.getSearchName());
                this.properties.setSearchDescription((String)node.getProperties().get(ContentModel.PROP_DESCRIPTION));
            } else {
                this.properties.setSavedSearch(null);
            }
        }
        catch (Throwable err) {
            this.properties.setSavedSearch(null);
        }
        return "dialog:editSearch";
    }

    public List<SelectItem> getSavedSearches() {
        ArrayList<SelectItem> savedSearches = (ArrayList<SelectItem>)this.properties.getCachedSavedSearches().get();
        if (savedSearches == null) {
            FacesContext fc = FacesContext.getCurrentInstance();
            ServiceRegistry services = Repository.getServiceRegistry(fc);
            NodeRef searchesRef = null;
            if (SAVED_SEARCHES_USER.equals(this.properties.getSavedSearchMode())) {
                searchesRef = this.getUserSearchesRef();
            } else if (SAVED_SEARCHES_GLOBAL.equals(this.properties.getSavedSearchMode())) {
                searchesRef = this.getGlobalSearchesRef();
            }
            if (searchesRef != null) {
                DictionaryService dd = services.getDictionaryService();
                List childRefs = this.getNodeService().getChildAssocs(searchesRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
                savedSearches = new ArrayList(childRefs.size() + 1);
                if (childRefs.size() != 0) {
                    for (ChildAssociationRef ref : childRefs) {
                        Node childNode = new Node(ref.getChildRef());
                        if (!dd.isSubClass(childNode.getType(), ContentModel.TYPE_CONTENT)) continue;
                        savedSearches.add(new SelectItem((Object)childNode.getId(), childNode.getName()));
                    }
                    QuickSort sorter = new QuickSort(savedSearches, "label", true, "case-insensitive");
                    sorter.sort();
                }
            } else {
                savedSearches = new ArrayList<SelectItem>(1);
            }
            savedSearches.add(0, new SelectItem((Object)NO_SELECTION, Application.getMessage(FacesContext.getCurrentInstance(), MSG_SELECT_SAVED_SEARCH)));
            this.properties.getCachedSavedSearches().put(savedSearches);
        }
        return savedSearches;
    }

    public void savedSearchModeChanged(ActionEvent event) {
        UIModeList savedModeList = (UIModeList)event.getComponent();
        String viewMode = savedModeList.getValue().toString();
        this.properties.setSavedSearchMode(viewMode);
        this.properties.getCachedSavedSearches().clear();
        this.properties.setSavedSearch(null);
    }

    public void selectSearch(ActionEvent event) {
        if (!NO_SELECTION.equals(this.properties.getSavedSearch())) {
            NodeRef searchSearchRef = new NodeRef(Repository.getStoreRef(), this.properties.getSavedSearch());
            ServiceRegistry services = Repository.getServiceRegistry(FacesContext.getCurrentInstance());
            ContentService cs = services.getContentService();
            try {
                if (services.getNodeService().exists(searchSearchRef)) {
                    ContentReader reader = cs.getReader(searchSearchRef, ContentModel.PROP_CONTENT);
                    SearchContext search = new SearchContext().fromXML(reader.getContentString());
                    this.initialiseFromContext(search);
                }
            }
            catch (Throwable err) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_RESTORE_SEARCH), err.getMessage()), err);
            }
        }
    }

    private void initialiseFromContext(SearchContext search) {
        SearchContext.RangeProperties modifiedDate;
        SearchContext.RangeProperties createdDate;
        String[] categories;
        this.resetFields();
        this.properties.setText(search.getText());
        switch (search.getMode()) {
            case 0: {
                this.properties.setMode("all");
                break;
            }
            case 1: {
                this.properties.setMode(MODE_FILES_TEXT);
                break;
            }
            case 2: {
                this.properties.setMode(MODE_FILES);
                break;
            }
            case 3: {
                this.properties.setMode(MODE_FOLDERS);
            }
        }
        this.properties.getPanels().put(PANEL_RESTRICT, true);
        if (search.getLocation() != null) {
            this.properties.setLocationChildren(search.getLocation().endsWith("//*"));
            this.properties.setLocation(this.findNodeRefFromPath(search.getLocation()));
            this.properties.setLookin(LOOKIN_OTHER);
            this.properties.getPanels().put(PANEL_LOCATION, true);
        }
        if ((categories = search.getCategories()) != null && categories.length != 0) {
            for (String category : categories) {
                NodeRef categoryRef = this.findNodeRefFromPath(category);
                if (categoryRef == null) continue;
                MapNode categoryNode = new MapNode(categoryRef);
                categoryNode.getProperties().put(INCLUDE_CHILDREN, category.endsWith("//*"));
                this.properties.getCategories().add(categoryNode);
            }
            this.properties.getPanels().put(PANEL_CATEGORIES, true);
        }
        this.properties.setContentType(search.getContentType());
        this.properties.setContentFormat(search.getMimeType());
        this.properties.setFolderType(search.getFolderType());
        this.properties.setDescription(search.getAttributeQuery(ContentModel.PROP_DESCRIPTION));
        this.properties.setTitle(search.getAttributeQuery(ContentModel.PROP_TITLE));
        this.properties.setAuthor(search.getAttributeQuery(ContentModel.PROP_AUTHOR));
        if (this.properties.getContentType() != null || this.properties.getContentFormat() != null || this.properties.getDescription() != null || this.properties.getTitle() != null || this.properties.getAuthor() != null) {
            this.properties.getPanels().put(PANEL_ATTRS, true);
        }
        if ((createdDate = search.getRangeProperty(ContentModel.PROP_CREATED)) != null) {
            this.properties.setCreatedDateFrom(Utils.parseXMLDateFormat(createdDate.lower));
            this.properties.setCreatedDateTo(Utils.parseXMLDateFormat(createdDate.upper));
            this.properties.setCreatedDateChecked(true);
            this.properties.getPanels().put(PANEL_ATTRS, true);
        }
        if ((modifiedDate = search.getRangeProperty(ContentModel.PROP_MODIFIED)) != null) {
            this.properties.setModifiedDateFrom(Utils.parseXMLDateFormat(modifiedDate.lower));
            this.properties.setModifiedDateTo(Utils.parseXMLDateFormat(modifiedDate.upper));
            this.properties.setModifiedDateChecked(true);
            this.properties.getPanels().put(PANEL_ATTRS, true);
        }
        Map<String, DataTypeDefinition> customPropertyLookup = this.getCustomPropertyLookup();
        for (String qname : customPropertyLookup.keySet()) {
            DataTypeDefinition typeDef = customPropertyLookup.get(qname);
            if (typeDef == null) continue;
            QName typeName = typeDef.getName();
            if (DataTypeDefinition.DATE.equals((Object)typeName) || DataTypeDefinition.DATETIME.equals((Object)typeName)) {
                SearchContext.RangeProperties dateProps = search.getRangeProperty(QName.createQName((String)qname));
                if (dateProps == null) continue;
                this.properties.getCustomProperties().put("from_" + qname, Utils.parseXMLDateFormat(dateProps.lower));
                this.properties.getCustomProperties().put("to_" + qname, Utils.parseXMLDateFormat(dateProps.upper));
                this.properties.getCustomProperties().put(qname, true);
                this.properties.getPanels().put(PANEL_CUSTOM, true);
                continue;
            }
            if (DataTypeDefinition.BOOLEAN.equals((Object)typeName)) {
                String strBool = search.getFixedValueQuery(QName.createQName((String)qname));
                if (strBool == null) continue;
                this.properties.getCustomProperties().put(qname, Boolean.parseBoolean(strBool));
                this.properties.getPanels().put(PANEL_CUSTOM, true);
                continue;
            }
            if (DataTypeDefinition.NODE_REF.equals((Object)typeName) || DataTypeDefinition.CATEGORY.equals((Object)typeName)) {
                String strNodeRef = search.getFixedValueQuery(QName.createQName((String)qname));
                if (strNodeRef == null) continue;
                this.properties.getCustomProperties().put(qname, new NodeRef(strNodeRef));
                this.properties.getPanels().put(PANEL_CUSTOM, true);
                continue;
            }
            if (DataTypeDefinition.INT.equals((Object)typeName) || DataTypeDefinition.LONG.equals((Object)typeName) || DataTypeDefinition.FLOAT.equals((Object)typeName) || DataTypeDefinition.DOUBLE.equals((Object)typeName)) {
                this.properties.getCustomProperties().put(qname, search.getFixedValueQuery(QName.createQName((String)qname)));
                this.properties.getPanels().put(PANEL_CUSTOM, true);
                continue;
            }
            String value = search.getFixedValueQuery(QName.createQName((String)qname));
            if (value != null) {
                this.properties.getCustomProperties().put("item_" + qname, value);
                this.properties.getCustomProperties().put(qname, Boolean.TRUE);
            } else {
                this.properties.getCustomProperties().put(qname, search.getAttributeQuery(QName.createQName((String)qname)));
            }
            this.properties.getPanels().put(PANEL_CUSTOM, true);
        }
    }

    private NodeRef findNodeRefFromPath(String xpath) {
        if (xpath.endsWith("//*")) {
            xpath = xpath.substring(0, xpath.lastIndexOf("//*"));
        } else if (xpath.endsWith("/*")) {
            xpath = xpath.substring(0, xpath.lastIndexOf("/*"));
        }
        NodeRef rootRef = new NodeRef(Repository.getStoreRef(), Application.getCompanyRootId(FacesContext.getCurrentInstance()));
        List results = null;
        try {
            results = this.getSearchService().selectNodes(rootRef, xpath, null, (NamespacePrefixResolver)this.getNamespaceService(), false);
        }
        catch (AccessDeniedException err) {
            // empty catch block
        }
        return results != null && results.size() == 1 ? (NodeRef)results.get(0) : null;
    }

    protected NodeRef getUserSearchesRef() {
        NodeRef globalRef;
        if (this.properties.getUserSearchesRef() == null && (globalRef = this.getGlobalSearchesRef()) != null) {
            FacesContext fc = FacesContext.getCurrentInstance();
            User user = Application.getCurrentUser(fc);
            String userName = ISO9075.encode((String)user.getUserName());
            String xpath = "app:" + QName.createValidLocalName((String)userName);
            List results = null;
            try {
                results = this.getSearchService().selectNodes(globalRef, xpath, null, (NamespacePrefixResolver)this.getNamespaceService(), false);
            }
            catch (AccessDeniedException err) {
                // empty catch block
            }
            if (results != null) {
                if (results.size() == 1) {
                    this.properties.setUserSearchesRef((NodeRef)results.get(0));
                } else if (results.size() == 0 && new Node(globalRef).hasPermission("AddChildren")) {
                    ChildAssociationRef childRef = this.getNodeService().createNode(globalRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)QName.createValidLocalName((String)user.getUserName())), ContentModel.TYPE_FOLDER, null);
                    this.properties.setUserSearchesRef(childRef.getChildRef());
                }
            }
        }
        return this.properties.getUserSearchesRef();
    }

    protected NodeRef getGlobalSearchesRef() {
        if (this.properties.getGlobalSearchesRef() == null) {
            FacesContext fc = FacesContext.getCurrentInstance();
            String xpath = Application.getRootPath(fc) + "/" + Application.getGlossaryFolderName(fc) + "/" + Application.getSavedSearchesFolderName(fc);
            List results = null;
            try {
                results = this.getSearchService().selectNodes(this.getNodeService().getRootNode(Repository.getStoreRef()), xpath, null, (NamespacePrefixResolver)this.getNamespaceService(), false);
            }
            catch (AccessDeniedException err) {
                // empty catch block
            }
            if (results != null && results.size() == 1) {
                this.properties.setGlobalSearchesRef((NodeRef)results.get(0));
            }
        }
        return this.properties.getGlobalSearchesRef();
    }

    public void addCategory(ActionEvent event) {
        UIAjaxCategoryPicker selector = (UIAjaxCategoryPicker)event.getComponent().findComponent("catSelector");
        UISelectBoolean chkChildren = (UISelectBoolean)event.getComponent().findComponent("chkCatChildren");
        List categoryRefs = (List)selector.getValue();
        if (categoryRefs != null) {
            for (NodeRef categoryRef : categoryRefs) {
                MapNode categoryNode = new MapNode(categoryRef);
                categoryNode.getProperties().put(INCLUDE_CHILDREN, chkChildren.isSelected());
                this.properties.getCategories().add(categoryNode);
            }
            selector.setValue(null);
        }
    }

    public void removeCategory(ActionEvent event) {
        Node node = (Node)this.properties.getCategoriesDataModel().getRowData();
        if (node != null) {
            this.properties.getCategories().remove(node);
        }
    }

    private AdvancedSearchConfigElement getSearchConfig() {
        if (this.properties.getSearchConfigElement() == null) {
            this.properties.setSearchConfigElement((AdvancedSearchConfigElement)Application.getConfigService(FacesContext.getCurrentInstance()).getConfig((Object)"Advanced Search").getConfigElement("advanced-search"));
        }
        return this.properties.getSearchConfigElement();
    }

    private Map<String, DataTypeDefinition> getCustomPropertyLookup() {
        if (this.properties.getCustomPropertyLookup() == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            this.properties.setCustomPropertyLookup(new HashMap<String, DataTypeDefinition>(7, 1.0f));
            List<AdvancedSearchConfigElement.CustomProperty> customProps = this.getSearchConfig().getCustomProperties();
            if (customProps != null) {
                DictionaryService dd = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getDictionaryService();
                for (AdvancedSearchConfigElement.CustomProperty customProp : customProps) {
                    PropertyDefinition propDef = null;
                    QName propQName = Repository.resolveToQName(customProp.Property);
                    if (customProp.Type != null) {
                        QName type = Repository.resolveToQName(customProp.Type);
                        TypeDefinition typeDef = dd.getType(type);
                        propDef = (PropertyDefinition)typeDef.getProperties().get(propQName);
                    } else if (customProp.Aspect != null) {
                        QName aspect = Repository.resolveToQName(customProp.Aspect);
                        AspectDefinition aspectDef = dd.getAspect(aspect);
                        propDef = (PropertyDefinition)aspectDef.getProperties().get(propQName);
                    }
                    if (propQName == null || propDef == null) continue;
                    this.properties.getCustomPropertyLookup().put(propQName.toString(), propDef.getDataType());
                }
            }
        }
        return this.properties.getCustomPropertyLookup();
    }

    public void expandPanel(ActionEvent event) {
        if (event instanceof UIPanel.ExpandedEvent) {
            this.properties.getPanels().put(event.getComponent().getId(), ((UIPanel.ExpandedEvent)event).State);
        }
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_SAVE);
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return null;
    }
}

