/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.search;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.alfresco.web.bean.repository.Repository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.queryParser.QueryParser;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class SearchContext
implements Serializable {
    private static final long serialVersionUID = 6730844584074229969L;
    private static final String ELEMENT_VALUE = "value";
    private static final String ELEMENT_FIXED_VALUES = "fixed-values";
    private static final String ELEMENT_INCLUSIVE = "inclusive";
    private static final String ELEMENT_UPPER = "upper";
    private static final String ELEMENT_LOWER = "lower";
    private static final String ELEMENT_RANGE = "range";
    private static final String ELEMENT_RANGES = "ranges";
    private static final String ELEMENT_NAME = "name";
    private static final String ELEMENT_ATTRIBUTE = "attribute";
    private static final String ELEMENT_ATTRIBUTES = "attributes";
    private static final String ELEMENT_MIMETYPE = "mimetype";
    private static final String ELEMENT_CONTENT_TYPE = "content-type";
    private static final String ELEMENT_FOLDER_TYPE = "folder-type";
    private static final String ELEMENT_CATEGORY = "category";
    private static final String ELEMENT_CATEGORIES = "categories";
    private static final String ELEMENT_LOCATION = "location";
    private static final String ELEMENT_MODE = "mode";
    private static final String ELEMENT_TEXT = "text";
    private static final String ELEMENT_SEARCH = "search";
    private static final String ELEMENT_QUERY = "query";
    private static final char OP_WILDCARD = '*';
    private static final char OP_AND = '+';
    private static final char OP_NOT = '-';
    private static final String STR_OP_WILDCARD = "*";
    public static final int SEARCH_ALL = 0;
    public static final int SEARCH_FILE_NAMES_CONTENTS = 1;
    public static final int SEARCH_FILE_NAMES = 2;
    public static final int SEARCH_SPACE_NAMES = 3;
    private String text = "";
    private int mode = 0;
    private String location = null;
    private String[] categories = new String[0];
    private String folderType = null;
    private String contentType = null;
    private String mimeType = null;
    protected List<QName> simpleSearchAdditionalAttrs = new ArrayList<QName>(4);
    private Map<QName, String> queryAttributes = new HashMap<QName, String>(5, 1.0f);
    private Map<QName, RangeProperties> rangeAttributes = new HashMap<QName, RangeProperties>(5, 1.0f);
    private Map<QName, String> queryFixedValues = new HashMap<QName, String>(5, 1.0f);
    private boolean forceAndTerms = false;
    private static Log logger = LogFactory.getLog(SearchContext.class);

    public String buildQuery(int minimum) {
        String query;
        String escapedName;
        boolean validQuery = false;
        String nameAttr = Repository.escapeQName(QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)ELEMENT_NAME));
        StringBuilder plBuf = new StringBuilder("(");
        StringBuilder mnBuf = new StringBuilder("-(");
        String text = this.text.trim();
        if (text.length() != 0 && text.length() >= minimum) {
            if (text.indexOf(32) == -1 && text.charAt(0) != '\"') {
                boolean operatorNOT;
                boolean operatorAND = text.charAt(0) == '+';
                boolean bl = operatorNOT = text.charAt(0) == '-';
                if (operatorAND || operatorNOT) {
                    text = text.substring(1);
                }
                if (text.length() != 0) {
                    if (operatorNOT) {
                        SearchContext.processSearchTextAttribute(nameAttr, text, this.mode == 1 || this.mode == 0, mnBuf);
                    } else {
                        SearchContext.processSearchTextAttribute(nameAttr, text, this.mode == 1 || this.mode == 0, plBuf);
                    }
                    SearchContext.processSearchAdditionalAttribute(text, operatorNOT, operatorAND, mnBuf, plBuf, this.simpleSearchAdditionalAttrs);
                }
            } else if (text.charAt(0) == '\"' && text.charAt(text.length() - 1) == '\"') {
                String quotedSafeText = '\"' + QueryParser.escape((String)text.substring(1, text.length() - 1)) + '\"';
                plBuf.append("TEXT:").append(quotedSafeText);
                plBuf.append(" @").append(nameAttr).append(":").append(quotedSafeText);
                for (QName qname : this.simpleSearchAdditionalAttrs) {
                    plBuf.append(" @").append(Repository.escapeQName(qname)).append(":").append(quotedSafeText);
                }
            } else {
                StringTokenizer t = new StringTokenizer(text, " ");
                int termCount = 0;
                int tokenCount = t.countTokens();
                for (int i = 0; i < tokenCount; ++i) {
                    boolean operatorNOT;
                    String term = t.nextToken();
                    boolean operatorAND = term.charAt(0) == '+';
                    boolean bl = operatorNOT = term.charAt(0) == '-';
                    if (operatorAND || operatorNOT) {
                        term = term.substring(1);
                    }
                    if (!operatorNOT) {
                        operatorAND |= this.forceAndTerms;
                    }
                    if (term.length() == 0) continue;
                    if (operatorNOT) {
                        SearchContext.processSearchTextAttribute(nameAttr, term, this.mode == 1 || this.mode == 0, mnBuf);
                    } else {
                        SearchContext.processSearchTextAttribute(nameAttr, term, this.mode == 1 || this.mode == 0, plBuf);
                    }
                    if (this.mode == 0) {
                        SearchContext.processSearchAdditionalAttribute(term, operatorNOT, operatorAND, mnBuf, plBuf, this.simpleSearchAdditionalAttrs);
                    }
                    ++termCount;
                }
            }
            plBuf.append(')');
            mnBuf.append(')');
            validQuery = true;
        }
        StringBuilder pathQuery = null;
        if (this.location != null || this.categories != null && this.categories.length != 0) {
            pathQuery = new StringBuilder(128);
            if (this.location != null) {
                pathQuery.append(" PATH:\"").append(this.location).append("\" ");
                if (this.categories != null && this.categories.length != 0) {
                    pathQuery.append("AND (");
                }
            }
            if (this.categories != null && this.categories.length != 0) {
                for (int i = 0; i < this.categories.length; ++i) {
                    pathQuery.append(" PATH:\"").append(this.categories[i]).append("\" ");
                }
                if (this.location != null) {
                    pathQuery.append(") ");
                }
            }
        }
        StringBuilder attributeQuery = null;
        if (this.queryAttributes.size() != 0) {
            attributeQuery = new StringBuilder(this.queryAttributes.size() << 6);
            for (QName qname : this.queryAttributes.keySet()) {
                String value = this.queryAttributes.get(qname).trim();
                if (value.length() < minimum) continue;
                SearchContext.processSearchAttribute(qname, value, attributeQuery);
            }
            if (attributeQuery.length() == 0) {
                attributeQuery = null;
            }
        }
        if (this.queryFixedValues.size() != 0) {
            if (attributeQuery == null) {
                attributeQuery = new StringBuilder(this.queryFixedValues.size() << 6);
            }
            for (QName qname : this.queryFixedValues.keySet()) {
                escapedName = Repository.escapeQName(qname);
                String value = this.queryFixedValues.get(qname);
                attributeQuery.append(" +@").append(escapedName).append(":\"").append(QueryParser.escape((String)value)).append('\"');
            }
        }
        if (this.rangeAttributes.size() != 0) {
            if (attributeQuery == null) {
                attributeQuery = new StringBuilder(this.rangeAttributes.size() << 6);
            }
            for (QName qname : this.rangeAttributes.keySet()) {
                escapedName = Repository.escapeQName(qname);
                RangeProperties rp = this.rangeAttributes.get(qname);
                String value1 = QueryParser.escape((String)rp.lower);
                String value2 = QueryParser.escape((String)rp.upper);
                attributeQuery.append(" +@").append(escapedName).append(":").append(rp.inclusive ? "[" : "{").append(value1).append(" TO ").append(value2).append(rp.inclusive ? "]" : "}");
            }
        }
        if (this.mimeType != null && this.mimeType.length() != 0) {
            if (attributeQuery == null) {
                attributeQuery = new StringBuilder(64);
            }
            String escapedName2 = Repository.escapeQName(QName.createQName((String)(ContentModel.PROP_CONTENT + ".mimetype")));
            attributeQuery.append(" +@").append(escapedName2).append(":").append(this.mimeType);
        }
        String fileTypeQuery = this.contentType != null ? " TYPE:\"" + this.contentType + "\" " : " TYPE:\"{http://www.alfresco.org/model/content/1.0}content\" ";
        String folderTypeQuery = this.folderType != null ? " TYPE:\"" + this.folderType + "\" " : " TYPE:\"{http://www.alfresco.org/model/content/1.0}folder\" ";
        if (text.length() != 0 && text.length() >= minimum) {
            StringBuilder buf = new StringBuilder(128);
            if (plBuf.length() > 2) {
                buf.append((CharSequence)plBuf);
                if (mnBuf.length() > 3) {
                    buf.append(" AND ");
                }
            }
            if (mnBuf.length() > 3) {
                buf.append((CharSequence)mnBuf);
            }
            switch (this.mode) {
                case 0: {
                    query = '(' + fileTypeQuery + " AND " + '(' + buf + ')' + ')' + ' ' + '(' + folderTypeQuery + " AND " + '(' + buf + "))";
                    break;
                }
                case 1: 
                case 2: {
                    query = fileTypeQuery + " AND " + '(' + buf + ')';
                    break;
                }
                case 3: {
                    query = folderTypeQuery + " AND " + buf;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown search mode specified: " + this.mode);
                }
            }
        } else {
            switch (this.mode) {
                case 0: {
                    query = '(' + fileTypeQuery + ' ' + folderTypeQuery + ')';
                    break;
                }
                case 1: 
                case 2: {
                    query = fileTypeQuery;
                    break;
                }
                case 3: {
                    query = folderTypeQuery;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown search mode specified: " + this.mode);
                }
            }
        }
        if (attributeQuery != null) {
            query = attributeQuery + " AND (" + query + ')';
        }
        if (pathQuery != null) {
            query = "(" + pathQuery + ") AND (" + query + ')';
        }
        query = "(" + query + ") AND NOT ASPECT:\"sys:hidden\" ";
        if (!(validQuery = validQuery | attributeQuery != null | pathQuery != null)) {
            query = null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Query:\r\n" + query));
        }
        return query;
    }

    private static void processSearchAttribute(QName qname, String value, StringBuilder buf) {
        buf.append(" @").append(Repository.escapeQName(qname)).append(":\"").append(SearchContext.escape(value)).append("\" ");
    }

    private static void processSearchTextAttribute(String qname, String value, boolean appendText, StringBuilder mnBuf) {
        mnBuf.append('@').append(qname).append(":\"").append(SearchContext.escape(value)).append('\"');
        if (appendText) {
            mnBuf.append(" TEXT:\"").append(SearchContext.escape(value)).append("\" ");
        }
    }

    private static void processSearchAdditionalAttribute(String value, boolean operatorNOT, boolean operatorAND, StringBuilder mnBuf, StringBuilder plBuf, List<QName> simpleSearchAdditionalAttrs) {
        for (QName qname : simpleSearchAdditionalAttrs) {
            if (operatorNOT) {
                SearchContext.processSearchAttribute(qname, value, mnBuf);
                continue;
            }
            SearchContext.processSearchAttribute(qname, value, plBuf);
        }
    }

    private static String escape(String s) {
        StringBuffer sb = new StringBuffer(s.length() + 4);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getPathFromSpaceRef(NodeRef ref, boolean children) {
        FacesContext context = FacesContext.getCurrentInstance();
        Path path = Repository.getServiceRegistry(context).getNodeService().getPath(ref);
        NamespaceService ns = Repository.getServiceRegistry(context).getNamespaceService();
        StringBuilder buf = new StringBuilder(64);
        for (int i = 0; i < path.size(); ++i) {
            Collection prefixes;
            ChildAssociationRef elementRef;
            String elementString = "";
            Path.Element element = path.get(i);
            if (element instanceof Path.ChildAssocElement && (elementRef = ((Path.ChildAssocElement)element).getRef()).getParentRef() != null && (prefixes = ns.getPrefixes(elementRef.getQName().getNamespaceURI())).size() > 0) {
                elementString = '/' + (String)prefixes.iterator().next() + ':' + ISO9075.encode((String)elementRef.getQName().getLocalName());
            }
            buf.append(elementString);
        }
        if (children) {
            buf.append("//*");
        } else {
            buf.append("/*");
        }
        return buf.toString();
    }

    public String[] getCategories() {
        return this.categories;
    }

    public void setCategories(String[] categories) {
        if (categories != null) {
            this.categories = categories;
        }
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getFolderType() {
        return this.folderType;
    }

    public void setFolderType(String folderType) {
        this.folderType = folderType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void addSimpleAttributeQuery(QName qname) {
        this.simpleSearchAdditionalAttrs.add(qname);
    }

    public void setSimpleSearchAdditionalAttributes(List<QName> attrs) {
        if (attrs != null) {
            this.simpleSearchAdditionalAttrs = attrs;
        }
    }

    public void addAttributeQuery(QName qname, String value) {
        this.queryAttributes.put(qname, value);
    }

    public String getAttributeQuery(QName qname) {
        return this.queryAttributes.get(qname);
    }

    public void addRangeQuery(QName qname, String lower, String upper, boolean inclusive) {
        this.rangeAttributes.put(qname, new RangeProperties(qname, lower, upper, inclusive));
    }

    public RangeProperties getRangeProperty(QName qname) {
        return this.rangeAttributes.get(qname);
    }

    public void addFixedValueQuery(QName qname, String value) {
        this.queryFixedValues.put(qname, value);
    }

    public String getFixedValueQuery(QName qname) {
        return this.queryFixedValues.get(qname);
    }

    public boolean getForceAndTerms() {
        return this.forceAndTerms;
    }

    public void setForceAndTerms(boolean forceAndTerms) {
        this.forceAndTerms = forceAndTerms;
    }

    public String toXML() {
        try {
            NamespaceService ns = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNamespaceService();
            Document doc = DocumentHelper.createDocument();
            Element root = doc.addElement(ELEMENT_SEARCH);
            root.addElement(ELEMENT_TEXT).addCDATA(this.text);
            root.addElement(ELEMENT_MODE).addText(Integer.toString(this.mode));
            if (this.location != null) {
                root.addElement(ELEMENT_LOCATION).addText(this.location);
            }
            Element categories = root.addElement(ELEMENT_CATEGORIES);
            for (String path : this.categories) {
                categories.addElement(ELEMENT_CATEGORY).addText(path);
            }
            if (this.contentType != null) {
                root.addElement(ELEMENT_CONTENT_TYPE).addText(this.contentType);
            }
            if (this.folderType != null) {
                root.addElement(ELEMENT_FOLDER_TYPE).addText(this.folderType);
            }
            if (this.mimeType != null && this.mimeType.length() != 0) {
                root.addElement(ELEMENT_MIMETYPE).addText(this.mimeType);
            }
            Element attributes = root.addElement(ELEMENT_ATTRIBUTES);
            for (QName attrName : this.queryAttributes.keySet()) {
                attributes.addElement(ELEMENT_ATTRIBUTE).addAttribute(ELEMENT_NAME, attrName.toPrefixString((NamespacePrefixResolver)ns)).addCDATA(this.queryAttributes.get(attrName));
            }
            Element ranges = root.addElement(ELEMENT_RANGES);
            for (QName rangeName : this.rangeAttributes.keySet()) {
                RangeProperties rangeProps = this.rangeAttributes.get(rangeName);
                Element range = ranges.addElement(ELEMENT_RANGE);
                range.addAttribute(ELEMENT_NAME, rangeName.toPrefixString((NamespacePrefixResolver)ns));
                range.addElement(ELEMENT_LOWER).addText(rangeProps.lower);
                range.addElement(ELEMENT_UPPER).addText(rangeProps.upper);
                range.addElement(ELEMENT_INCLUSIVE).addText(Boolean.toString(rangeProps.inclusive));
            }
            Element values = root.addElement(ELEMENT_FIXED_VALUES);
            for (QName valueName : this.queryFixedValues.keySet()) {
                values.addElement(ELEMENT_VALUE).addAttribute(ELEMENT_NAME, valueName.toPrefixString((NamespacePrefixResolver)ns)).addCDATA(this.queryFixedValues.get(valueName));
            }
            Element query = root.addElement(ELEMENT_QUERY);
            String queryString = this.buildQuery(0);
            if (queryString != null) {
                query.addCDATA(queryString);
            }
            StringWriter out = new StringWriter(1024);
            XMLWriter writer = new XMLWriter(OutputFormat.createPrettyPrint());
            writer.setWriter((Writer)out);
            writer.write(doc);
            return out.toString();
        }
        catch (Throwable err) {
            throw new AlfrescoRuntimeException("Failed to export SearchContext to XML.", err);
        }
    }

    public SearchContext fromXML(String xml) {
        try {
            Element valuesElement;
            Element rangesElement;
            Element attributesElement;
            Element mimetypeElement;
            Element folderTypeElement;
            Element contentTypeElement;
            Element categoriesElement;
            Element locationElement;
            Element modeElement;
            NamespaceService ns = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNamespaceService();
            SAXReader reader = new SAXReader();
            Document document = reader.read((Reader)new StringReader(xml));
            Element rootElement = document.getRootElement();
            Element textElement = rootElement.element(ELEMENT_TEXT);
            if (textElement != null) {
                this.text = textElement.getText();
            }
            if ((modeElement = rootElement.element(ELEMENT_MODE)) != null) {
                this.mode = Integer.parseInt(modeElement.getText());
            }
            if ((locationElement = rootElement.element(ELEMENT_LOCATION)) != null) {
                this.location = locationElement.getText();
            }
            if ((categoriesElement = rootElement.element(ELEMENT_CATEGORIES)) != null) {
                ArrayList<String> categories = new ArrayList<String>(4);
                Iterator i = categoriesElement.elementIterator(ELEMENT_CATEGORY);
                while (i.hasNext()) {
                    Element categoryElement = (Element)i.next();
                    categories.add(categoryElement.getText());
                }
                this.categories = categories.toArray(this.categories);
            }
            if ((contentTypeElement = rootElement.element(ELEMENT_CONTENT_TYPE)) != null) {
                this.contentType = contentTypeElement.getText();
            }
            if ((folderTypeElement = rootElement.element(ELEMENT_FOLDER_TYPE)) != null) {
                this.folderType = folderTypeElement.getText();
            }
            if ((mimetypeElement = rootElement.element(ELEMENT_MIMETYPE)) != null) {
                this.mimeType = mimetypeElement.getText();
            }
            if ((attributesElement = rootElement.element(ELEMENT_ATTRIBUTES)) != null) {
                Iterator i = attributesElement.elementIterator(ELEMENT_ATTRIBUTE);
                while (i.hasNext()) {
                    Element attrElement = (Element)i.next();
                    QName qname = QName.createQName((String)attrElement.attributeValue(ELEMENT_NAME), (NamespacePrefixResolver)ns);
                    this.addAttributeQuery(qname, attrElement.getText());
                }
            }
            if ((rangesElement = rootElement.element(ELEMENT_RANGES)) != null) {
                Iterator i = rangesElement.elementIterator(ELEMENT_RANGE);
                while (i.hasNext()) {
                    Element rangeElement = (Element)i.next();
                    Element lowerElement = rangeElement.element(ELEMENT_LOWER);
                    Element upperElement = rangeElement.element(ELEMENT_UPPER);
                    Element incElement = rangeElement.element(ELEMENT_INCLUSIVE);
                    if (lowerElement == null || upperElement == null || incElement == null) continue;
                    QName qname = QName.createQName((String)rangeElement.attributeValue(ELEMENT_NAME), (NamespacePrefixResolver)ns);
                    this.addRangeQuery(qname, lowerElement.getText(), upperElement.getText(), Boolean.parseBoolean(incElement.getText()));
                }
            }
            if ((valuesElement = rootElement.element(ELEMENT_FIXED_VALUES)) != null) {
                Iterator i = valuesElement.elementIterator(ELEMENT_VALUE);
                while (i.hasNext()) {
                    Element valueElement = (Element)i.next();
                    QName qname = QName.createQName((String)valueElement.attributeValue(ELEMENT_NAME), (NamespacePrefixResolver)ns);
                    this.addFixedValueQuery(qname, valueElement.getText());
                }
            }
        }
        catch (Throwable err) {
            throw new AlfrescoRuntimeException("Failed to import SearchContext from XML.", err);
        }
        return this;
    }

    static class RangeProperties
    implements Serializable {
        private static final long serialVersionUID = 5627339191207625169L;
        QName qname;
        String lower;
        String upper;
        boolean inclusive;

        RangeProperties(QName qname, String lower, String upper, boolean inclusive) {
            this.qname = qname;
            this.lower = lower;
            this.upper = upper;
            this.inclusive = inclusive;
        }
    }
}

