/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.spaces;

import java.io.Serializable;
import java.text.MessageFormat;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.model.ApplicationModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;

public class ApplyRssTemplateDialog
extends BaseDialogBean {
    private static final long serialVersionUID = 9207265799149337182L;
    private static final String DIALOG_CLOSE = "dialog:close";
    private static final String MSG_APPLY_RSS_FEED = "apply_rss_feed";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";
    private String rssTemplate;

    public void setRSSTemplate(String rssTemplate) {
        this.rssTemplate = rssTemplate;
    }

    public String getRSSTemplate() {
        NodeRef ref = (NodeRef)this.getNode().getProperties().get(ApplicationModel.PROP_FEEDTEMPLATE);
        return ref != null ? ref.getId() : this.rssTemplate;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        this.applyRSSTemplate(null);
        return DIALOG_CLOSE;
    }

    @Override
    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Application.getMessage(fc, MSG_APPLY_RSS_FEED) + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + this.getNode().getName() + Application.getMessage(fc, MSG_RIGHT_QUOTE);
    }

    public void applyRSSTemplate(ActionEvent event) {
        if (this.rssTemplate != null && !this.rssTemplate.equals("none")) {
            try {
                if (!this.getNode().hasAspect(ApplicationModel.ASPECT_FEEDSOURCE)) {
                    this.getNodeService().addAspect(this.getNode().getNodeRef(), ApplicationModel.ASPECT_FEEDSOURCE, null);
                }
                NodeRef templateRef = new NodeRef(Repository.getStoreRef(), this.rssTemplate);
                this.getNodeService().setProperty(this.getNode().getNodeRef(), ApplicationModel.PROP_FEEDTEMPLATE, (Serializable)templateRef);
                this.getNode().reset();
            }
            catch (Exception e) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), e.getMessage()), e);
                ReportedException.throwIfNecessary(e);
            }
        }
    }

    public Node getNode() {
        return this.browseBean.getActionSpace();
    }
}

