/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.spaces;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wizard.BaseWizardBean;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIListItem;
import org.alfresco.web.ui.common.component.description.UIDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;

public class CreateSpaceWizard
extends BaseWizardBean {
    private static final long serialVersionUID = 2917623558917193097L;
    public static final String DEFAULT_SPACE_ICON_NAME = "space-icon-default";
    public static final String DEFAULT_SPACE_ICON_PATH = "";
    public static final String DEFAULT_SPACE_TYPE_ICON_PATH = "/images/icons/space.gif";
    private static Log logger = LogFactory.getLog(CreateSpaceWizard.class);
    protected static final String CREATEFROM_TEMPLATE = "template";
    protected static final String CREATEFROM_EXISTING = "existing";
    protected static final String CREATEFROM_SCRATCH = "scratch";
    protected String spaceType;
    protected String icon;
    protected String createFrom;
    protected NodeRef existingSpaceId;
    protected String templateSpaceId;
    protected String copyPolicy;
    protected String name;
    protected String title;
    protected String description;
    protected String templateName;
    protected boolean saveAsTemplate;
    protected List<SelectItem> templates;
    protected List<UIListItem> folderTypes;
    protected List<UIDescription> folderTypeDescriptions;
    protected NodeRef createdNode;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        if (this.templates != null) {
            this.templates.clear();
            this.templates = null;
        }
        this.createFrom = CREATEFROM_SCRATCH;
        this.spaceType = ContentModel.TYPE_FOLDER.toString();
        this.icon = null;
        this.copyPolicy = "contents";
        this.existingSpaceId = null;
        this.templateSpaceId = null;
        this.name = null;
        this.title = null;
        this.description = null;
        this.templateName = null;
        this.saveAsTemplate = false;
    }

    @Override
    public String next() {
        if (this.createFrom.equals(CREATEFROM_EXISTING) && this.existingSpaceId != null) {
            this.spaceType = this.getNodeService().getType(this.existingSpaceId).toString();
        } else if (this.createFrom.equals(CREATEFROM_TEMPLATE) && this.templateSpaceId != null && !this.templateSpaceId.equals("none")) {
            NodeRef templateNode = new NodeRef(Repository.getStoreRef(), this.templateSpaceId);
            this.spaceType = this.getNodeService().getType(templateNode).toString();
        }
        return null;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        NodeRef copiedNode;
        NodeRef parentSpace;
        NodeRef sourceNode;
        String newSpaceId = null;
        if (this.createFrom.equals(CREATEFROM_SCRATCH)) {
            String nodeId = this.navigator.getCurrentNodeId();
            NodeRef parentNodeRef = nodeId == null ? this.getNodeService().getRootNode(Repository.getStoreRef()) : new NodeRef(Repository.getStoreRef(), nodeId);
            FileInfo fileInfo = this.getFileFolderService().create(parentNodeRef, this.name, Repository.resolveToQName(this.spaceType));
            NodeRef nodeRef = fileInfo.getNodeRef();
            newSpaceId = nodeRef.getId();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created folder node with name: " + this.name));
            }
            HashMap<QName, String> uiFacetsProps = new HashMap<QName, String>(5);
            uiFacetsProps.put(ApplicationModel.PROP_ICON, this.icon);
            uiFacetsProps.put(ContentModel.PROP_TITLE, this.title);
            uiFacetsProps.put(ContentModel.PROP_DESCRIPTION, this.description);
            this.getNodeService().addAspect(nodeRef, ApplicationModel.ASPECT_UIFACETS, uiFacetsProps);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added uifacets aspect with properties: " + uiFacetsProps));
            }
            this.createdNode = nodeRef;
        } else if (this.createFrom.equals(CREATEFROM_EXISTING)) {
            sourceNode = this.existingSpaceId;
            parentSpace = new NodeRef(Repository.getStoreRef(), this.navigator.getCurrentNodeId());
            copiedNode = this.getFileFolderService().copy(sourceNode, parentSpace, this.name).getNodeRef();
            this.getNodeService().setProperty(copiedNode, ContentModel.PROP_TITLE, (Serializable)((Object)this.title));
            this.getNodeService().setProperty(copiedNode, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)this.description));
            this.getNodeService().setProperty(copiedNode, ApplicationModel.PROP_ICON, (Serializable)((Object)this.icon));
            newSpaceId = copiedNode.getId();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Copied space with id of " + sourceNode.getId() + " to " + this.name));
            }
            this.createdNode = copiedNode;
        } else if (this.createFrom.equals(CREATEFROM_TEMPLATE)) {
            sourceNode = new NodeRef(Repository.getStoreRef(), this.templateSpaceId);
            parentSpace = new NodeRef(Repository.getStoreRef(), this.navigator.getCurrentNodeId());
            copiedNode = this.getFileFolderService().copy(sourceNode, parentSpace, this.name).getNodeRef();
            this.getNodeService().setProperty(copiedNode, ContentModel.PROP_TITLE, (Serializable)((Object)this.title));
            this.getNodeService().setProperty(copiedNode, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)this.description));
            this.getNodeService().setProperty(copiedNode, ApplicationModel.PROP_ICON, (Serializable)((Object)this.icon));
            newSpaceId = copiedNode.getId();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Copied template space with id of " + sourceNode.getId() + " to " + this.name));
            }
            this.createdNode = copiedNode;
        }
        if (this.saveAsTemplate) {
            DynamicNamespacePrefixResolver namespacePrefixResolver = new DynamicNamespacePrefixResolver(null);
            namespacePrefixResolver.registerNamespace("app", "http://www.alfresco.org/model/application/1.0");
            String xpath = Application.getRootPath(FacesContext.getCurrentInstance()) + "/" + Application.getGlossaryFolderName(FacesContext.getCurrentInstance()) + "/" + Application.getSpaceTemplatesFolderName(FacesContext.getCurrentInstance());
            NodeRef rootNodeRef = this.getNodeService().getRootNode(Repository.getStoreRef());
            List templateNodeList = this.getSearchService().selectNodes(rootNodeRef, xpath, null, (NamespacePrefixResolver)namespacePrefixResolver, false);
            if (templateNodeList.size() == 1) {
                NodeRef templateNode = (NodeRef)templateNodeList.get(0);
                NodeRef sourceNode2 = new NodeRef(Repository.getStoreRef(), newSpaceId);
                this.getFileFolderService().copy(sourceNode2, templateNode, this.templateName);
            }
        }
        return outcome;
    }

    public String getCopyPolicy() {
        return this.copyPolicy;
    }

    public void setCopyPolicy(String copyPolicy) {
        this.copyPolicy = copyPolicy;
    }

    public String getCreateFrom() {
        return this.createFrom;
    }

    public void setCreateFrom(String createFrom) {
        this.createFrom = createFrom;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public NodeRef getExistingSpaceId() {
        return this.existingSpaceId;
    }

    public void setExistingSpaceId(NodeRef existingSpaceId) {
        this.existingSpaceId = existingSpaceId;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isSaveAsTemplate() {
        return this.saveAsTemplate;
    }

    public void setSaveAsTemplate(boolean saveAsTemplate) {
        this.saveAsTemplate = saveAsTemplate;
    }

    public String getSpaceType() {
        return this.spaceType;
    }

    public void setSpaceType(String spaceType) {
        this.spaceType = spaceType;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getTemplateSpaceId() {
        return this.templateSpaceId;
    }

    public void setTemplateSpaceId(String templateSpaceId) {
        this.templateSpaceId = templateSpaceId;
    }

    public String getSummary() {
        String summaryCreateType = null;
        ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
        if (this.createFrom.equals(CREATEFROM_SCRATCH)) {
            summaryCreateType = bundle.getString(CREATEFROM_SCRATCH);
        } else if (this.createFrom.equals(CREATEFROM_EXISTING)) {
            summaryCreateType = bundle.getString("an_existing_space");
        } else if (this.createFrom.equals(CREATEFROM_TEMPLATE)) {
            summaryCreateType = bundle.getString("a_template");
        }
        String spaceTypeLabel = null;
        for (UIListItem item : this.getFolderTypes()) {
            if (!item.getValue().equals(this.spaceType)) continue;
            spaceTypeLabel = item.getLabel();
            break;
        }
        return this.buildSummary(new String[]{bundle.getString("space_type"), bundle.getString("name"), bundle.getString("description"), bundle.getString("creating_from")}, new String[]{spaceTypeLabel, Utils.encode((String)this.name), Utils.encode((String)this.description), summaryCreateType});
    }

    public List<SelectItem> getTemplateSpaces() {
        if (this.templates == null) {
            this.templates = new ArrayList<SelectItem>();
            FacesContext context = FacesContext.getCurrentInstance();
            String xpath = Application.getRootPath(context) + "/" + Application.getGlossaryFolderName(context) + "/" + Application.getSpaceTemplatesFolderName(context) + "/*";
            NodeRef rootNodeRef = this.getNodeService().getRootNode(Repository.getStoreRef());
            List results = this.getSearchService().selectNodes(rootNodeRef, xpath, null, (NamespacePrefixResolver)this.getNamespaceService(), false);
            if (results.size() != 0) {
                QName spaceType = QName.createQName((String)this.spaceType);
                for (NodeRef assocRef : results) {
                    Node childNode = new Node(assocRef);
                    if (!this.getDictionaryService().isSubClass(childNode.getType(), spaceType)) continue;
                    this.templates.add(new SelectItem((Object)childNode.getId(), childNode.getName()));
                }
                QuickSort sorter = new QuickSort(this.templates, "label", true, "case-insensitive");
                sorter.sort();
            }
            this.templates.add(0, new SelectItem((Object)"none", Application.getMessage(FacesContext.getCurrentInstance(), "select_a_template")));
        }
        return this.templates;
    }

    public List<UIListItem> getFolderTypes() {
        if (this.folderTypes == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            FacesContext context = FacesContext.getCurrentInstance();
            this.folderTypes = new ArrayList<UIListItem>(2);
            this.folderTypeDescriptions = new ArrayList<UIDescription>(2);
            UIListItem defaultItem = new UIListItem();
            String defaultLabel = Application.getMessage(context, "container");
            defaultItem.setValue(ContentModel.TYPE_FOLDER.toString());
            defaultItem.setLabel(defaultLabel);
            defaultItem.setTooltip(defaultLabel);
            defaultItem.setImage(DEFAULT_SPACE_TYPE_ICON_PATH);
            this.folderTypes.add(defaultItem);
            UIDescription defaultDesc = new UIDescription();
            defaultDesc.setControlValue(ContentModel.TYPE_FOLDER.toString());
            defaultDesc.setText(Application.getMessage(context, "container_desc"));
            this.folderTypeDescriptions.add(defaultDesc);
            Config wizardCfg = Application.getConfigService(FacesContext.getCurrentInstance()).getConfig((Object)"Space Wizards");
            if (wizardCfg != null) {
                ConfigElement typesCfg = wizardCfg.getConfigElement("folder-types");
                if (typesCfg != null) {
                    for (ConfigElement child : typesCfg.getChildren()) {
                        QName idQName = Repository.resolveToQName(child.getAttribute("name"));
                        if (idQName != null) {
                            TypeDefinition typeDef = this.getDictionaryService().getType(idQName);
                            if (typeDef != null) {
                                if (this.getDictionaryService().isSubClass(typeDef.getName(), ContentModel.TYPE_FOLDER)) {
                                    String icon;
                                    String description;
                                    String label = Utils.getDisplayLabel(context, child);
                                    if (label == null) {
                                        label = typeDef.getTitle();
                                    }
                                    if (label == null) {
                                        label = idQName.getLocalName();
                                    }
                                    if ((description = Utils.getDescription(context, child)) == null) {
                                        description = label;
                                    }
                                    if ((icon = child.getAttribute("icon")) == null || icon.length() == 0) {
                                        icon = DEFAULT_SPACE_TYPE_ICON_PATH;
                                    }
                                    UIListItem item = new UIListItem();
                                    item.setValue(idQName.toString());
                                    item.setLabel(label);
                                    item.setTooltip(label);
                                    item.setImage(icon);
                                    this.folderTypes.add(item);
                                    UIDescription desc = new UIDescription();
                                    desc.setControlValue(idQName.toString());
                                    desc.setText(description);
                                    this.folderTypeDescriptions.add(desc);
                                    continue;
                                }
                                logger.warn((Object)("Failed to add '" + child.getAttribute("name") + "' to the list of folder types as the type is not a subtype of cm:folder"));
                                continue;
                            }
                            logger.warn((Object)("Failed to add '" + child.getAttribute("name") + "' to the list of folder types as the type is not recognised"));
                            continue;
                        }
                        logger.warn((Object)("Failed to add '" + child.getAttribute("name") + "' to the list of folder types as the prefix can not be resolved"));
                    }
                } else {
                    logger.warn((Object)"Could not find 'folder-types' configuration element");
                }
            } else {
                logger.warn((Object)"Could not find 'Space Wizards' configuration section");
            }
        }
        return this.folderTypes;
    }

    public List<UIDescription> getFolderTypeDescriptions() {
        if (this.folderTypeDescriptions == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            this.getFolderTypes();
        }
        return this.folderTypeDescriptions;
    }

    public List<UIListItem> getIcons() {
        ConfigElement iconsCfg;
        ArrayList<UIListItem> icons = null;
        ArrayList<String> iconNames = new ArrayList<String>(8);
        QName type = QName.createQName((String)this.spaceType);
        String typePrefixForm = type.toPrefixString((NamespacePrefixResolver)this.getNamespaceService());
        Config config = Application.getConfigService(FacesContext.getCurrentInstance()).getConfig((Object)(typePrefixForm + " icons"));
        if (config != null && (iconsCfg = config.getConfigElement("icons")) != null) {
            boolean first = true;
            for (ConfigElement icon : iconsCfg.getChildren()) {
                String iconName = icon.getAttribute("name");
                String iconPath = icon.getAttribute("path");
                if (iconName == null || iconPath == null) continue;
                if (first) {
                    icons = new ArrayList(iconsCfg.getChildCount());
                    if (this.icon == null) {
                        this.icon = iconName;
                    }
                    first = false;
                }
                UIListItem item = new UIListItem();
                item.setValue(iconName);
                item.setImage(iconPath);
                icons.add(item);
                iconNames.add(iconName);
            }
        }
        if (icons == null) {
            icons = new ArrayList<UIListItem>(1);
            this.icon = DEFAULT_SPACE_ICON_NAME;
            UIListItem item = new UIListItem();
            item.setValue(DEFAULT_SPACE_ICON_NAME);
            item.setImage("/images/icons/space-icon-default.gif");
            icons.add(item);
            iconNames.add(DEFAULT_SPACE_ICON_NAME);
        }
        if (!iconNames.contains(this.icon)) {
            this.icon = (String)iconNames.get(0);
        }
        return icons;
    }

    @Override
    protected String formatErrorMessage(Throwable exception) {
        if (exception instanceof FileExistsException) {
            return MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_exists"), ((FileExistsException)exception).getName());
        }
        return MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_space"), exception.getMessage());
    }
}

