/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.spaces;

import java.text.MessageFormat;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.spaces.DeleteSpaceDialog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteSpaceAssociationDialog
extends DeleteSpaceDialog {
    private static final Log logger = LogFactory.getLog(DeleteSpaceAssociationDialog.class);

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        Node node = this.browseBean.getActionSpace();
        if (node != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Trying to delete space association: " + node.getId()));
            }
            NodeRef parentRef = this.navigator.getCurrentNode().getNodeRef();
            QName qname = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)node.getName()));
            ChildAssociationRef childAssocRef = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, parentRef, qname, node.getNodeRef());
            this.getNodeService().removeChildAssociation(childAssocRef);
        } else {
            logger.warn((Object)"WARNING: delete called without a current Space!");
        }
        return outcome;
    }

    @Override
    public String getConfirmMessage() {
        Node node = this.browseBean.getActionSpace();
        if (node != null) {
            String spaceConfirmMsg = Application.getMessage(FacesContext.getCurrentInstance(), "delete_space_assoc_confirm");
            return MessageFormat.format(spaceConfirmMsg, node.getName());
        }
        return Application.getMessage(FacesContext.getCurrentInstance(), "delete_node_not_found");
    }
}

