/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.trashcan;

import java.text.MessageFormat;
import java.util.ArrayList;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.trashcan.TrashcanDialog;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;

public class TrashcanDeleteListedItemsDialog
extends TrashcanDialog {
    private static final long serialVersionUID = 5576836588148974609L;
    private static final String MSG_YES = "yes";
    private static final String MSG_NO = "no";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String deleteListedItems(FacesContext context, String outcome) {
        if (this.property.isInProgress()) {
            return null;
        }
        this.property.setInProgress(true);
        try {
            ArrayList<NodeRef> nodeRefs = new ArrayList<NodeRef>(this.property.getListedItems().size());
            for (Node node : this.property.getListedItems()) {
                nodeRefs.add(node.getNodeRef());
            }
            this.property.getNodeArchiveService().purgeArchivedNodes(nodeRefs);
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_generic"), err.getMessage()), err);
            ReportedException.throwIfNecessary(err);
        }
        finally {
            this.property.setInProgress(false);
        }
        return outcome;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return this.deleteListedItems(context, outcome);
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_NO);
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_YES);
    }
}

