/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.users;

import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.users.UsersDialog;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;

public class ChangeMyPasswordDialog
extends UsersDialog {
    private static final long serialVersionUID = 1965846039555088108L;
    private static final String MSG_FINISH_BUTTON = "finish_button";
    private static final String MSG_ERROR_INCORRECT_OLD_PASSWORD = "error_incorrect_old_password";

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        String result = this.changeMyPasswordOK(outcome, context);
        if (result == null) {
            this.isFinished = false;
        }
        return result;
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_FINISH_BUTTON);
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    public String changeMyPasswordOK(String newOutcome, FacesContext newContext) {
        String outcome = newOutcome;
        if (this.properties.getPassword() != null && this.properties.getConfirm() != null && this.properties.getPassword().equals(this.properties.getConfirm())) {
            try {
                String userName = (String)this.properties.getPerson().getProperties().get(ContentModel.PROP_USERNAME);
                this.properties.getAuthenticationService().updateAuthentication(userName, this.properties.getOldPassword().toCharArray(), this.properties.getPassword().toCharArray());
            }
            catch (Exception e) {
                outcome = null;
                Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_INCORRECT_OLD_PASSWORD));
                ReportedException.throwIfNecessary(e);
            }
        } else {
            outcome = null;
            Utils.addErrorMessage(Application.getMessage(newContext, "error_password_match"));
        }
        return outcome;
    }
}

