/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.users;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.MapNode;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteUserDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -4977064287365766306L;
    private static Log logger = LogFactory.getLog(DeleteUserDialog.class);
    private static final String ERROR_DELETE = "error_delete_user";
    private static final String BUTTON_YES = "yes";
    private static final String MSG_TITLE_DELETE_USER = "title_delete_user";
    private static final String BUTTON_NO = "no";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";
    private transient AuthenticationService authenticationService;
    private List<Node> users = Collections.emptyList();
    private transient PersonService personService;
    private Node person = null;
    private String searchCriteria = null;

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        try {
            String userName = (String)this.getPerson().getProperties().get("userName");
            this.getPersonService().deletePerson(userName);
            this.search();
        }
        catch (Throwable e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, ERROR_DELETE), e.getMessage()), e);
            ReportedException.throwIfNecessary(e);
        }
        return outcome;
    }

    public String search() {
        if (this.searchCriteria == null || this.searchCriteria.length() == 0) {
            this.users = Collections.emptyList();
        } else {
            FacesContext context = FacesContext.getCurrentInstance();
            UserTransaction tx = null;
            try {
                tx = Repository.getUserTransaction(context, true);
                tx.begin();
                String search = ISO9075.encode((String)this.searchCriteria);
                ArrayList<Pair> filter = new ArrayList<Pair>();
                filter.add(new Pair((Object)ContentModel.PROP_FIRSTNAME, (Object)search));
                filter.add(new Pair((Object)ContentModel.PROP_LASTNAME, (Object)search));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Query filter: " + filter));
                }
                List persons = this.getPersonService().getPeople(filter, true, Utils.generatePersonSort(), new PagingRequest(Utils.getPersonMaxResults(), null)).getPage();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found " + persons.size() + " users"));
                }
                this.users = new ArrayList<Node>(persons.size());
                for (PersonService.PersonInfo person : persons) {
                    MapNode node = new MapNode(person.getNodeRef());
                    Map<String, Object> props = node.getProperties();
                    props.put("fullName", (String)props.get("firstName") + ' ' + (String)props.get("lastName"));
                    NodeRef homeFolderNodeRef = (NodeRef)props.get("homeFolder");
                    if (homeFolderNodeRef != null) {
                        props.put("homeSpace", homeFolderNodeRef);
                    }
                    this.users.add(node);
                }
                tx.commit();
            }
            catch (InvalidNodeRefException refErr) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_noderef"), "root"));
                this.users = Collections.emptyList();
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {}
            }
            catch (Exception err) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_generic"), err.getMessage()), err);
                this.users = Collections.emptyList();
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public void setupUserAction(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Setup for action, setting current Person to: " + id));
            }
            try {
                NodeRef ref = new NodeRef(Repository.getStoreRef(), id);
                Node node = new Node(ref);
                this.setPerson(node);
            }
            catch (InvalidNodeRefException refErr) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), id));
            }
        } else {
            this.setPerson(null);
        }
    }

    public AuthenticationService getAuthenticationService() {
        if (this.authenticationService == null) {
            this.authenticationService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAuthenticationService();
        }
        return this.authenticationService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPersonService();
        }
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public Node getPerson() {
        return this.person;
    }

    public void setPerson(Node person) {
        this.person = person;
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), BUTTON_NO);
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), BUTTON_YES);
    }

    @Override
    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Application.getMessage(fc, MSG_TITLE_DELETE_USER) + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + this.getPerson().getProperties().get("userName") + Application.getMessage(fc, MSG_RIGHT_QUOTE);
    }
}

