/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.users;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.users.UsersBeanProperties;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;

public class EditUserDetailsDialog
extends BaseDialogBean {
    private static final long serialVersionUID = 8663254425262484L;
    private Node person;
    protected UsersBeanProperties properties;
    private NodeRef photoRef;
    private String personDescription;

    public void setProperties(UsersBeanProperties properties) {
        this.properties = properties;
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.person = this.properties.getPerson();
        this.photoRef = null;
        this.personDescription = null;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        try {
            ServiceRegistry services = Repository.getServiceRegistry(FacesContext.getCurrentInstance());
            DictionaryService dd = services.getDictionaryService();
            Map props = this.getNodeService().getProperties(this.getPerson().getNodeRef());
            for (String key : this.getPerson().getProperties().keySet()) {
                QName propQName = QName.createQName((String)key);
                if (dd.getProperty(propQName) != null && dd.getProperty(propQName).isProtected()) continue;
                props.put(propQName, (Serializable)this.getPerson().getProperties().get(key));
            }
            NodeRef personRef = this.getPerson().getNodeRef();
            this.getNodeService().setProperties(personRef, props);
            if (this.personDescription != null) {
                ContentService cs = services.getContentService();
                ContentWriter writer = cs.getWriter(personRef, ContentModel.PROP_PERSONDESC, true);
                writer.setMimetype("text/html");
                writer.putContent(this.personDescription);
            }
            if (this.photoRef != null) {
                List refs = this.getNodeService().getTargetAssocs(personRef, (QNamePattern)ContentModel.ASSOC_AVATAR);
                if (refs.size() == 1) {
                    NodeRef existingRef = ((AssociationRef)refs.get(0)).getTargetRef();
                    this.getNodeService().removeAssociation(personRef, existingRef, ContentModel.ASSOC_AVATAR);
                }
                this.getNodeService().createAssociation(personRef, this.photoRef, ContentModel.ASSOC_AVATAR);
            }
            Application.getCurrentUser(context).reset();
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_generic"), err.getMessage()), err);
            outcome = null;
            ReportedException.throwIfNecessary(err);
        }
        return outcome;
    }

    public Node getPerson() {
        return this.person;
    }

    public String getEmail() {
        Object value = this.person.getProperties().get(ContentModel.PROP_EMAIL);
        return value == null ? null : value.toString();
    }

    public void setEmail(String email) {
        this.person.getProperties().put(ContentModel.PROP_EMAIL.toString(), email);
    }

    public String getFirstName() {
        Object value = this.person.getProperties().get(ContentModel.PROP_FIRSTNAME);
        return value == null ? null : value.toString();
    }

    public void setFirstName(String firstName) {
        this.person.getProperties().put(ContentModel.PROP_FIRSTNAME.toString(), firstName);
    }

    public String getLastName() {
        Object value = this.person.getProperties().get(ContentModel.PROP_LASTNAME);
        return value == null ? null : value.toString();
    }

    public String getPersonDescription() {
        ContentService cs;
        ContentReader reader;
        if (this.personDescription == null && (reader = (cs = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getContentService()).getReader(this.person.getNodeRef(), ContentModel.PROP_PERSONDESC)) != null && reader.exists()) {
            this.personDescription = reader.getContentString();
        }
        return this.personDescription;
    }

    public void setPersonDescription(String s) {
        this.personDescription = s;
    }

    public void setLastName(String lastName) {
        this.person.getProperties().put(ContentModel.PROP_LASTNAME.toString(), lastName);
    }

    public Map<String, Object> getPersonProperties() {
        return this.person.getProperties();
    }

    public NodeRef getPersonPhotoRef() {
        List refs;
        if (this.photoRef == null && (refs = this.getNodeService().getTargetAssocs(this.person.getNodeRef(), (QNamePattern)ContentModel.ASSOC_AVATAR)).size() == 1) {
            this.photoRef = ((AssociationRef)refs.get(0)).getTargetRef();
        }
        return this.photoRef;
    }

    public void setPersonPhotoRef(NodeRef ref) {
        this.photoRef = ref;
    }
}

