/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.users;

import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.users.CreateUserWizard;
import org.alfresco.web.bean.users.UsersBeanProperties;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EditUserWizard
extends CreateUserWizard {
    private static final long serialVersionUID = 7529989488476324511L;
    private static Log logger = LogFactory.getLog(EditUserWizard.class);
    protected UsersBeanProperties properties;

    public void setProperties(UsersBeanProperties properties) {
        this.properties = properties;
    }

    @Override
    public void init(Map<String, String> arg0) {
        super.init(arg0);
        Map<String, Object> props = this.properties.getPerson().getProperties();
        this.firstName = (String)props.get("firstName");
        this.lastName = (String)props.get("lastName");
        this.userName = (String)props.get("userName");
        this.email = (String)props.get("email");
        this.companyId = (String)props.get("organizationId");
        this.organisation = (String)props.get("organization");
        this.jobtitle = (String)props.get("jobtitle");
        this.location = (String)props.get("location");
        this.presenceProvider = (String)props.get("presenceProvider");
        this.presenceUsername = (String)props.get("presenceUsername");
        this.sizeQuota = (Long)props.get("sizeQuota");
        if (this.sizeQuota != null && this.sizeQuota == -1L) {
            this.sizeQuota = null;
        }
        if (this.sizeQuota != null) {
            Pair<Long, String> size = this.convertFromBytes(this.sizeQuota);
            this.sizeQuota = (Long)size.getFirst();
            this.sizeQuotaUnits = (String)size.getSecond();
        }
        this.homeSpaceLocation = null;
        NodeRef homeFolderRef = (NodeRef)props.get("homeFolder");
        if (homeFolderRef != null && this.getNodeService().exists(homeFolderRef)) {
            ChildAssociationRef childAssocRef = this.getNodeService().getPrimaryParent(homeFolderRef);
            NodeRef parentRef = childAssocRef.getParentRef();
            if (!this.getNodeService().getRootNode(Repository.getStoreRef()).equals((Object)parentRef)) {
                this.homeSpaceLocation = parentRef;
                this.homeSpaceName = Repository.getNameForNode(this.getNodeService(), homeFolderRef);
            } else {
                this.homeSpaceLocation = homeFolderRef;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Edit user home space location: " + this.homeSpaceLocation + " home space name: " + this.homeSpaceName));
        }
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        try {
            NodeRef nodeRef = this.properties.getPerson().getNodeRef();
            Map props = this.getNodeService().getProperties(nodeRef);
            NodeRef oldHomeFolderRef = (NodeRef)this.getNodeService().getProperty(nodeRef, ContentModel.PROP_HOMEFOLDER);
            if (oldHomeFolderRef != null && !this.getNodeService().exists(oldHomeFolderRef)) {
                oldHomeFolderRef = null;
            }
            this.setPersonPropertiesAndCreateHomeSpaceIfNeeded(props, oldHomeFolderRef, context);
            this.getNodeService().setProperties(nodeRef, props);
            if (this.sizeQuota != null && this.sizeQuota < 0L) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_negative_quota"), this.sizeQuota));
                outcome = null;
            } else {
                this.putSizeQuotaProperty(this.userName, this.sizeQuota, this.sizeQuotaUnits);
            }
        }
        catch (Throwable e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_person"), e.getMessage()), e);
            outcome = null;
            ReportedException.throwIfNecessary(e);
        }
        if (outcome == null) {
            this.isFinished = false;
        }
        return outcome;
    }

    @Override
    public Map getPersonPropertiesImmutability() {
        return this.properties.getImmutability();
    }
}

