/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.users;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.IContextListener;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.TemplateMailHelperBean;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.MapNode;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.bean.users.UserMembersBean;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.repo.component.UIUserGroupPicker;
import org.springframework.mail.javamail.JavaMailSender;

public class EmailSpaceUsersDialog
extends BaseDialogBean
implements IContextListener {
    private static final long serialVersionUID = 7925542142116904285L;
    private static final String PROP_DUPLICATE = "duplicate";
    private static final String PROP_PARENT = "parent";
    private static final String PROP_ID = "id";
    private static final String PROP_ISGROUP = "isGroup";
    private static final String PROP_ICON = "icon";
    private static final String PROP_FULLNAME = "fullName";
    private static final String PROP_ROLES = "roles";
    private static final String PROP_EXPANDED = "expanded";
    private static final String PROP_SELECTED = "selected";
    private static final String PROP_USERNAME = "userName";
    private transient PermissionService permissionService;
    private transient PersonService personService;
    private transient AuthorityService authorityService;
    private transient JavaMailSender mailSender;
    protected TemplateMailHelperBean mailHelper;
    private List<Map> usersGroups = null;
    private Map<String, Map> userGroupLookup = new HashMap<String, Map>();

    public EmailSpaceUsersDialog() {
        UIContextService.getInstance(FacesContext.getCurrentInstance()).registerBean(this);
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.mailHelper = new TemplateMailHelperBean();
        this.mailHelper.setMailSender(this.getMailSender());
        this.mailHelper.setNodeService(this.getNodeService());
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        NodeRef spaceRef = this.getSpace().getNodeRef();
        User user = Application.getCurrentUser(context);
        String from = (String)((Object)this.getNodeService().getProperty(user.getPerson(), ContentModel.PROP_EMAIL));
        if (from == null || from.length() == 0) {
            from = Application.getClientConfig(context).getFromEmailAddress();
        }
        HashSet<String> mailedAuthorities = new HashSet<String>(this.usersGroups.size());
        for (Map node : this.usersGroups) {
            boolean expanded;
            String authority = (String)node.get(PROP_USERNAME);
            boolean selected = (Boolean)node.get(PROP_SELECTED);
            AuthorityType authType = AuthorityType.getAuthorityType((String)authority);
            if (authType.equals((Object)AuthorityType.USER)) {
                if (!selected || !this.getPersonService().personExists(authority) || mailedAuthorities.contains(authority)) continue;
                this.mailHelper.notifyUser(this.getPersonService().getPerson(authority), spaceRef, from, (String)node.get(PROP_ROLES));
                mailedAuthorities.add(authority);
                continue;
            }
            if (!authType.equals((Object)AuthorityType.GROUP) || (expanded = ((Boolean)node.get(PROP_EXPANDED)).booleanValue()) || !selected) continue;
            Set users = this.getAuthorityService().getContainedAuthorities(AuthorityType.USER, authority, false);
            for (String userAuth : users) {
                if (!this.getPersonService().personExists(userAuth) || mailedAuthorities.contains(userAuth)) continue;
                this.mailHelper.notifyUser(this.getPersonService().getPerson(userAuth), spaceRef, from, (String)node.get(PROP_ROLES));
                mailedAuthorities.add(userAuth);
            }
        }
        return outcome;
    }

    @Override
    public void contextUpdated() {
        this.usersGroups = null;
        this.userGroupLookup = new HashMap<String, Map>();
    }

    @Override
    public void areaChanged() {
    }

    @Override
    public void spaceChanged() {
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    protected PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPermissionService();
        }
        return this.permissionService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPersonService();
        }
        return this.personService;
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    protected JavaMailSender getMailSender() {
        if (this.mailSender == null) {
            this.mailSender = (JavaMailSender)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "mailService");
        }
        return this.mailSender;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    protected AuthorityService getAuthorityService() {
        if (this.authorityService == null) {
            this.authorityService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAuthorityService();
        }
        return this.authorityService;
    }

    public Node getSpace() {
        return this.browseBean.getActionSpace();
    }

    public List<Map> getUsersGroups() {
        if (this.usersGroups == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            UserTransaction tx = null;
            try {
                tx = Repository.getUserTransaction(context, true);
                tx.begin();
                final String currentAuthority = Application.getCurrentUser(context).getUserName();
                Map permissionMap = (Map)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Map<String, List<String>>>(){

                    public Map<String, List<String>> doWork() throws Exception {
                        NodeRef spaceRef = EmailSpaceUsersDialog.this.getSpace().getNodeRef();
                        HashMap<String, List<String>> permissionMap = new HashMap<String, List<String>>(8, 1.0f);
                        while (spaceRef != null) {
                            Set permissions = EmailSpaceUsersDialog.this.getPermissionService().getAllSetPermissions(spaceRef);
                            for (AccessPermission permission : permissions) {
                                String authority;
                                if (permission.getAccessStatus() != AccessStatus.ALLOWED || permission.getAuthorityType() != AuthorityType.USER && permission.getAuthorityType() != AuthorityType.GROUP || currentAuthority.equals(authority = permission.getAuthority())) continue;
                                ArrayList<String> userPermissions = (ArrayList<String>)permissionMap.get(authority);
                                if (userPermissions == null) {
                                    userPermissions = new ArrayList<String>(4);
                                    permissionMap.put(authority, userPermissions);
                                }
                                userPermissions.add(permission.getPermission());
                            }
                            if (EmailSpaceUsersDialog.this.getPermissionService().getInheritParentPermissions(spaceRef)) {
                                spaceRef = EmailSpaceUsersDialog.this.getNodeService().getPrimaryParent(spaceRef).getParentRef();
                                continue;
                            }
                            spaceRef = null;
                        }
                        return permissionMap;
                    }
                }, (String)"System");
                this.usersGroups = new LinkedList<Map>();
                for (String authority : permissionMap.keySet()) {
                    Map node = this.buildAuthorityMap(authority, UserMembersBean.roleListToString(context, (List)permissionMap.get(authority)));
                    if (node == null) continue;
                    this.usersGroups.add(node);
                }
                tx.commit();
            }
            catch (InvalidNodeRefException refErr) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_noderef"), refErr.getNodeRef()));
                this.usersGroups = Collections.emptyList();
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {}
            }
            catch (Throwable err) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_generic"), err.getMessage()), err);
                this.usersGroups = Collections.emptyList();
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {
                    // empty catch block
                }
            }
        }
        return this.usersGroups;
    }

    public TemplateMailHelperBean getMailHelper() {
        return this.mailHelper;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        boolean disabled = true;
        if (this.usersGroups != null) {
            for (Map userGroup : this.usersGroups) {
                if (((Boolean)userGroup.get(PROP_EXPANDED)).booleanValue() || !((Boolean)userGroup.get(PROP_SELECTED)).booleanValue()) continue;
                disabled = false;
                break;
            }
        }
        return disabled;
    }

    public void userGroupSelectorAction(ActionEvent event) {
        if (event instanceof UIUserGroupPicker.PickerEvent) {
            int index;
            UIUserGroupPicker.PickerEvent pickerEvent = (UIUserGroupPicker.PickerEvent)event;
            Map userGroup = null;
            for (index = 0; index < this.usersGroups.size(); ++index) {
                if (!pickerEvent.Authority.equals(this.usersGroups.get(index).get(PROP_ID))) continue;
                userGroup = this.usersGroups.get(index);
                break;
            }
            if (userGroup != null) {
                switch (pickerEvent.Action) {
                    case 0: {
                        boolean expanded = (Boolean)userGroup.get(PROP_EXPANDED);
                        userGroup.put(PROP_EXPANDED, !expanded);
                        if (!expanded) {
                            boolean selected = (Boolean)userGroup.get(PROP_SELECTED);
                            String currentAuthority = Application.getCurrentUser(FacesContext.getCurrentInstance()).getUserName();
                            Set authorities = this.getAuthorityService().getContainedAuthorities(null, pickerEvent.Authority, true);
                            for (String authority : authorities) {
                                Map node;
                                if (currentAuthority.equals(authority) || AuthorityType.getAuthorityType((String)authority) != AuthorityType.USER && AuthorityType.getAuthorityType((String)authority) != AuthorityType.GROUP || (node = this.buildAuthorityMap(authority, (String)userGroup.get(PROP_ROLES))) == null) continue;
                                node.put(PROP_PARENT, userGroup);
                                node.put(PROP_SELECTED, selected);
                                this.usersGroups.add(++index, node);
                            }
                        } else {
                            ++index;
                            while (index < this.usersGroups.size()) {
                                Map node = this.usersGroups.get(index);
                                boolean foundParent = false;
                                for (Map parent = (Map)node.get(PROP_PARENT); parent != null && !foundParent; parent = (Map)parent.get(PROP_PARENT)) {
                                    if (parent != userGroup) continue;
                                    foundParent = true;
                                }
                                if (foundParent) {
                                    if (!((Boolean)node.get(PROP_DUPLICATE)).booleanValue()) {
                                        this.userGroupLookup.remove((String)node.get(PROP_USERNAME));
                                    }
                                    this.usersGroups.remove(index);
                                    continue;
                                }
                                ++index;
                            }
                        }
                        break;
                    }
                    case 1: {
                        boolean selected = (Boolean)userGroup.get(PROP_SELECTED);
                        userGroup.put(PROP_SELECTED, !selected);
                    }
                }
            }
        }
    }

    private Map buildAuthorityMap(String authority, String roles) {
        Map<String, Object> node = null;
        if (AuthorityType.getAuthorityType((String)authority) == AuthorityType.GUEST || this.getPersonService().personExists(authority)) {
            NodeRef nodeRef = this.getPersonService().getPerson(authority);
            if (nodeRef != null) {
                node = new MapNode(nodeRef);
                Map<String, Object> props = ((Node)((Object)node)).getProperties();
                props.put(PROP_FULLNAME, (String)props.get("firstName") + ' ' + (String)props.get("lastName"));
                props.put(PROP_ICON, "/images/icons/person.gif");
                props.put(PROP_ISGROUP, false);
            }
        } else if (AuthorityType.getAuthorityType((String)authority) == AuthorityType.GROUP) {
            node = new HashMap(8, 1.0f);
            String groupDisplayName = this.authorityService.getAuthorityDisplayName(authority);
            if (groupDisplayName == null || groupDisplayName.length() == 0) {
                groupDisplayName = authority.startsWith("GROUP_") ? authority.substring("GROUP_".length()) : authority;
            }
            node.put(PROP_FULLNAME, groupDisplayName);
            node.put(PROP_USERNAME, authority);
            node.put(PROP_ID, authority);
            node.put(PROP_ICON, "/images/icons/group.gif");
            node.put(PROP_ISGROUP, true);
        }
        if (node != null) {
            node.put(PROP_ROLES, roles);
            node.put(PROP_PARENT, null);
            node.put(PROP_EXPANDED, false);
            if (this.userGroupLookup.get(authority) != null) {
                node.put(PROP_DUPLICATE, true);
                node.put(PROP_SELECTED, false);
            } else {
                this.userGroupLookup.put(authority, node);
                node.put(PROP_DUPLICATE, false);
                node.put(PROP_SELECTED, true);
            }
        }
        return node;
    }
}

