/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.users;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.sync.UserRegistrySynchronizer;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.usage.ContentUsageService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.web.app.servlet.DownloadContentServlet;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.data.UIRichList;
import org.springframework.web.jsf.FacesContextUtils;

public class UsersBeanProperties
implements Serializable {
    private static final long serialVersionUID = 8874192805959149144L;
    private transient NodeService nodeService;
    private transient SearchService searchService;
    private transient MutableAuthenticationService authenticationService;
    private transient PersonService personService;
    private transient ContentUsageService contentUsageService;
    private transient UserRegistrySynchronizer userRegistrySynchronizer;
    private UIRichList usersRichList;
    private Node person = null;
    private String password = null;
    private String oldPassword = null;
    private String confirm = null;
    private String searchCriteria = null;
    private String userName = null;
    private Map<String, Boolean> immutabilty = null;

    public NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public SearchService getSearchService() {
        if (this.searchService == null) {
            this.searchService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getSearchService();
        }
        return this.searchService;
    }

    public MutableAuthenticationService getAuthenticationService() {
        if (this.authenticationService == null) {
            this.authenticationService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAuthenticationService();
        }
        return this.authenticationService;
    }

    public PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPersonService();
        }
        return this.personService;
    }

    public ContentUsageService getContentUsageService() {
        if (this.contentUsageService == null) {
            this.contentUsageService = (ContentUsageService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "ContentUsageService");
        }
        return this.contentUsageService;
    }

    public UserRegistrySynchronizer getUserRegistrySynchronizer() {
        if (this.userRegistrySynchronizer == null) {
            this.userRegistrySynchronizer = (UserRegistrySynchronizer)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)FacesContext.getCurrentInstance()).getBean("userRegistrySynchronizer");
        }
        return this.userRegistrySynchronizer;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setAuthenticationService(MutableAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setContentUsageService(ContentUsageService contentUsageService) {
        this.contentUsageService = contentUsageService;
    }

    public void setUserRegistrySynchronizer(UserRegistrySynchronizer userRegistrySynchronizer) {
        this.userRegistrySynchronizer = userRegistrySynchronizer;
    }

    public UIRichList getUsersRichList() {
        return this.usersRichList;
    }

    public void setUsersRichList(UIRichList usersRichList) {
        this.usersRichList = usersRichList;
    }

    public String getSearchCriteria() {
        return this.searchCriteria;
    }

    public void setSearchCriteria(String searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getOldPassword() {
        return this.oldPassword;
    }

    public void setOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
    }

    public Node getPerson() {
        return this.person;
    }

    public void setPerson(final Node p) {
        FacesContext context = FacesContext.getCurrentInstance();
        RetryingTransactionHelper txnHelper = Repository.getRetryingTransactionHelper(context);
        RetryingTransactionHelper.RetryingTransactionCallback callback = new RetryingTransactionHelper.RetryingTransactionCallback(){

            public Object execute() throws Throwable {
                UsersBeanProperties.this.person = p;
                UsersBeanProperties.this.userName = (String)UsersBeanProperties.this.person.getProperties().get(ContentModel.PROP_USERNAME);
                UsersBeanProperties.this.immutabilty = new PropertyImmutabilityMap(UsersBeanProperties.this.getUserRegistrySynchronizer().getPersonMappedProperties(UsersBeanProperties.this.userName));
                return null;
            }
        };
        try {
            txnHelper.doInTransaction(callback, false);
        }
        catch (Throwable e) {
            if (!(e instanceof ReportedException)) {
                Utils.addErrorMessage(e.getMessage(), e);
            }
            ReportedException.throwIfNecessary(e);
        }
    }

    public Long getUserUsage(String userName) {
        long usage = this.getContentUsageService().getUserUsage(userName);
        return usage == -1L ? null : Long.valueOf(usage);
    }

    public Long getUserUsage() {
        long usage = this.getContentUsageService().getUserUsage(this.userName);
        return usage == -1L ? null : Long.valueOf(usage);
    }

    public Long getUserQuota() {
        long quota = this.getContentUsageService().getUserQuota(this.userName);
        return quota == -1L ? null : Long.valueOf(quota);
    }

    public boolean getUsagesEnabled() {
        return this.getContentUsageService().getEnabled();
    }

    public String getPersonDescription() {
        ContentService cs = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getContentService();
        ContentReader reader = cs.getReader(this.person.getNodeRef(), ContentModel.PROP_PERSONDESC);
        if (reader != null && reader.exists()) {
            return Utils.stripUnsafeHTMLTags((String)reader.getContentString()).replace("\r\n", "<p>");
        }
        return null;
    }

    public String getAvatarUrl() {
        String avatarUrl = null;
        List refs = this.getNodeService().getTargetAssocs(this.person.getNodeRef(), (QNamePattern)ContentModel.ASSOC_AVATAR);
        if (refs.size() == 1) {
            NodeRef photoRef = ((AssociationRef)refs.get(0)).getTargetRef();
            String name = (String)((Object)this.getNodeService().getProperty(photoRef, ContentModel.PROP_NAME));
            avatarUrl = DownloadContentServlet.generateBrowserURL(photoRef, name);
        }
        return avatarUrl;
    }

    public Map<String, Boolean> getImmutability() {
        return this.immutabilty;
    }

    public class PropertyImmutabilityMap
    implements Map<String, Boolean>,
    Serializable {
        private final Set<QName> props;

        PropertyImmutabilityMap(Set<QName> props) {
            this.props = props;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean containsKey(Object k) {
            boolean contains = false;
            if (k instanceof String && ((String)k).length() != 0) {
                String s = (String)k;
                contains = s.charAt(0) == '{' && s.indexOf(125) != -1 ? this.props.contains(k) : this.props.contains(QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)s));
            }
            return contains;
        }

        @Override
        public boolean containsValue(Object v) {
            return false;
        }

        @Override
        public Set<Map.Entry<String, Boolean>> entrySet() {
            return null;
        }

        @Override
        public Boolean get(Object k) {
            return this.containsKey(k);
        }

        @Override
        public boolean isEmpty() {
            return this.props.size() != 0;
        }

        @Override
        public Set<String> keySet() {
            return null;
        }

        @Override
        public Boolean put(String k, Boolean v) {
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Boolean> m) {
        }

        @Override
        public Boolean remove(Object k) {
            return null;
        }

        @Override
        public int size() {
            return this.props.size();
        }

        @Override
        public Collection<Boolean> values() {
            return null;
        }
    }
}

