/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.users;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.IContextListener;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.dialog.ChangeViewSupport;
import org.alfresco.web.bean.repository.MapNode;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.NodePropertyResolver;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.users.UsersBeanProperties;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.UIListItem;
import org.alfresco.web.ui.common.component.UIModeList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UsersDialog
extends BaseDialogBean
implements IContextListener,
ChangeViewSupport {
    private static final long serialVersionUID = 7613786955971599967L;
    private static Log logger = LogFactory.getLog(UsersDialog.class);
    public static String BEAN_NAME = "UsersDialog";
    public static final String ERROR_PASSWORD_MATCH = "error_password_match";
    public static final String ERROR_NEGATIVE_QUOTA = "error_negative_quota";
    private static final String ERROR_DELETE = "error_delete_user";
    private static final String DIALOG_CLOSE = "dialog:close";
    private static final String VIEW_DETAILS = "user_details";
    private static final String LABEL_VIEW_DETAILS = "user_details";
    protected String viewMode = "user_details";
    protected UsersBeanProperties properties;
    private List<Node> users = Collections.emptyList();
    public NodePropertyResolver resolverUserSizeLatest = new NodePropertyResolver(){

        @Override
        public Object get(Node personNode) {
            return UsersDialog.this.properties.getUserUsage((String)personNode.getProperties().get("userName"));
        }
    };
    public NodePropertyResolver resolverUserQuota = new NodePropertyResolver(){

        @Override
        public Object get(Node personNode) {
            Long quota = (Long)personNode.getProperties().get("sizeQuota");
            return quota != null && quota != -1L ? quota : null;
        }
    };
    public NodePropertyResolver resolverUserMutable = new NodePropertyResolver(){

        @Override
        public Object get(Node personNode) {
            return UsersDialog.this.properties.getAuthenticationService().isAuthenticationMutable((String)personNode.getProperties().get("userName"));
        }
    };

    public UsersDialog() {
        UIContextService.getInstance(FacesContext.getCurrentInstance()).registerBean(this);
    }

    public void setProperties(UsersBeanProperties properties) {
        this.properties = properties;
    }

    public List<Node> getUsers() {
        if (this.users == null) {
            this.search();
        }
        return this.users;
    }

    public int getUsersSize() {
        return this.getUsers().size();
    }

    public Long getUsersTotalUsage() {
        Long totalUsage = null;
        List<Node> users = this.getUsers();
        for (Node user : users) {
            Long sizeLatest = this.properties.getUserUsage((String)user.getProperties().get("userName"));
            if (sizeLatest == null || sizeLatest == -1L) continue;
            if (totalUsage == null) {
                totalUsage = 0L;
            }
            totalUsage = totalUsage + sizeLatest;
        }
        return totalUsage;
    }

    public Long getUsersTotalQuota() {
        Long totalQuota = null;
        List<Node> users = this.getUsers();
        for (Node user : users) {
            Long sizeCurrent = (Long)user.getProperties().get("sizeQuota");
            if (sizeCurrent == null || sizeCurrent == -1L) continue;
            if (totalQuota == null) {
                totalQuota = 0L;
            }
            totalQuota = totalQuota + sizeCurrent;
        }
        return totalQuota;
    }

    public void setupUserAction(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        this.setupUserAction(params.get("id"));
    }

    public void setupUserAction(String personId) {
        if (personId != null && personId.length() != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Setup for action, setting current Person to: " + personId));
            }
            try {
                NodeRef ref = new NodeRef(Repository.getStoreRef(), personId);
                Node node = new Node(ref);
                this.properties.setPerson(node);
                this.contextUpdated();
            }
            catch (InvalidNodeRefException refErr) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), personId));
            }
        } else {
            this.properties.setPerson(null);
        }
    }

    public String deleteOK() {
        FacesContext context = FacesContext.getCurrentInstance();
        try {
            String userName = (String)this.properties.getPerson().getProperties().get("userName");
            this.properties.getPersonService().deletePerson(userName);
            this.search();
        }
        catch (Throwable e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, ERROR_DELETE), e.getMessage()), e);
            ReportedException.throwIfNecessary(e);
        }
        return DIALOG_CLOSE;
    }

    public String changeUserDetails() {
        String outcome = DIALOG_CLOSE;
        FacesContext context = FacesContext.getCurrentInstance();
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(context);
            tx.begin();
            Map props = this.properties.getNodeService().getProperties(this.properties.getPerson().getNodeRef());
            props.put(ContentModel.PROP_FIRSTNAME, (String)this.properties.getPerson().getProperties().get(ContentModel.PROP_FIRSTNAME));
            props.put(ContentModel.PROP_LASTNAME, (String)this.properties.getPerson().getProperties().get(ContentModel.PROP_LASTNAME));
            props.put(ContentModel.PROP_EMAIL, (String)this.properties.getPerson().getProperties().get(ContentModel.PROP_EMAIL));
            this.properties.getNodeService().setProperties(this.properties.getPerson().getNodeRef(), props);
            tx.commit();
            Application.getCurrentUser(context).reset();
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_generic"), err.getMessage()), err);
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
        return outcome;
    }

    public String search() {
        this.properties.getUsersRichList().setValue(null);
        if (this.properties.getSearchCriteria() == null || this.properties.getSearchCriteria().trim().length() == 0) {
            this.users = Collections.emptyList();
        } else {
            FacesContext context = FacesContext.getCurrentInstance();
            UserTransaction tx = null;
            try {
                tx = Repository.getUserTransaction(context, true);
                tx.begin();
                String search = this.properties.getSearchCriteria();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Query filter: " + search));
                }
                List persons = this.properties.getPersonService().getPeople(Utils.generatePersonFilter(search), true, Utils.generatePersonSort(), new PagingRequest(Utils.getPersonMaxResults(), null)).getPage();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found " + persons.size() + " users"));
                }
                this.users = new ArrayList<Node>(persons.size());
                for (PersonService.PersonInfo person : persons) {
                    MapNode node = new MapNode(person.getNodeRef());
                    Map<String, Object> props = node.getProperties();
                    String firstName = (String)props.get("firstName");
                    String lastName = (String)props.get("lastName");
                    props.put("fullName", (firstName != null ? firstName : "") + ' ' + (lastName != null ? lastName : ""));
                    NodeRef homeFolderNodeRef = (NodeRef)props.get("homeFolder");
                    if (homeFolderNodeRef != null) {
                        props.put("homeSpace", homeFolderNodeRef);
                    }
                    node.addPropertyResolver("sizeLatest", this.resolverUserSizeLatest);
                    node.addPropertyResolver("quota", this.resolverUserQuota);
                    node.addPropertyResolver("isMutable", this.resolverUserMutable);
                    this.users.add(node);
                }
                tx.commit();
            }
            catch (InvalidNodeRefException refErr) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_noderef"), "root"));
                this.users = Collections.emptyList();
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {}
            }
            catch (Exception err) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_generic"), err.getMessage()), err);
                this.users = Collections.emptyList();
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public String showAll() {
        this.properties.getUsersRichList().setValue(null);
        this.users = Repository.getUsers(FacesContext.getCurrentInstance(), this.properties.getNodeService(), this.properties.getPersonService());
        for (Node node : this.users) {
            node.addPropertyResolver("sizeLatest", this.resolverUserSizeLatest);
            node.addPropertyResolver("quota", this.resolverUserQuota);
            node.addPropertyResolver("isMutable", this.resolverUserMutable);
        }
        return null;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return null;
    }

    @Override
    public String cancel() {
        this.contextUpdated();
        return super.cancel();
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "close");
    }

    @Override
    public Object getActionsContext() {
        return this;
    }

    @Override
    public List<UIListItem> getViewItems() {
        FacesContext context = FacesContext.getCurrentInstance();
        ArrayList<UIListItem> items = new ArrayList<UIListItem>(1);
        UIListItem item1 = new UIListItem();
        item1.setValue("user_details");
        item1.setLabel(Application.getMessage(context, "user_details"));
        items.add(item1);
        return items;
    }

    @Override
    public String getViewMode() {
        return this.viewMode;
    }

    @Override
    public void setViewMode(String viewMode) {
        this.viewMode = viewMode;
    }

    @Override
    public void viewModeChanged(ActionEvent event) {
        UIModeList viewList = (UIModeList)event.getComponent();
        this.setViewMode(viewList.getValue().toString());
    }

    @Override
    public void contextUpdated() {
        if (this.properties.getUsersRichList() != null) {
            this.properties.getUsersRichList().setValue(null);
            this.users = null;
        }
    }

    @Override
    public void areaChanged() {
    }

    @Override
    public void spaceChanged() {
    }
}

