/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.WCMModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.LayeringDescriptor;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.namespace.QName;
import org.alfresco.wcm.asset.AssetInfo;
import org.alfresco.wcm.asset.AssetInfoImpl;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.NodePropertyResolver;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.AVMWorkflowUtil;

public class AVMNode
extends Node
implements Map<String, Object> {
    private static final long serialVersionUID = 2200295347489543757L;
    public static final NodePropertyResolver RESOLVER_PREVIEW_URL = new NodePropertyResolver(){
        private static final long serialVersionUID = -8437274476137672895L;

        @Override
        public Object get(Node node) {
            if (!(node instanceof AVMNode)) {
                return null;
            }
            String storeId = AVMUtil.getStoreName(node.getPath());
            String assetPath = AVMUtil.getStoreRelativePath(node.getPath());
            return AVMUtil.getPreviewURI(storeId, assetPath);
        }
    };
    public static final NodePropertyResolver RESOLVER_SANDBOX_RELATIVE_PATH = new NodePropertyResolver(){
        private static final long serialVersionUID = -2367701285830581225L;

        @Override
        public Object get(Node node) {
            if (!(node instanceof AVMNode)) {
                return null;
            }
            String s = node.getPath();
            s = AVMUtil.getSandboxRelativePath(s);
            Path result = new Path();
            String[] parts = s.split("/");
            for (int i = 1; i < parts.length; ++i) {
                if (parts[i].length() == 0) continue;
                final String s2 = parts[i];
                result.append(new Path.Element(){

                    public String getElementString() {
                        return s2;
                    }

                    public Path.Element getBaseNameElement(TenantService tenantService) {
                        return this;
                    }
                });
            }
            return result;
        }
    };
    public static final NodePropertyResolver RESOLVER_FILE_TYPE_16 = new NodePropertyResolver(){
        private static final long serialVersionUID = 4300079423348609858L;

        @Override
        public Object get(Node node) {
            if (!(node instanceof AVMNode)) {
                return null;
            }
            if (((AVMNode)node).isDirectory()) {
                return "/images/icons/space_small.gif";
            }
            return FileTypeImageUtils.getFileTypeImage((String)node.getName(), (boolean)true);
        }
    };
    public static final NodePropertyResolver RESOLVER_DISPLAY_PATH = new NodePropertyResolver(){
        private static final long serialVersionUID = 368552730555134975L;

        @Override
        public Object get(Node node) {
            if (!(node instanceof AVMNode)) {
                return null;
            }
            String parentPath = AVMNodeConverter.SplitBase((String)node.getPath())[0];
            return AVMUtil.getSandboxRelativePath(parentPath);
        }
    };
    public static final NodePropertyResolver RESOLVER_PARENT_PATH = new NodePropertyResolver(){
        private static final long serialVersionUID = -798036430912409497L;

        @Override
        public Object get(Node node) {
            if (!(node instanceof AVMNode)) {
                return null;
            }
            return AVMNodeConverter.SplitBase((String)node.getPath())[0];
        }
    };
    private final AVMNodeDescriptor avmRef;
    private LayeringDescriptor layeringDesc;
    private final int version;
    private final boolean deleted;
    private Boolean workflowInFlight;

    public AVMNode(AssetInfo asset) {
        super(AVMNodeConverter.ToNodeRef((int)-1, (String)asset.getAvmPath()));
        this.avmRef = ((AssetInfoImpl)asset).getAVMNodeDescriptor();
        this.version = -1;
        this.id = asset.getAvmPath();
        this.deleted = asset.isDeleted();
    }

    public AVMNode(AVMNodeDescriptor avmRef) {
        super(AVMNodeConverter.ToNodeRef((int)-1, (String)avmRef.getPath()));
        this.avmRef = avmRef;
        this.version = -1;
        this.id = avmRef.getPath();
        this.deleted = avmRef.isDeleted();
    }

    @Override
    public String getPath() {
        return this.avmRef.getPath();
    }

    public final AVMNodeDescriptor getDescriptor() {
        return this.avmRef;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return this.avmRef.getName();
    }

    @Override
    public QName getType() {
        if (this.type == null) {
            this.type = !this.deleted ? this.getServiceRegistry().getNodeService().getType(this.nodeRef) : (this.avmRef.isDeletedDirectory() ? WCMModel.TYPE_AVM_FOLDER : WCMModel.TYPE_AVM_CONTENT);
        }
        return this.type;
    }

    public final boolean isDirectory() {
        return this.avmRef.isDirectory() || this.avmRef.isDeletedDirectory();
    }

    public final boolean isFile() {
        return this.avmRef.isFile() || this.avmRef.isDeletedFile();
    }

    public final boolean isDeleted() {
        return this.avmRef.isDeleted();
    }

    public final boolean isModified() {
        if (this.layeringDesc == null) {
            this.layeringDesc = this.getServiceRegistry().getAVMService().getLayeringInfo(this.version, this.id);
        }
        return !this.layeringDesc.isBackground();
    }

    public final boolean isInActiveWorkflow(String sandbox) {
        if (this.workflowInFlight == null) {
            this.workflowInFlight = !this.isModified() ? Boolean.valueOf(false) : Boolean.valueOf(AVMWorkflowUtil.isInActiveWorkflow(sandbox, this.getDescriptor()));
        }
        return this.workflowInFlight;
    }

    @Override
    public Map<String, Object> getProperties() {
        if (!this.propsRetrieved) {
            if (!this.deleted) {
                Map props = this.getServiceRegistry().getAVMService().getNodeProperties(this.version, this.id);
                for (QName qname : props.keySet()) {
                    PropertyValue propValue = (PropertyValue)props.get(qname);
                    this.properties.put(qname.toString(), propValue.getValue(DataTypeDefinition.ANY));
                }
            }
            this.properties.put("id", this.id);
            this.properties.put("nodeRef", this.nodeRef);
            this.properties.put("size", this.avmRef.getLength());
            this.properties.put("name", this.avmRef.getName());
            this.properties.put("created", this.avmRef.getCreateDate());
            this.properties.put("modified", this.avmRef.getModDate());
            this.properties.put("creator", this.avmRef.getCreator());
            this.properties.put("modifier", this.avmRef.getLastModifier());
            this.properties.put("deleted", this.deleted);
            this.propsRetrieved = true;
        }
        return this.properties;
    }

    @Override
    public void clear() {
        this.getProperties().clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getProperties().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getProperties().containsKey(value);
    }

    @Override
    public Set entrySet() {
        return this.getProperties().entrySet();
    }

    @Override
    public Object get(Object key) {
        return this.getProperties().get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.getProperties().isEmpty();
    }

    @Override
    public Set keySet() {
        return this.getProperties().keySet();
    }

    @Override
    public Object put(String key, Object value) {
        return this.getProperties().put(key, value);
    }

    @Override
    public void putAll(Map t) {
        this.getProperties().putAll(t);
    }

    @Override
    public Object remove(Object key) {
        return this.getProperties().remove(key);
    }

    @Override
    public int size() {
        return this.getProperties().size();
    }

    @Override
    public Collection values() {
        return this.getProperties().values();
    }
}

