/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.context.FacesContext;
import org.alfresco.mbeans.VirtServerRegistry;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.wcm.util.WCMUtil;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.preview.PreviewURIService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.jsf.FacesContextUtils;

public final class AVMUtil
extends WCMUtil {
    private static Log logger = LogFactory.getLog(AVMUtil.class);
    private static final Pattern WEBAPP_RELATIVE_PATH_PATTERN = Pattern.compile("([^:]+:/www/avm_webapps/([^/]+))(.*)");
    private static final Pattern SANDBOX_RELATIVE_PATH_PATTERN = Pattern.compile("([^:]+:/www/avm_webapps)(.*)");
    private static ConfigElement deploymentConfig = null;
    private static ConfigElement linksManagementConfig = null;
    private static final String SPRING_BEAN_NAME_PREVIEW_URI_SERVICE = "PreviewURIService";
    private static PreviewURIService deprecatedPreviewURIGenerator = null;
    private static boolean deprecatedPreviewURIGeneratorChecked = false;

    public static String getStoreName(String avmPath) {
        return WCMUtil.getSandboxStoreId((String)avmPath);
    }

    public static boolean isPreviewStore(String storeName) {
        return WCMUtil.isPreviewStore((String)storeName);
    }

    public static boolean isWorkflowStore(String storeName) {
        return WCMUtil.isWorkflowStore((String)storeName);
    }

    public static boolean isUserStore(String storeName) {
        return WCMUtil.isUserStore((String)storeName);
    }

    public static boolean isMainStore(String storeName) {
        return WCMUtil.isStagingStore((String)storeName);
    }

    public static String getUserName(String storeName) {
        return WCMUtil.getUserName((String)storeName);
    }

    public static String getStoreId(String storeName) {
        return WCMUtil.getWebProjectStoreId((String)storeName);
    }

    public static String getCorrespondingMainStoreName(String storeName) {
        return WCMUtil.getCorrespondingMainStoreName((String)storeName);
    }

    public static String getCorrespondingPreviewStoreName(String storeName) {
        return WCMUtil.getCorrespondingPreviewStoreName((String)storeName);
    }

    public static String getCorrespondingPathInMainStore(String avmPath) {
        return WCMUtil.getCorrespondingPathInMainStore((String)avmPath);
    }

    public static String getCorrespondingPathInPreviewStore(String avmPath) {
        return WCMUtil.getCorrespondingPathInPreviewStore((String)avmPath);
    }

    public static String getCorrespondingPath(String avmPath, String otherStore) {
        return WCMUtil.getCorrespondingPath((String)avmPath, (String)otherStore);
    }

    public static int getRemoteDeploymentPollingFrequency() {
        ConfigElement elem;
        int pollFreq = 2;
        ConfigElement deploymentConfig = AVMUtil.getDeploymentConfig();
        if (deploymentConfig != null && (elem = deploymentConfig.getChild("progress-polling-frequency")) != null) {
            try {
                int value = Integer.parseInt(elem.getValue());
                if (value > 0) {
                    pollFreq = value;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return pollFreq;
    }

    public static int getLinkValidationPollingFrequency() {
        ConfigElement elem;
        int pollFreq = 2;
        ConfigElement linkMngmtConfig = AVMUtil.getLinksManagementConfig();
        if (linkMngmtConfig != null && (elem = linkMngmtConfig.getChild("progress-polling-frequency")) != null) {
            try {
                int value = Integer.parseInt(elem.getValue());
                if (value > 0) {
                    pollFreq = value;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return pollFreq;
    }

    public static String buildStagingStoreName(String storeId) {
        return WCMUtil.buildStagingStoreName((String)storeId);
    }

    public static String buildStagingPreviewStoreName(String storeId) {
        return WCMUtil.buildStagingPreviewStoreName((String)storeId);
    }

    public static String buildUserMainStoreName(String storeId, String username) {
        return WCMUtil.buildUserMainStoreName((String)storeId, (String)username);
    }

    public static String buildUserPreviewStoreName(String storeId, String username) {
        return WCMUtil.buildUserPreviewStoreName((String)storeId, (String)username);
    }

    public static String buildWorkflowMainStoreName(String storeId, String workflowId) {
        return WCMUtil.buildWorkflowMainStoreName((String)storeId, (String)workflowId);
    }

    public static String buildWorkflowPreviewStoreName(String storeId, String workflowId) {
        return WCMUtil.buildWorkflowPreviewStoreName((String)storeId, (String)workflowId);
    }

    public static String buildStoreRootPath(String storeName) {
        return WCMUtil.buildStoreRootPath((String)storeName);
    }

    public static String buildSandboxRootPath(String storeName) {
        return WCMUtil.buildSandboxRootPath((String)storeName);
    }

    public static String buildStoreWebappPath(String storeName, String webapp) {
        return WCMUtil.buildStoreWebappPath((String)storeName, (String)webapp);
    }

    public static String buildWebappUrl(String avmPath) {
        if (avmPath == null || avmPath.length() == 0) {
            throw new IllegalArgumentException("AVM path is mandatory.");
        }
        return AVMUtil.buildWebappUrl(AVMUtil.getStoreName(avmPath), AVMUtil.getWebapp(avmPath));
    }

    public static String buildWebappUrl(String store, String webapp) {
        if (webapp == null || webapp.length() == 0) {
            throw new IllegalArgumentException("Webapp name is mandatory.");
        }
        return webapp.equals("ROOT") ? AVMUtil.getPreviewURI(store) : AVMUtil.getPreviewURI(store) + '/' + webapp;
    }

    public static String getPreviewURI(String storeNameOrAvmPath) {
        if (storeNameOrAvmPath == null || storeNameOrAvmPath.length() == 0) {
            throw new IllegalArgumentException("AVM store name or absolute path is mandatory.");
        }
        String[] s = storeNameOrAvmPath.split(":");
        if (s.length == 1) {
            return AVMUtil.getPreviewURI(s[0], null);
        }
        if (s.length != 2) {
            throw new IllegalArgumentException("expected exactly one ':' in " + storeNameOrAvmPath);
        }
        return AVMUtil.getPreviewURI(s[0], s[1]);
    }

    public static String getPreviewURI(String storeId, String assetPath) {
        if (!deprecatedPreviewURIGeneratorChecked) {
            WebApplicationContext wac;
            if (deprecatedPreviewURIGenerator == null && (wac = FacesContextUtils.getRequiredWebApplicationContext((FacesContext)FacesContext.getCurrentInstance())).containsBean(SPRING_BEAN_NAME_PREVIEW_URI_SERVICE)) {
                deprecatedPreviewURIGenerator = (PreviewURIService)wac.getBean(SPRING_BEAN_NAME_PREVIEW_URI_SERVICE, PreviewURIService.class);
                logger.warn((Object)"Found deprecated 'PreviewURIService' config - which will be used instead of new 'WCMPreviewURIService' until migrated (changing web project preview provider will have no effect)");
            }
            deprecatedPreviewURIGeneratorChecked = true;
        }
        if (deprecatedPreviewURIGenerator != null) {
            return deprecatedPreviewURIGenerator.getPreviewURI(storeId, assetPath);
        }
        return AVMUtil.getPreviewURIService().getPreviewURI(storeId, assetPath);
    }

    public static String buildPath(String parentAVMPath, String path, PathRelation relation) {
        String parent = parentAVMPath;
        if (path == null || path.length() == 0 || ".".equals(path) || "./".equals(path)) {
            return parent;
        }
        if (path.charAt(0) == '/') {
            Matcher m = relation.pattern().matcher(parent);
            if (m.matches()) {
                parent = m.group(1);
            }
        } else if (parent.charAt(parent.length() - 1) != '/') {
            parent = parent + '/';
        }
        return parent + path;
    }

    public static String getStoreRelativePath(String absoluteAVMPath) {
        return WCMUtil.getStoreRelativePath((String)absoluteAVMPath);
    }

    public static String getWebappRelativePath(String absoluteAVMPath) {
        return WCMUtil.getWebappRelativePath((String)absoluteAVMPath);
    }

    public static String getWebapp(String absoluteAVMPath) {
        return WCMUtil.getWebapp((String)absoluteAVMPath);
    }

    public static String getWebappPath(String absoluteAVMPath) {
        return WCMUtil.getWebappPath((String)absoluteAVMPath);
    }

    public static String getSandboxRelativePath(String absoluteAVMPath) {
        return WCMUtil.getSandboxRelativePath((String)absoluteAVMPath);
    }

    public static String getSandboxPath(String absoluteAVMPath) {
        return WCMUtil.getSandboxPath((String)absoluteAVMPath);
    }

    public static void makeAllDirectories(String avmDirectoryPath) {
        String[] sb;
        AVMService avmService = AVMUtil.getAVMService();
        String s = avmDirectoryPath;
        Stack<String[]> dirNames = new Stack<String[]>();
        while (s != null) {
            try {
                if (avmService.lookup(-1, s) != null) {
                    break;
                }
            }
            catch (AVMNotFoundException avmfe) {
                // empty catch block
            }
            sb = AVMNodeConverter.SplitBase((String)s);
            s = sb[0];
            dirNames.push(sb);
        }
        while (!dirNames.isEmpty()) {
            sb = (String[])dirNames.pop();
            avmService.createDirectory(sb[0], sb[1]);
        }
    }

    public static void updateVServerWebapp(String path, boolean force) {
        WCMUtil.updateVServerWebapp((VirtServerRegistry)AVMUtil.getVirtServerRegistry(), (String)path, (boolean)force);
    }

    public static void removeAllVServerWebapps(String path, boolean force) {
        WCMUtil.removeAllVServerWebapps((VirtServerRegistry)AVMUtil.getVirtServerRegistry(), (String)path, (boolean)force);
    }

    public static void removeVServerWebapp(String path, boolean force) {
        WCMUtil.removeVServerWebapp((VirtServerRegistry)AVMUtil.getVirtServerRegistry(), (String)path, (boolean)force);
    }

    private static VirtServerRegistry getVirtServerRegistry() {
        return Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getVirtServerRegistry();
    }

    private static AVMService getAVMService() {
        return Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
    }

    private static org.alfresco.wcm.preview.PreviewURIService getPreviewURIService() {
        return Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPreviewURIService();
    }

    private static ConfigElement getDeploymentConfig() {
        ConfigService cfgService;
        ConfigElement wcmCfg;
        if ((deploymentConfig == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) && (wcmCfg = (cfgService = Application.getConfigService(FacesContext.getCurrentInstance())).getGlobalConfig().getConfigElement("wcm")) != null) {
            deploymentConfig = wcmCfg.getChild("deployment");
        }
        return deploymentConfig;
    }

    private static ConfigElement getLinksManagementConfig() {
        ConfigService cfgService;
        ConfigElement wcmCfg;
        if ((linksManagementConfig == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) && (wcmCfg = (cfgService = Application.getConfigService(FacesContext.getCurrentInstance())).getGlobalConfig().getConfigElement("wcm")) != null) {
            linksManagementConfig = wcmCfg.getChild("links-management");
        }
        return linksManagementConfig;
    }

    public static enum PathRelation {
        SANDBOX_RELATIVE{

            @Override
            protected Pattern pattern() {
                return SANDBOX_RELATIVE_PATH_PATTERN;
            }
        }
        ,
        WEBAPP_RELATIVE{

            @Override
            protected Pattern pattern() {
                return WEBAPP_RELATIVE_PATH_PATTERN;
            }
        };


        protected abstract Pattern pattern();
    }
}

