/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.SelectItem;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.XMLUtil;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.FileUploadBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMWorkflowUtil;
import org.alfresco.web.bean.wcm.DescriptionAttributeHelper;
import org.alfresco.web.bean.wcm.WebProject;
import org.alfresco.web.bean.wizard.BaseWizardBean;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.forms.FormsService;
import org.alfresco.web.forms.RenderingEngine;
import org.alfresco.web.forms.RenderingEngineTemplate;
import org.alfresco.web.forms.RenderingEngineTemplateImpl;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIListItem;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CreateFormWizard
extends BaseWizardBean {
    private static final long serialVersionUID = -7133077371875949483L;
    public static final String FILE_RENDERING_ENGINE_TEMPLATE = "rendering-engine-template";
    public static final String FILE_SCHEMA = "schema";
    private static final String DEFAULT_EXTENSION_PATTERN = "${extension}";
    private static final String DEFAULT_NAME_PATTERN = "${name}";
    private static final Log LOGGER = LogFactory.getLog(CreateFormWizard.class);
    protected String defaultWorkflowName = null;
    protected boolean applyDefaultWorkflow = true;
    protected List<RenderingEngineTemplateData> renderingEngineTemplates = null;
    protected transient Document schema;
    protected String schemaFileName;
    protected transient ContentService contentService;
    protected transient MimetypeService mimetypeService;
    protected transient WorkflowService workflowService;
    protected transient FormsService formsService;
    private String schemaRootElementName = null;
    private String formName = null;
    private String formTitle = null;
    private String formDescription = null;
    private String outputPathPatternForFormInstanceData = null;
    private String renderingEngineTemplateFileName = null;
    private String renderingEngineTemplateName = null;
    private String renderingEngineTemplateTitle = null;
    private String renderingEngineTemplateDescription = null;
    private String formDescriptionAttribute = null;
    private String workflowDescriptionAttribute = null;
    private RenderingEngine renderingEngine = null;
    protected transient DataModel renderingEngineTemplatesDataModel;
    private String outputPathPatternForRendition = null;
    private String mimetypeForRendition = null;
    private transient List<SelectItem> mimetypeChoices = null;
    private transient List<SelectItem> schemaRootElementNameChoices = null;
    private transient List<UIListItem> defaultWorkflowChoices = null;

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("creating form " + this.getFormName()));
        }
        NodeRef contentFormsNodeRef = null;
        contentFormsNodeRef = this.getIsWebForm() ? this.getFormsService().getWebContentFormsNodeRef() : this.getFormsService().getContentFormsNodeRef();
        FileInfo folderInfo = this.getFileFolderService().create(contentFormsNodeRef, this.getFormName(), WCMAppModel.TYPE_FORMFOLDER);
        FileInfo fileInfo = this.getFileFolderService().create(folderInfo.getNodeRef(), this.getSchemaFileName(), ContentModel.TYPE_CONTENT);
        ContentWriter writer = this.getContentService().getWriter(fileInfo.getNodeRef(), ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/xml");
        writer.setEncoding("UTF-8");
        writer.putContent(this.getSchemaFile());
        HashMap<QName, String> props = new HashMap<QName, String>(2, 1.0f);
        props.put(ContentModel.PROP_TITLE, this.getFormTitle());
        props.put(ContentModel.PROP_DESCRIPTION, this.getFormDescription());
        this.getNodeService().addAspect(folderInfo.getNodeRef(), ContentModel.ASPECT_TITLED, props);
        props.clear();
        props.put(WCMAppModel.PROP_XML_SCHEMA, (String)fileInfo.getNodeRef());
        props.put(WCMAppModel.PROP_XML_SCHEMA_ROOT_ELEMENT_NAME, this.getSchemaRootElementName());
        this.getNodeService().addAspect(folderInfo.getNodeRef(), WCMAppModel.ASPECT_FORM, props);
        if (this.applyDefaultWorkflow) {
            props.clear();
            props.put(WCMAppModel.PROP_WORKFLOW_NAME, this.getDefaultWorkflowName()[0]);
            this.getNodeService().createNode(folderInfo.getNodeRef(), WCMAppModel.ASSOC_FORM_WORKFLOW_DEFAULTS, WCMAppModel.ASSOC_FORM_WORKFLOW_DEFAULTS, WCMAppModel.TYPE_WORKFLOW_DEFAULTS, props);
        }
        props.clear();
        props.put(WCMAppModel.PROP_OUTPUT_PATH_PATTERN, this.getOutputPathPatternForFormInstanceData());
        this.getNodeService().addAspect(folderInfo.getNodeRef(), WCMAppModel.ASPECT_OUTPUT_PATH_PATTERN, props);
        for (RenderingEngineTemplateData retd : this.renderingEngineTemplates) {
            this.saveRenderingEngineTemplate(retd, folderInfo.getNodeRef());
        }
        return outcome;
    }

    protected void saveRenderingEngineTemplate(RenderingEngineTemplateData retd, NodeRef formNodeRef) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("adding rendering engine template " + retd + " to form " + this.getFormName()));
        }
        NodeRef renderingEngineTemplateNodeRef = this.getFileFolderService().searchSimple(formNodeRef, retd.getName());
        HashMap<QName, String> props = new HashMap<QName, String>();
        if (renderingEngineTemplateNodeRef == null) {
            try {
                FileInfo fileInfo = this.getFileFolderService().create(formNodeRef, retd.getName(), ContentModel.TYPE_CONTENT);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Created file node for file: " + retd.getName()));
                }
                renderingEngineTemplateNodeRef = fileInfo.getNodeRef();
            }
            catch (FileExistsException fee) {
                LOGGER.error((Object)(fee.getName() + " already exists in " + fee.getParentNodeRef()));
                throw fee;
            }
            ContentWriter writer = this.getContentService().getWriter(renderingEngineTemplateNodeRef, ContentModel.PROP_CONTENT, true);
            writer.setEncoding("UTF-8");
            writer.putContent(retd.getFile());
            this.getNodeService().createAssociation(formNodeRef, renderingEngineTemplateNodeRef, WCMAppModel.ASSOC_RENDERING_ENGINE_TEMPLATES);
            props.clear();
            props.put(WCMAppModel.PROP_PARENT_RENDERING_ENGINE_NAME, retd.getRenderingEngine().getName());
            props.put(WCMAppModel.PROP_FORM_SOURCE, (String)formNodeRef);
            this.getNodeService().addAspect(renderingEngineTemplateNodeRef, WCMAppModel.ASPECT_RENDERING_ENGINE_TEMPLATE, props);
            props.clear();
            props.put(ContentModel.PROP_TITLE, retd.getTitle());
            props.put(ContentModel.PROP_DESCRIPTION, retd.getDescription());
            this.getNodeService().addAspect(renderingEngineTemplateNodeRef, ContentModel.ASPECT_TITLED, props);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("adding rendition properties to " + renderingEngineTemplateNodeRef));
        }
        props.clear();
        props.put(WCMAppModel.PROP_MIMETYPE_FOR_RENDITION, retd.getMimetypeForRendition());
        NodeRef rpNodeRef = this.getNodeService().createNode(renderingEngineTemplateNodeRef, WCMAppModel.ASSOC_RENDITION_PROPERTIES, WCMAppModel.ASSOC_RENDITION_PROPERTIES, WCMAppModel.TYPE_RENDITION_PROPERTIES, props).getChildRef();
        props.clear();
        props.put(WCMAppModel.PROP_OUTPUT_PATH_PATTERN, retd.getOutputPathPatternForRendition());
        this.getNodeService().addAspect(rpNodeRef, WCMAppModel.ASPECT_OUTPUT_PATH_PATTERN, props);
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.removeUploadedSchemaFile();
        this.removeUploadedRenderingEngineTemplateFile();
        this.schema = null;
        this.schemaFileName = null;
        this.schemaRootElementName = null;
        this.schemaRootElementNameChoices = null;
        this.formName = null;
        this.formTitle = null;
        this.formDescription = null;
        this.renderingEngineTemplateFileName = null;
        this.renderingEngineTemplateName = null;
        this.renderingEngineTemplateTitle = null;
        this.renderingEngineTemplateDescription = null;
        this.renderingEngine = null;
        this.renderingEngineTemplates = new ArrayList<RenderingEngineTemplateData>();
        this.renderingEngineTemplatesDataModel = null;
        this.outputPathPatternForFormInstanceData = null;
        this.outputPathPatternForRendition = null;
        this.mimetypeForRendition = null;
        this.defaultWorkflowName = null;
        this.defaultWorkflowChoices = null;
        this.applyDefaultWorkflow = true;
        this.formDescriptionAttribute = null;
        this.workflowDescriptionAttribute = null;
    }

    @Override
    public String cancel() {
        this.removeUploadedSchemaFile();
        this.removeUploadedRenderingEngineTemplateFile();
        return super.cancel();
    }

    @Override
    public boolean getNextButtonDisabled() {
        int step = Application.getWizardManager().getCurrentStep();
        switch (step) {
            case 1: {
                return this.getSchemaFileName() == null || this.getSchemaFileName().length() == 0 || this.getSchemaRootElementNameChoices().size() == 0;
            }
            case 2: {
                return this.getRenderingEngineTemplateFileName() != null;
            }
        }
        return false;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        int step = Application.getWizardManager().getCurrentStep();
        int stepCount = Application.getWizardManager().getStepItems().size();
        return stepCount != 1 || step != 1;
    }

    @Override
    public String getStepDescription() {
        ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
        String stepName = Application.getWizardManager().getCurrentStepName();
        if ("configure_rendering_engine_templates".equals(stepName)) {
            return MessageFormat.format(bundle.getString("create_form_configure_rendering_engine_templates_desc"), this.getFormName());
        }
        if ("select_default_workflow".equals(stepName)) {
            return MessageFormat.format(bundle.getString("create_form_select_default_workflow_desc"), this.getFormName());
        }
        return super.getContainerDescription();
    }

    public boolean getAddToListDisabled() {
        return this.getRenderingEngineTemplateFileName() == null;
    }

    public String getFormDescriptionAttribute() {
        if (StringUtils.isEmpty((String)this.formDescriptionAttribute)) {
            this.formDescriptionAttribute = this.buildFormDescriptionAttribute();
        }
        return this.formDescriptionAttribute;
    }

    public String getFormLabelAttribute() {
        StringBuilder builder = new StringBuilder("<b>");
        builder.append(Utils.encode((String)this.getFormTitle()));
        builder.append("</b>");
        return builder.toString();
    }

    public String getWorkflowDescriptionAttribute() {
        if (StringUtils.isEmpty((String)this.workflowDescriptionAttribute)) {
            this.workflowDescriptionAttribute = this.buildWorkflowDescriptionAttribute();
        }
        return this.workflowDescriptionAttribute;
    }

    public String getWorkflowLabelAttribute() {
        StringBuilder builder = new StringBuilder("<b>");
        WorkflowDefinition wkDef = this.getDefaultWorkflowDefinition();
        if (wkDef != null) {
            builder.append(Utils.encode((String)wkDef.getTitle()));
        }
        builder.append("</b>");
        return builder.toString();
    }

    public String getOutputPathPatternForRendition() {
        return this.outputPathPatternForRendition == null ? "${name}.${extension}" : this.outputPathPatternForRendition;
    }

    public void setOutputPathPatternForRendition(String outputPathPatternForRendition) {
        this.outputPathPatternForRendition = outputPathPatternForRendition;
    }

    public String getMimetypeForRendition() {
        String result = null;
        if (this.mimetypeForRendition != null) {
            result = this.mimetypeForRendition;
        } else {
            if (this.outputPathPatternForRendition != null && !this.outputPathPatternForRendition.endsWith(DEFAULT_EXTENSION_PATTERN)) {
                result = this.getMimetypeService().guessMimetype(this.outputPathPatternForRendition);
            }
            if (result == null) {
                result = "text/html";
            }
        }
        return result;
    }

    public void setMimetypeForRendition(String mimetypeForRendition) {
        this.mimetypeForRendition = mimetypeForRendition;
    }

    public void addSelectedRenderingEngineTemplate(ActionEvent event) {
        String name = this.getRenderingEngineTemplateName();
        if (name == null || name.length() == 0) {
            Utils.addErrorMessage("Please provide a name for the rendering engine template.");
            return;
        }
        if (this.renderingEngine == null) {
            Utils.addErrorMessage("Please select the rendering engine to use.");
            return;
        }
        String opp = this.getOutputPathPatternForRendition();
        String mimetype = this.getMimetypeForRendition();
        for (RenderingEngineTemplateData retd : this.renderingEngineTemplates) {
            if (name.equals(retd.getName())) {
                Utils.addErrorMessage("A rendering engine template with the name " + name + " already exists");
                return;
            }
            if (!opp.equals(retd.getOutputPathPatternForRendition()) || opp.indexOf(DEFAULT_EXTENSION_PATTERN) < 0 || !mimetype.equals(retd.getMimetypeForRendition())) continue;
            Utils.addErrorMessage("A rendering engine template with the output path pattern " + opp + " and mimetype " + mimetype + " already exists");
            return;
        }
        RenderingEngineTemplateData data = new RenderingEngineTemplateData(this.getRenderingEngineTemplateFile(), this.getRenderingEngineTemplateName(), this.getRenderingEngineTemplateTitle(), this.getRenderingEngineTemplateDescription(), opp, mimetype, this.renderingEngine);
        this.renderingEngineTemplates.add(data);
        this.removeUploadedRenderingEngineTemplateFile();
        this.renderingEngine = null;
        this.outputPathPatternForRendition = null;
        this.mimetypeForRendition = null;
        this.renderingEngineTemplateFileName = null;
        this.renderingEngineTemplateName = null;
        this.renderingEngineTemplateTitle = null;
        this.renderingEngineTemplateDescription = null;
    }

    public void removeSelectedRenderingEngineTemplate(ActionEvent event) {
        RenderingEngineTemplateData wrapper = (RenderingEngineTemplateData)this.getRenderingEngineTemplatesDataModel().getRowData();
        if (wrapper != null) {
            this.renderingEngineTemplates.remove(wrapper);
        }
    }

    public String mimetypeForRenditionChanged(ValueChangeEvent vce) {
        return null;
    }

    public String removeUploadedSchemaFile() {
        LOGGER.debug((Object)("removing uploaded rendering engine template file " + this.getRenderingEngineTemplateFileName()));
        this.clearUpload(FILE_SCHEMA);
        this.formName = null;
        this.formTitle = null;
        this.formDescription = null;
        this.outputPathPatternForFormInstanceData = null;
        this.schemaRootElementNameChoices = null;
        this.schema = null;
        this.schemaFileName = null;
        assert (this.getSchemaFileName() == null);
        return null;
    }

    public String removeUploadedRenderingEngineTemplateFile() {
        LOGGER.debug((Object)("removing uploaded rendering engine template file " + this.getRenderingEngineTemplateFileName()));
        this.clearUpload(FILE_RENDERING_ENGINE_TEMPLATE);
        this.renderingEngineTemplateFileName = null;
        this.renderingEngineTemplateName = null;
        this.renderingEngineTemplateTitle = null;
        this.renderingEngineTemplateDescription = null;
        this.outputPathPatternForRendition = null;
        this.mimetypeForRendition = null;
        assert (this.getRenderingEngineTemplateFileName() == null);
        return null;
    }

    public String schemaFileValueChanged(ValueChangeEvent vce) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("schemaFileValueChanged(" + this.getFileName(FILE_SCHEMA) + "[" + this.getSchemaFile() + "])"));
        }
        if (this.getSchemaFile() != null) {
            try {
                this.schema = XMLUtil.parse((File)this.getSchemaFile());
            }
            catch (Exception e) {
                String msg = "unable to parse " + this.getFileName(FILE_SCHEMA);
                this.removeUploadedSchemaFile();
                Utils.addErrorMessage(msg + ": " + e.getMessage(), e);
            }
        }
        return null;
    }

    public String renderingEngineTemplateFileValueChanged(ValueChangeEvent vce) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("renderingEngineTemplateFileValueChanged(" + this.getFileName(FILE_RENDERING_ENGINE_TEMPLATE) + "[" + this.getRenderingEngineTemplateFile() + "])"));
        }
        return null;
    }

    public boolean getEditMode() {
        return false;
    }

    public List<WebProject> getAssociatedWebProjects() {
        return Collections.emptyList();
    }

    public DataModel getRenderingEngineTemplatesDataModel() {
        if (this.renderingEngineTemplatesDataModel == null) {
            this.renderingEngineTemplatesDataModel = new ListDataModel();
        }
        if (this.renderingEngineTemplatesDataModel.getWrappedData() == null) {
            this.renderingEngineTemplatesDataModel.setWrappedData(this.renderingEngineTemplates);
        }
        return this.renderingEngineTemplatesDataModel;
    }

    public List<RenderingEngineTemplateData> getRenderingEngineTemplates() {
        return this.renderingEngineTemplates;
    }

    public String getRenderingEngineName() {
        if (this.renderingEngine == null && this.getRenderingEngineTemplateFileName() != null) {
            this.renderingEngine = this.getFormsService().guessRenderingEngine(this.getRenderingEngineTemplateFileName());
        }
        return this.renderingEngine == null ? null : this.renderingEngine.getName();
    }

    public void setRenderingEngineName(String renderingEngineName) {
        this.renderingEngine = renderingEngineName == null ? null : this.getFormsService().getRenderingEngine(renderingEngineName);
    }

    public List<SelectItem> getRenderingEngineChoices() {
        LinkedList<SelectItem> result = new LinkedList<SelectItem>();
        for (RenderingEngine re : this.getFormsService().getRenderingEngines()) {
            result.add(new SelectItem((Object)re.getName(), re.getName()));
        }
        return result;
    }

    public List<SelectItem> getMimeTypeChoices() {
        if (this.mimetypeChoices == null) {
            this.mimetypeChoices = new ArrayList<SelectItem>(50);
            Map mimetypes = this.getMimetypeService().getDisplaysByMimetype();
            for (String mimetype : mimetypes.keySet()) {
                this.mimetypeChoices.add(new SelectItem((Object)mimetype, (String)mimetypes.get(mimetype)));
            }
            QuickSort sorter = new QuickSort(this.mimetypeChoices, "label", true, "case-insensitive");
            sorter.sort();
        }
        return this.mimetypeChoices;
    }

    public File getSchemaFile() {
        return this.getFile(FILE_SCHEMA);
    }

    public void setSchemaFileName(String schemaFileName) {
        this.schemaFileName = schemaFileName != null && schemaFileName.length() != 0 ? schemaFileName : null;
    }

    public String getSchemaFileName() {
        return this.schemaFileName;
    }

    public void setRenderingEngineTemplateFileName(String renderingEngineTemplateFileName) {
        this.renderingEngineTemplateFileName = renderingEngineTemplateFileName != null && renderingEngineTemplateFileName.length() != 0 ? renderingEngineTemplateFileName : null;
    }

    public String getRenderingEngineTemplateFileName() {
        return this.renderingEngineTemplateFileName;
    }

    public File getRenderingEngineTemplateFile() {
        return this.getFile(FILE_RENDERING_ENGINE_TEMPLATE);
    }

    public void setSchemaRootElementName(String schemaRootElementName) {
        this.schemaRootElementName = schemaRootElementName;
    }

    public String getSchemaRootElementName() {
        return this.schemaRootElementName;
    }

    public List<SelectItem> getSchemaRootElementNameChoices() {
        List<SelectItem> result = Collections.EMPTY_LIST;
        if (this.schema != null) {
            if (this.schemaRootElementNameChoices == null) {
                this.schemaRootElementNameChoices = new LinkedList<SelectItem>();
                NodeList elements = this.schema.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "element");
                for (int i = 0; i < elements.getLength(); ++i) {
                    Node current = elements.item(i);
                    if (!current.getParentNode().equals(this.schema.getDocumentElement())) continue;
                    this.schemaRootElementNameChoices.add(new SelectItem((Object)current.getAttributes().getNamedItem("name").getNodeValue(), current.getAttributes().getNamedItem("name").getNodeValue()));
                }
            }
            result = this.schemaRootElementNameChoices;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getSchemaRootElementNameChoices(" + this.schema + ") = " + result.size()));
        }
        return result;
    }

    public void setFormName(String formName) {
        this.formName = formName != null && formName.length() != 0 ? formName : null;
    }

    public String getFormName() {
        return this.formName == null && this.getSchemaFileName() != null ? FilenameUtils.removeExtension((String)this.getSchemaFileName()) : this.formName;
    }

    public String getOutputPathPatternForFormInstanceData() {
        if (this.outputPathPatternForFormInstanceData == null) {
            this.outputPathPatternForFormInstanceData = "${name}.xml";
        }
        return this.outputPathPatternForFormInstanceData;
    }

    public void setOutputPathPatternForFormInstanceData(String outputPathPatternForFormInstanceData) {
        this.outputPathPatternForFormInstanceData = outputPathPatternForFormInstanceData;
    }

    public void setFormTitle(String formTitle) {
        this.formTitle = formTitle != null && formTitle.length() != 0 ? formTitle : null;
    }

    public String getFormTitle() {
        return this.formTitle == null && this.getSchemaFileName() != null ? FilenameUtils.removeExtension((String)this.getSchemaFileName()) : this.formTitle;
    }

    public void setFormDescription(String formDescription) {
        this.formDescription = formDescription;
    }

    public String getFormDescription() {
        return this.formDescription;
    }

    public void setRenderingEngineTemplateName(String renderingEngineTemplateName) {
        this.renderingEngineTemplateName = renderingEngineTemplateName != null && renderingEngineTemplateName.length() != 0 ? renderingEngineTemplateName : null;
    }

    public String getRenderingEngineTemplateName() {
        return this.renderingEngineTemplateName == null && this.getRenderingEngineTemplateFileName() != null ? this.getRenderingEngineTemplateFileName() : this.renderingEngineTemplateName;
    }

    public void setRenderingEngineTemplateTitle(String renderingEngineTemplateTitle) {
        this.renderingEngineTemplateTitle = renderingEngineTemplateTitle != null && renderingEngineTemplateTitle.length() != 0 ? renderingEngineTemplateTitle : null;
    }

    public String getRenderingEngineTemplateTitle() {
        return this.renderingEngineTemplateTitle == null && this.getRenderingEngineTemplateFileName() != null ? FilenameUtils.removeExtension((String)this.getRenderingEngineTemplateFileName()) : this.renderingEngineTemplateTitle;
    }

    public void setRenderingEngineTemplateDescription(String renderingEngineTemplateDescription) {
        this.renderingEngineTemplateDescription = renderingEngineTemplateDescription;
    }

    public String getRenderingEngineTemplateDescription() {
        return this.renderingEngineTemplateDescription;
    }

    public WorkflowDefinition getDefaultWorkflowDefinition() {
        return this.defaultWorkflowName == null || !this.applyDefaultWorkflow ? null : this.getWorkflowService().getDefinitionByName(this.defaultWorkflowName);
    }

    public void setDefaultWorkflowName(String[] defaultWorkflowName) {
        assert (defaultWorkflowName.length == 1);
        this.defaultWorkflowName = defaultWorkflowName[0];
    }

    public String[] getDefaultWorkflowName() {
        if (this.defaultWorkflowName == null && this.getDefaultWorkflowChoices().size() != 0) {
            this.defaultWorkflowName = (String)this.getDefaultWorkflowChoices().get(0).getValue();
        }
        return new String[]{this.defaultWorkflowName};
    }

    public void setApplyDefaultWorkflow(boolean applyDefaultWorkflow) {
        this.applyDefaultWorkflow = applyDefaultWorkflow;
    }

    public boolean getApplyDefaultWorkflow() {
        return this.applyDefaultWorkflow;
    }

    public List<UIListItem> getDefaultWorkflowChoices() {
        if (this.defaultWorkflowChoices == null) {
            List<WorkflowDefinition> workflowDefs = AVMWorkflowUtil.getConfiguredWorkflows();
            this.defaultWorkflowChoices = new ArrayList<UIListItem>(workflowDefs.size());
            for (WorkflowDefinition workflowDef : workflowDefs) {
                UIListItem item = new UIListItem();
                item.setValue(workflowDef.getName());
                item.setLabel(workflowDef.getTitle());
                item.setDescription(workflowDef.getDescription());
                item.setImage("/images/icons/workflow_large.gif");
                this.defaultWorkflowChoices.add(item);
            }
        }
        return this.defaultWorkflowChoices;
    }

    public boolean getIsWebForm() {
        boolean isWebForm = true;
        if (this.navigator.getCurrentNode().getNodeRef().equals((Object)this.getFormsService().getContentFormsNodeRef())) {
            isWebForm = false;
        }
        return isWebForm;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    protected ContentService getContentService() {
        if (this.contentService == null) {
            this.contentService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getContentService();
        }
        return this.contentService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    protected MimetypeService getMimetypeService() {
        if (this.mimetypeService == null) {
            this.mimetypeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getMimetypeService();
        }
        return this.mimetypeService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected WorkflowService getWorkflowService() {
        if (this.workflowService == null) {
            this.workflowService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getWorkflowService();
        }
        return this.workflowService;
    }

    public void setFormsService(FormsService formsService) {
        this.formsService = formsService;
    }

    protected FormsService getFormsService() {
        if (this.formsService == null) {
            this.formsService = (FormsService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "FormsService");
        }
        return this.formsService;
    }

    protected void clearUpload(String id) {
        FacesContext ctx = FacesContext.getCurrentInstance();
        FileUploadBean fileBean = (FileUploadBean)ctx.getExternalContext().getSessionMap().get(FileUploadBean.getKey(id));
        if (fileBean != null) {
            fileBean.setFile(null);
            fileBean.setFileName(null);
        }
    }

    private FileUploadBean getFileUploadBean(String id) {
        FacesContext ctx = FacesContext.getCurrentInstance();
        Map sessionMap = ctx.getExternalContext().getSessionMap();
        return (FileUploadBean)sessionMap.get(FileUploadBean.getKey(id));
    }

    private String getFileName(String id) {
        FileUploadBean fileBean = this.getFileUploadBean(id);
        return fileBean == null ? null : fileBean.getFileName();
    }

    private File getFile(String id) {
        FileUploadBean fileBean = this.getFileUploadBean(id);
        return fileBean != null ? fileBean.getFile() : null;
    }

    private String buildFormDescriptionAttribute() {
        FacesContext fc = FacesContext.getCurrentInstance();
        StringBuilder attribute = new StringBuilder(255);
        attribute.append(DescriptionAttributeHelper.getTableBegin());
        attribute.append(DescriptionAttributeHelper.getTableLine(fc, "description", DescriptionAttributeHelper.getDescriptionNotEmpty(fc, this.getFormDescription()), false));
        attribute.append(DescriptionAttributeHelper.getTableLine(fc, "schema_root_element_name", this.getSchemaRootElementName()));
        attribute.append(DescriptionAttributeHelper.getTableLine(fc, "output_path_pattern", this.getOutputPathPatternForFormInstanceData()));
        attribute.append(DescriptionAttributeHelper.getTableEnd());
        return attribute.toString();
    }

    private String buildWorkflowDescriptionAttribute() {
        FacesContext fc = FacesContext.getCurrentInstance();
        StringBuilder attribute = new StringBuilder(255);
        attribute.append(DescriptionAttributeHelper.getTableBegin());
        String desc = null;
        WorkflowDefinition def = this.getDefaultWorkflowDefinition();
        if (def != null) {
            desc = def.getDescription();
        }
        attribute.append(DescriptionAttributeHelper.getTableLine(fc, "description", DescriptionAttributeHelper.getDescriptionNotEmpty(fc, desc), false));
        attribute.append(DescriptionAttributeHelper.getTableEnd());
        return attribute.toString();
    }

    public class RenderingEngineTemplateData
    implements Serializable {
        private static final long serialVersionUID = -7786031074741795036L;
        private final NodeRef nodeRef;
        private final File file;
        private final String name;
        private final String title;
        private final String description;
        private final String mimetypeForRendition;
        private final String outputPathPatternForRendition;
        private final RenderingEngine renderingEngine;
        private final String renderingEngineDescriptionAttribute;

        public RenderingEngineTemplateData(RenderingEngineTemplate ret) {
            this.file = null;
            this.nodeRef = ((RenderingEngineTemplateImpl)ret).getNodeRef();
            this.name = ret.getName();
            this.title = ret.getTitle();
            this.description = ret.getDescription();
            this.outputPathPatternForRendition = ret.getOutputPathPattern();
            this.mimetypeForRendition = ret.getMimetypeForRendition();
            this.renderingEngine = ret.getRenderingEngine();
            this.renderingEngineDescriptionAttribute = this.buildREDescriptionAttribute();
        }

        public RenderingEngineTemplateData(File file, String name, String title, String description, String outputPathPatternForRendition, String mimetypeForRendition, RenderingEngine renderingEngine) {
            this.nodeRef = null;
            this.file = file;
            this.name = name;
            this.title = title;
            this.description = description;
            this.outputPathPatternForRendition = outputPathPatternForRendition;
            this.mimetypeForRendition = mimetypeForRendition;
            this.renderingEngine = renderingEngine;
            this.renderingEngineDescriptionAttribute = this.buildREDescriptionAttribute();
        }

        public String getOutputPathPatternForRendition() {
            return this.outputPathPatternForRendition;
        }

        public String getMimetypeForRendition() {
            return this.mimetypeForRendition;
        }

        public File getFile() {
            return this.file;
        }

        public NodeRef getNodeRef() {
            return this.nodeRef;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public RenderingEngine getRenderingEngine() {
            return this.renderingEngine;
        }

        public String getRenderingEngineDescriptionAttribute() {
            return this.renderingEngineDescriptionAttribute;
        }

        public String getRenderingEngineLabelAttribute() {
            StringBuilder builder = new StringBuilder("<b>");
            builder.append(Utils.encode((String)this.title));
            builder.append("</b>");
            return builder.toString();
        }

        public String toString() {
            return this.getClass().getName() + "{" + "name: " + this.getName() + "," + "mimetypeForRendition: " + this.getMimetypeForRendition() + "," + "outputPathPatternForRendition: " + this.getOutputPathPatternForRendition() + "," + "renderingEngine: " + this.getRenderingEngine().getName() + "}";
        }

        private String buildREDescriptionAttribute() {
            FacesContext fc = FacesContext.getCurrentInstance();
            StringBuilder attribute = new StringBuilder(255);
            attribute.append(DescriptionAttributeHelper.getTableBegin());
            attribute.append(DescriptionAttributeHelper.getTableLine(fc, "description", DescriptionAttributeHelper.getDescriptionNotEmpty(fc, this.getDescription()), false));
            attribute.append(DescriptionAttributeHelper.getTableLine(fc, "rendering_engine_type", this.getRenderingEngine().getName()));
            attribute.append(DescriptionAttributeHelper.getTableLine(fc, "output_path_pattern", this.getOutputPathPatternForRendition()));
            attribute.append(DescriptionAttributeHelper.getTableLine(fc, "mimetype_for_renditions", this.getMimetypeForRendition()));
            attribute.append(DescriptionAttributeHelper.getTableEnd());
            return attribute.toString();
        }
    }
}

