/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.avm.AVMExistsException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.XMLUtil;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.content.CreateContentWizard;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMNode;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.DescriptionAttributeHelper;
import org.alfresco.web.bean.wcm.FilePickerBean;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.forms.Form;
import org.alfresco.web.forms.FormInstanceData;
import org.alfresco.web.forms.FormNotFoundException;
import org.alfresco.web.forms.FormsService;
import org.alfresco.web.forms.RenderingEngineTemplate;
import org.alfresco.web.forms.Rendition;
import org.alfresco.web.forms.xforms.XFormsBean;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIListItem;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigService;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CreateWebContentWizard
extends CreateContentWizard {
    private static final long serialVersionUID = -4090370304405270047L;
    private static final Log logger = LogFactory.getLog(CreateWebContentWizard.class);
    private static final String MSG_ERROR_XFORMVALIDATION = "error_validate_xforms";
    private transient List<SelectItem> formChoices;
    protected String createdPath = null;
    protected List<Rendition> renditions = null;
    protected FormInstanceData formInstanceData = null;
    protected boolean formSelectDisabled = false;
    protected boolean startWorkflow = false;
    protected String formDescriptionAttribute;
    private transient AVMLockingService avmLockingService;
    private transient AVMService avmService;
    private transient AVMSyncService avmSyncService;
    protected AVMBrowseBean avmBrowseBean;
    protected FilePickerBean filePickerBean;

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    protected AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMLockingAwareService();
        }
        return this.avmService;
    }

    public void setAvmLockingService(AVMLockingService avmLockingService) {
        this.avmLockingService = avmLockingService;
    }

    protected AVMLockingService getAvmLockingService() {
        if (this.avmLockingService == null) {
            this.avmLockingService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMLockingService();
        }
        return this.avmLockingService;
    }

    public void setAvmSyncService(AVMSyncService avmSyncService) {
        this.avmSyncService = avmSyncService;
    }

    protected AVMSyncService getAvmSyncService() {
        if (this.avmSyncService == null) {
            this.avmSyncService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMSyncService();
        }
        return this.avmSyncService;
    }

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public void setFilePickerBean(FilePickerBean filePickerBean) {
        this.filePickerBean = filePickerBean;
    }

    @Override
    public void setFormsService(FormsService formsService) {
        this.formsService = formsService;
    }

    protected FormsService getFormsService() {
        if (this.formsService == null) {
            this.formsService = (FormsService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "FormsService");
        }
        return this.formsService;
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.content = null;
        this.inlineEdit = true;
        this.formName = null;
        this.mimeType = "text/xml";
        this.formInstanceData = null;
        this.renditions = null;
        this.startWorkflow = false;
        this.formSelectDisabled = false;
        this.createMimeTypes = null;
        this.formChoices = null;
        this.filePickerBean.clearUploadedFiles();
        if (this.parameters.get("form-name") != null) {
            String formName = parameters.get("form-name");
            try {
                Form form = this.avmBrowseBean.getWebProject().getForm(formName);
                if (form != null) {
                    this.formName = form.getName();
                    this.formSelectDisabled = true;
                }
            }
            catch (FormNotFoundException fnfe) {
                Utils.addErrorMessage(fnfe.getMessage(), fnfe);
            }
        }
        String storeName = AVMUtil.getStoreName(this.avmBrowseBean.getCurrentPath());
        storeName = AVMUtil.getCorrespondingPreviewStoreName(storeName);
        final String path = AVMUtil.buildStoreRootPath(storeName);
        FacesContext context = FacesContext.getCurrentInstance();
        RetryingTransactionHelper txnHelper = Repository.getRetryingTransactionHelper(context);
        RetryingTransactionHelper.RetryingTransactionCallback<String> callback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            public String execute() throws Throwable {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("reseting layer " + path));
                }
                CreateWebContentWizard.this.getAvmSyncService().resetLayer(path);
                return null;
            }
        };
        try {
            txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Exception e) {
            Utils.addErrorMessage(e.getMessage(), e);
        }
    }

    @Override
    public String next() {
        if ("summary".equals(Application.getWizardManager().getCurrentStepName()) && "text/xml".equals(this.mimeType)) {
            FacesContext context = FacesContext.getCurrentInstance();
            Map sessionMap = context.getExternalContext().getSessionMap();
            if (sessionMap.containsKey("XFormsBean")) {
                XFormsBean xFormsBean;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"XFormsBean found in session, trying to validate the XForm form");
                }
                if (!(xFormsBean = (XFormsBean)context.getExternalContext().getSessionMap().get("XFormsBean")).isXformValid()) {
                    Application.getWizardManager().getState().setCurrentStep(Application.getWizardManager().getCurrentStep() - 1);
                    Utils.addErrorMessage(Application.getMessage(context, MSG_ERROR_XFORMVALIDATION));
                    return super.next();
                }
            }
            RetryingTransactionHelper txnHelper = Repository.getRetryingTransactionHelper(context);
            RetryingTransactionHelper.RetryingTransactionCallback<String> callback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                public String execute() throws Throwable {
                    CreateWebContentWizard.this.saveContent();
                    return null;
                }
            };
            try {
                txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
            }
            catch (Exception e) {
                Application.getWizardManager().getState().setCurrentStep(Application.getWizardManager().getCurrentStep() - 1);
                Utils.addErrorMessage(e.getMessage(), e);
            }
        }
        return super.next();
    }

    @Override
    public String back() {
        if ("content".equals(Application.getWizardManager().getCurrentStepName())) {
            FacesContext context = FacesContext.getCurrentInstance();
            RetryingTransactionHelper txnHelper = Repository.getRetryingTransactionHelper(context);
            RetryingTransactionHelper.RetryingTransactionCallback<String> callback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                public String execute() throws Throwable {
                    if (CreateWebContentWizard.this.formInstanceData != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("clearing form instance data: " + CreateWebContentWizard.this.formInstanceData.getPath()));
                        }
                        CreateWebContentWizard.this.getAvmService().removeNode(CreateWebContentWizard.this.formInstanceData.getPath());
                    }
                    if (CreateWebContentWizard.this.renditions != null) {
                        for (Rendition r : CreateWebContentWizard.this.renditions) {
                            CreateWebContentWizard.this.getAvmService().removeNode(r.getPath());
                        }
                    }
                    return null;
                }
            };
            try {
                txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
            }
            catch (Exception e) {
                Utils.addErrorMessage(e.getMessage(), e);
            }
            this.formInstanceData = null;
            this.renditions = null;
        }
        return super.back();
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        if (this.formInstanceData == null || this.renditions == null) {
            this.saveContent();
        }
        NodeRef[] uploadedFiles = this.filePickerBean.getUploadedFiles();
        ArrayList<AVMDifference> diffList = new ArrayList<AVMDifference>(1 + this.renditions.size() + uploadedFiles.length);
        diffList.add(new AVMDifference(-1, this.createdPath, -1, AVMUtil.getCorrespondingPathInMainStore(this.createdPath), 0));
        for (Rendition rendition : this.renditions) {
            String path = rendition.getPath();
            diffList.add(new AVMDifference(-1, path, -1, AVMUtil.getCorrespondingPathInMainStore(path), 0));
        }
        for (NodeRef uploadedFile : uploadedFiles) {
            String path = (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)uploadedFile).getSecond();
            diffList.add(new AVMDifference(-1, path, -1, AVMUtil.getCorrespondingPathInMainStore(path), 0));
        }
        if (logger.isDebugEnabled()) {
            for (AVMDifference diff : diffList) {
                logger.debug((Object)("updating main store with " + diff.getSourcePath()));
            }
        }
        this.getAvmSyncService().update(diffList, null, true, true, true, true, null, null);
        for (AVMDifference diff : diffList) {
            String path = diff.getDestinationPath();
            String storeId = AVMUtil.getStoreId(path);
            String storePath = AVMUtil.getStoreRelativePath(path);
            String storeName = AVMUtil.getStoreName(path);
            String lockOwner = this.getAvmLockingService().getLockOwner(storeId, storePath);
            Map lockData = this.getAvmLockingService().getLockData(storeId, storePath);
            String fromStoreName = (String)lockData.get("avm-store-name");
            lockData.put("avm-store-name", storeName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("modifying lock on " + path + ".  chaging store from " + fromStoreName + " to " + storeName));
            }
            this.getAvmLockingService().modifyLock(storeId, AVMUtil.getStoreRelativePath(diff.getSourcePath()), lockOwner, storeId, AVMUtil.getStoreRelativePath(path), lockData);
        }
        if (this.startWorkflow) {
            ArrayList<AVMNodeDescriptor> submitNodes = new ArrayList<AVMNodeDescriptor>(1 + this.getUploadedFiles().size() + this.getRenditions().size());
            for (AVMDifference d : diffList) {
                submitNodes.add(this.getAvmService().lookup(-1, d.getDestinationPath()));
            }
            this.avmBrowseBean.setNodesForSubmit(submitNodes);
            HashMap<String, String> dialogParams = new HashMap<String, String>(1);
            dialogParams.put("loadSelectedNodesFromBrowseBean", Boolean.TRUE.toString());
            Application.getDialogManager().setupParameters(dialogParams);
            outcome = outcome + ":" + "dialog:" + "submitSandboxItems";
        }
        if (this.formProcessorSession != null) {
            this.formProcessorSession.destroy();
        }
        this.filePickerBean.clearUploadedFiles();
        return outcome;
    }

    @Override
    protected String doPostCommitProcessing(FacesContext facesContext, String outcome) {
        this.createdPath = AVMUtil.getCorrespondingPathInMainStore(this.createdPath);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("reset path " + this.createdPath + " to main store"));
        }
        if ("text/xml".equals(this.mimeType) && this.formName != null) {
            try {
                this.formInstanceData = this.getFormsService().getFormInstanceData(-1, this.createdPath);
                this.renditions = this.formInstanceData.getRenditions();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("reset form instance data " + this.formInstanceData.getName() + " and " + this.renditions.size() + " rendition(s) to main store"));
                }
            }
            catch (FormNotFoundException fnfe) {
                logger.warn((Object)fnfe);
            }
        }
        this.avmBrowseBean.setAvmActionNode(new AVMNode(this.getAvmService().lookup(-1, this.createdPath)));
        return outcome;
    }

    @Override
    public boolean getNextButtonDisabled() {
        boolean disabled = false;
        if ("details".equals(Application.getWizardManager().getCurrentStepName())) {
            disabled = this.fileName == null || this.fileName.length() == 0;
        }
        return disabled;
    }

    protected void saveContent() throws Exception {
        String fileName;
        String contentName = fileName = this.getFileName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("saving file content to " + fileName));
        }
        String cwd = AVMUtil.getCorrespondingPathInPreviewStore(this.avmBrowseBean.getCurrentPath());
        Form form = "text/xml".equals(this.mimeType) ? this.getForm() : null;
        String path = cwd;
        HashMap<QName, PropertyValue> props = new HashMap<QName, PropertyValue>(1, 1.0f);
        ArrayList<QName> aspects = new ArrayList<QName>(4);
        if (form != null) {
            path = form.getOutputPathForFormInstanceData(this.getInstanceDataDocument(), fileName, cwd, this.avmBrowseBean.getWebapp());
            this.content = XMLUtil.toString((Node)this.getInstanceDataDocument(), (boolean)false);
            String[] sb = AVMNodeConverter.SplitBase((String)path);
            path = sb[0];
            fileName = sb[1];
            props.put(WCMAppModel.PROP_PARENT_FORM_NAME, new PropertyValue(null, (Serializable)((Object)form.getName())));
            props.put(WCMAppModel.PROP_ORIGINAL_PARENT_PATH, new PropertyValue(null, (Serializable)((Object)cwd)));
            aspects.add(WCMAppModel.ASPECT_FORM_INSTANCE_DATA);
        }
        props.put(ContentModel.PROP_TITLE, new PropertyValue(null, (Serializable)((Object)fileName)));
        aspects.add(ContentModel.ASPECT_TITLED);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("creating all directories in path " + path));
        }
        AVMUtil.makeAllDirectories(path);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("creating file " + fileName + " in " + path));
        }
        String filePath = AVMNodeConverter.ExtendAVMPath((String)path, (String)fileName);
        try {
            this.getAvmService().createFile(path, fileName, (InputStream)new ByteArrayInputStream((this.content == null ? "" : this.content).getBytes("UTF-8")), aspects, props);
        }
        catch (AVMExistsException avmee) {
            String msg = Application.getMessage(FacesContext.getCurrentInstance(), "error_exists");
            msg = MessageFormat.format(msg, fileName);
            throw new AlfrescoRuntimeException(msg, (Throwable)avmee);
        }
        this.createdPath = filePath;
        NodeRef formInstanceDataNodeRef = AVMNodeConverter.ToNodeRef((int)-1, (String)this.createdPath);
        if (form != null) {
            this.formInstanceData = this.getFormsService().getFormInstanceData(formInstanceDataNodeRef);
            this.renditions = new LinkedList<Rendition>();
            for (RenderingEngineTemplate ret : form.getRenderingEngineTemplates()) {
                try {
                    path = ret.getOutputPathForRendition(this.formInstanceData, cwd, contentName);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("About to render path: " + path));
                    }
                    this.renditions.add(ret.render(this.formInstanceData, path));
                }
                catch (Exception e) {
                    StringTokenizer st = new StringTokenizer(e.getMessage(), "\n");
                    if (st.hasMoreElements()) {
                        Utils.addErrorMessage("Error generating rendition using " + ret.getName() + ": " + st.nextToken(), e);
                        while (st.hasMoreElements()) {
                            Utils.addErrorMessage(st.nextToken(), e);
                        }
                        continue;
                    }
                    Utils.addErrorMessage("Error generating rendition using " + ret.getName() + ": " + e.getMessage(), e);
                }
            }
        } else {
            this.renditions = Collections.EMPTY_LIST;
        }
    }

    @Override
    public String getFileName() {
        String result = super.getFileName();
        return result != null && "text/xml".equals(this.mimeType) && this.getFormName() != null && "xml".equals(FilenameUtils.getExtension((String)result).toLowerCase()) ? FilenameUtils.removeExtension((String)result) : result;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public void setContent(String content) {
        this.content = content;
    }

    public List<SelectItem> getFormChoices() {
        if (this.formChoices == null) {
            List<Form> forms = this.avmBrowseBean.getWebProject().getForms();
            this.formChoices = new ArrayList<SelectItem>(forms.size());
            for (Form f : forms) {
                this.formChoices.add(new SelectItem((Object)f.getName(), f.getTitle()));
            }
            QuickSort sorter = new QuickSort(this.formChoices, "label", true, "case-insensitive");
            sorter.sort();
        }
        return this.formChoices;
    }

    @Override
    public List<SelectItem> getCreateMimeTypes() {
        if (this.createMimeTypes == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            FacesContext context = FacesContext.getCurrentInstance();
            this.createMimeTypes = new ArrayList(5);
            ConfigService svc = Application.getConfigService(context);
            Config wizardCfg = svc.getConfig((Object)"Content Wizards");
            if (wizardCfg == null) {
                logger.warn((Object)"Could not find 'Content Wizards' configuration section");
            } else {
                ConfigElement typesCfg = wizardCfg.getConfigElement("create-mime-types");
                if (typesCfg == null) {
                    logger.warn((Object)"Could not find 'create-mime-types' configuration element");
                } else {
                    for (ConfigElement child : typesCfg.getChildren()) {
                        String currentMimeType = child.getAttribute("name");
                        if (currentMimeType == null || "text/xml".equals(currentMimeType) && this.getFormChoices().size() == 0) continue;
                        String label = this.getSummaryMimeType(currentMimeType);
                        this.createMimeTypes.add(new SelectItem((Object)currentMimeType, label));
                    }
                    QuickSort sorter = new QuickSort(this.objectTypes, "label", true, "case-insensitive");
                    sorter.sort();
                }
            }
        }
        return this.createMimeTypes;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    @Override
    public Form getForm() throws FormNotFoundException {
        return this.getFormName() != null ? this.avmBrowseBean.getWebProject().getForm(this.getFormName()) : null;
    }

    @Override
    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public Document getInstanceDataDocument() {
        if (this.instanceDataDocument == null) {
            String content = this.getContent();
            try {
                this.instanceDataDocument = content != null ? XMLUtil.parse((String)content) : XMLUtil.newDocument();
            }
            catch (Exception e) {
                Utils.addErrorMessage("error parsing document", e);
                this.instanceDataDocument = XMLUtil.newDocument();
            }
        }
        return this.instanceDataDocument;
    }

    @Override
    public List<SelectItem> getFormsList() {
        Collection<Form> forms = this.getFormsService().getWebForms();
        ArrayList<SelectItem> items = new ArrayList<SelectItem>(forms.size() + 1);
        items.add(new SelectItem((Object)"", ""));
        for (Form form : forms) {
            items.add(new SelectItem((Object)form.getName(), form.getTitle()));
        }
        return items;
    }

    public FormInstanceData getFormInstanceData() {
        return this.formInstanceData;
    }

    public List<Rendition> getRenditions() {
        return this.renditions;
    }

    public List<UIListItem> getUploadedFiles() {
        if (this.formProcessorSession == null) {
            return Collections.EMPTY_LIST;
        }
        NodeRef[] uploadedFiles = this.filePickerBean.getUploadedFiles();
        ArrayList<UIListItem> result = new ArrayList<UIListItem>(uploadedFiles.length);
        for (NodeRef nodeRef : uploadedFiles) {
            UIListItem item = new UIListItem();
            String name = (String)((Object)this.getNodeService().getProperty(nodeRef, ContentModel.PROP_NAME));
            item.setValue(name);
            item.setLabel((String)((Object)this.getNodeService().getProperty(nodeRef, ContentModel.PROP_TITLE)));
            item.setDescription((String)((Object)this.getNodeService().getProperty(nodeRef, ContentModel.PROP_DESCRIPTION)));
            item.setImage(FileTypeImageUtils.getFileTypeImage((String)name, (boolean)false));
            result.add(item);
        }
        return result;
    }

    public int getNumberOfSubmittableFiles() {
        return 1 + this.getUploadedFiles().size() + this.getRenditions().size();
    }

    public boolean getFormSelectDisabled() {
        return this.formSelectDisabled;
    }

    public void setFormSelectDisabled(boolean formSelectDisabled) {
        this.formSelectDisabled = formSelectDisabled;
    }

    public void setStartWorkflow(boolean startWorkflow) {
        this.startWorkflow = startWorkflow;
    }

    public boolean getStartWorkflow() {
        return this.startWorkflow;
    }

    public boolean getSubmittable() {
        return true;
    }

    public String getPreviewSandboxUrl() {
        return AVMUtil.buildWebappUrl(AVMUtil.getCorrespondingPreviewStoreName(this.avmBrowseBean.getSandbox()), this.avmBrowseBean.getWebapp());
    }

    public String getAvmWebappPrefix() {
        return AVMUtil.getPreviewURI(AVMUtil.getCorrespondingPreviewStoreName(this.avmBrowseBean.getSandbox()));
    }

    public String getAvmWebappName() {
        return this.avmBrowseBean.getWebapp();
    }

    @Override
    public String getSummary() {
        ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
        return this.buildSummary(new String[]{bundle.getString("file_name"), bundle.getString("type"), bundle.getString("content_type")}, new String[]{Utils.encode((String)this.getFileName()), this.getSummaryObjectType(), this.getSummaryMimeType(this.mimeType)});
    }

    public boolean getEditMode() {
        return false;
    }

    public String getFormDescriptionAttribute() {
        this.formDescriptionAttribute = this.buildFormDescriptionAttribute();
        return this.formDescriptionAttribute;
    }

    public String getFormLabelAttribute() {
        StringBuilder builder = new StringBuilder("<b>");
        builder.append(Utils.encode((String)this.getFormInstanceData().getName()));
        builder.append("</b>");
        return builder.toString();
    }

    @Override
    public void createContentChanged(ValueChangeEvent event) {
        this.content = null;
    }

    private String buildFormDescriptionAttribute() {
        FacesContext fc = FacesContext.getCurrentInstance();
        String contextPath = fc.getExternalContext().getRequestContextPath();
        StringBuilder attribute = new StringBuilder(255);
        attribute.append("<span style=\"float:right;\">");
        attribute.append("<a id=\"preview_fid\" href=\"").append(this.getFormInstanceData().getUrl()).append("\" ");
        attribute.append("style=\"text-decoration: none;\" ");
        attribute.append("target=\"window_").append(this.getFormInstanceData().getName()).append("\">");
        attribute.append("<img src=\"").append(contextPath).append("/images/icons/preview_website.gif\" ");
        attribute.append("align=\"absmiddle\" style=\"border: 0px\" ");
        attribute.append("alt=").append(this.getFormInstanceData().getName()).append("\">");
        attribute.append("</a></span>\n");
        attribute.append(DescriptionAttributeHelper.getTableBegin());
        String formTitle = null;
        try {
            formTitle = this.getForm().getTitle();
        }
        catch (FormNotFoundException e) {
            formTitle = Application.getMessage(FacesContext.getCurrentInstance(), "form_not_found");
        }
        attribute.append(DescriptionAttributeHelper.getTableLine(fc, "form", formTitle));
        attribute.append(DescriptionAttributeHelper.getTableLine(fc, "location", this.getFormInstanceData().getSandboxRelativePath()));
        attribute.append(DescriptionAttributeHelper.getTableEnd());
        return attribute.toString();
    }
}

