/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.FileNotFoundException;
import java.text.MessageFormat;
import java.util.List;
import javax.faces.context.FacesContext;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMNode;
import org.alfresco.web.forms.FormInstanceData;
import org.alfresco.web.forms.FormNotFoundException;
import org.alfresco.web.forms.FormsService;
import org.alfresco.web.forms.Rendition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteFileDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -3962232696127851920L;
    private static final Log logger = LogFactory.getLog(DeleteFileDialog.class);
    private transient AVMService avmService;
    protected AVMBrowseBean avmBrowseBean;
    private transient FormsService formsService;

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    protected AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
        }
        return this.avmService;
    }

    public void setFormsService(FormsService formsService) {
        this.formsService = formsService;
    }

    protected FormsService getFormsService() {
        if (this.formsService == null) {
            this.formsService = (FormsService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "FormsService");
        }
        return this.formsService;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        AVMNode node = this.avmBrowseBean.getAvmActionNode();
        if (node == null) {
            logger.warn((Object)"WARNING: delete called without a current AVM Node!");
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Trying to delete AVM node: " + node.getPath()));
            }
            FormInstanceData fid = null;
            if (node.hasAspect(WCMAppModel.ASPECT_RENDITION)) {
                try {
                    fid = this.getFormsService().getRendition(node.getNodeRef()).getPrimaryFormInstanceData();
                }
                catch (FileNotFoundException fnfe) {}
            } else if (node.hasAspect(WCMAppModel.ASPECT_FORM_INSTANCE_DATA)) {
                fid = this.getFormsService().getFormInstanceData(node.getNodeRef());
            }
            if (fid != null) {
                List<Rendition> renditions = fid.getRenditions();
                for (Rendition r : renditions) {
                    this.getAvmService().removeNode(AVMNodeConverter.SplitBase((String)r.getPath())[0], AVMNodeConverter.SplitBase((String)r.getPath())[1]);
                }
                this.getAvmService().removeNode(AVMNodeConverter.SplitBase((String)fid.getPath())[0], AVMNodeConverter.SplitBase((String)fid.getPath())[1]);
            } else {
                this.getAvmService().removeNode(AVMNodeConverter.SplitBase((String)node.getPath())[0], AVMNodeConverter.SplitBase((String)node.getPath())[1]);
            }
        }
        return outcome;
    }

    @Override
    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        return "dialog:close";
    }

    @Override
    protected String getErrorMessageId() {
        return "error_delete_file";
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    public String getConfirmMessage() {
        AVMNode node = this.avmBrowseBean.getAvmActionNode();
        if (node.hasAspect(WCMAppModel.ASPECT_RENDITION)) {
            try {
                FormInstanceData fid = this.getFormsService().getRendition(node.getNodeRef()).getPrimaryFormInstanceData();
                return MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "delete_rendition_confirm"), node.getName(), fid.getName(), fid.getRenditions().size() - 1);
            }
            catch (FileNotFoundException fnfe) {}
        } else if (node.hasAspect(WCMAppModel.ASPECT_FORM_INSTANCE_DATA)) {
            try {
                FormInstanceData fid = this.getFormsService().getFormInstanceData(node.getNodeRef());
                return MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "delete_form_instance_data_confirm"), fid.getName(), fid.getRenditions().size());
            }
            catch (FormNotFoundException formNotFoundException) {
                // empty catch block
            }
        }
        return MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "delete_avm_file_confirm"), node.getName());
    }
}

