/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.text.MessageFormat;
import java.util.List;
import javax.faces.context.FacesContext;
import org.alfresco.model.WCMAppModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.wcm.webproject.WebProjectService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.DeploymentUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteSandboxDialog
extends BaseDialogBean {
    private static final long serialVersionUID = 6139801947722234685L;
    private static final Log logger = LogFactory.getLog(DeleteSandboxDialog.class);
    protected AVMBrowseBean avmBrowseBean;
    private transient WebProjectService wpService;

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public void setWebProjectService(WebProjectService wpService) {
        this.wpService = wpService;
    }

    protected WebProjectService getWebProjectService() {
        if (this.wpService == null) {
            this.wpService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getWebProjectService();
        }
        return this.wpService;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        String username = this.avmBrowseBean.getUsername();
        if (username != null) {
            Node website = this.avmBrowseBean.getWebsite();
            this.getWebProjectService().uninviteWebUser(website.getNodeRef(), username, true);
            String wpStoreId = this.getWebProjectService().getWebProject(website.getNodeRef()).getStoreId();
            String mainStore = AVMUtil.buildUserMainStoreName(wpStoreId, username);
            List<NodeRef> testServers = DeploymentUtil.findAllocatedTestServers(mainStore);
            for (NodeRef testServer : testServers) {
                this.getNodeService().setProperty(testServer, WCMAppModel.PROP_DEPLOYSERVERALLOCATEDTO, null);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Released test server from user sandbox: " + mainStore));
            }
        }
        return outcome;
    }

    @Override
    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        return "dialog:close";
    }

    @Override
    protected String getErrorMessageId() {
        return "error_delete_sandbox";
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    public String getConfirmMessage() {
        String fileConfirmMsg = Application.getMessage(FacesContext.getCurrentInstance(), "delete_sandbox_confirm");
        return MessageFormat.format(fileConfirmMsg, this.avmBrowseBean.getUsername());
    }
}

