/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.actions.AVMDeployWebsiteAction;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.wcm.sandbox.SandboxConstants;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.DeploymentMonitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.jsf.FacesContextUtils;

public class DeployWebsiteDialog
extends BaseDialogBean {
    private static final long serialVersionUID = 62702082716235924L;
    protected int versionToDeploy;
    protected String[] deployTo;
    protected String store;
    protected String deployMode;
    protected String calledFromTaskDialog;
    protected NodeRef websiteRef;
    protected NodeRef webProjectRef;
    protected boolean updateTestServer;
    protected AVMBrowseBean avmBrowseBean;
    private transient AVMService avmService;
    private transient ActionService actionService;
    private static final Log logger = LogFactory.getLog(DeployWebsiteDialog.class);

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.deployTo = null;
        String ver = parameters.get("version");
        this.versionToDeploy = ver != null && ver.length() > 0 ? Integer.parseInt(ver) : -1;
        this.store = parameters.get("store");
        String storeRoot = AVMUtil.buildSandboxRootPath(this.store);
        this.websiteRef = AVMNodeConverter.ToNodeRef((int)this.versionToDeploy, (String)storeRoot);
        String webProject = parameters.get("webproject");
        this.webProjectRef = webProject == null ? this.avmBrowseBean.getWebsite().getNodeRef() : new NodeRef(webProject);
        this.deployMode = this.versionToDeploy == -1 ? "test" : "live";
        this.updateTestServer = false;
        String updateTestServerParam = parameters.get("updateTestServer");
        if (updateTestServerParam != null) {
            this.updateTestServer = Boolean.parseBoolean(updateTestServerParam);
        }
        this.calledFromTaskDialog = parameters.get("calledFromTaskDialog");
        this.avmBrowseBean.getDeploymentMonitorIds().clear();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Initialising dialog to deploy: " + this.websiteRef.toString()));
        }
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Requesting deployment of: " + this.websiteRef.toString()));
        }
        if (this.deployTo != null && this.deployTo.length > 0) {
            WebApplicationContext wac = FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context);
            NodeService unprotectedNodeService = (NodeService)wac.getBean("nodeService");
            PermissionService unprotectedPermissionService = (PermissionService)wac.getBean("permissionService");
            ArrayList<String> selectedDeployToNames = new ArrayList<String>();
            String attemptId = GUID.generate();
            HashMap<QName, Object> props = new HashMap<QName, Object>(8, 1.0f);
            props.put(WCMAppModel.PROP_DEPLOYATTEMPTID, attemptId);
            props.put(WCMAppModel.PROP_DEPLOYATTEMPTTYPE, this.deployMode);
            props.put(WCMAppModel.PROP_DEPLOYATTEMPTSTORE, this.store);
            props.put(WCMAppModel.PROP_DEPLOYATTEMPTVERSION, this.versionToDeploy);
            props.put(WCMAppModel.PROP_DEPLOYATTEMPTTIME, new Date());
            NodeRef attempt = unprotectedNodeService.createNode(this.webProjectRef, WCMAppModel.ASSOC_DEPLOYMENTATTEMPT, WCMAppModel.ASSOC_DEPLOYMENTATTEMPT, WCMAppModel.TYPE_DEPLOYMENTATTEMPT, props).getChildRef();
            unprotectedPermissionService.setPermission(attempt, "GROUP_EVERYONE", "AddChildren", true);
            for (String targetServer : this.deployTo) {
                if (targetServer.length() <= 0) continue;
                NodeRef serverRef = new NodeRef(targetServer);
                if (unprotectedNodeService.exists(serverRef)) {
                    Map serverProps = unprotectedNodeService.getProperties(serverRef);
                    String url = (String)serverProps.get(WCMAppModel.PROP_DEPLOYSERVERURL);
                    String serverUri = AVMDeployWebsiteAction.calculateServerUri((Map)serverProps);
                    String serverName = (String)serverProps.get(WCMAppModel.PROP_DEPLOYSERVERNAME);
                    if (serverName == null || serverName.length() == 0) {
                        serverName = serverUri;
                    }
                    if ("test".equals(this.deployMode) && !this.updateTestServer) {
                        String allocatedTo = (String)serverProps.get(WCMAppModel.PROP_DEPLOYSERVERALLOCATEDTO);
                        if (allocatedTo != null) {
                            throw new AlfrescoRuntimeException("testserver.taken", new Object[]{serverName});
                        }
                        unprotectedNodeService.setProperty(serverRef, WCMAppModel.PROP_DEPLOYSERVERALLOCATEDTO, (Serializable)((Object)this.store));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Issuing deployment request for: " + serverName));
                    }
                    selectedDeployToNames.add(serverName);
                    DeploymentMonitor monitor = new DeploymentMonitor(this.websiteRef, serverRef, this.versionToDeploy, serverName, attemptId, url);
                    context.getExternalContext().getSessionMap().put(monitor.getId(), monitor);
                    this.avmBrowseBean.getDeploymentMonitorIds().add(monitor.getId());
                    HashMap<String, Object> args = new HashMap<String, Object>(1, 1.0f);
                    args.put("webproject", this.webProjectRef);
                    args.put("server", serverRef);
                    args.put("attempt", attempt);
                    args.put("callback", monitor);
                    Action action = this.getActionService().createAction("avm-deploy-website", args);
                    this.getActionService().executeAction(action, this.websiteRef, false, true);
                    continue;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn((Object)("target server '" + targetServer + "' was ignored as it no longer exists!"));
            }
            unprotectedNodeService.setProperty(attempt, WCMAppModel.PROP_DEPLOYATTEMPTSERVERS, (Serializable)selectedDeployToNames);
            this.getAvmService().deleteStoreProperty(this.store, SandboxConstants.PROP_LAST_DEPLOYMENT_ID);
            this.getAvmService().setStoreProperty(this.store, SandboxConstants.PROP_LAST_DEPLOYMENT_ID, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)attemptId)));
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("webproject", this.webProjectRef.toString());
            params.put("calledFromTaskDialog", this.calledFromTaskDialog);
            Application.getDialogManager().setupParameters(params);
            return "dialog:monitorDeployment";
        }
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("Deployment of '" + this.websiteRef.toString() + "' skipped as no servers were selected"));
        }
        return outcome;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    @Override
    public String getCancelButtonLabel() {
        return super.getCancelButtonLabel();
    }

    @Override
    public String getContainerDescription() {
        String desc = null;
        FacesContext context = FacesContext.getCurrentInstance();
        ResourceBundle bundle = Application.getBundle(context);
        desc = "live".equals(this.deployMode) ? bundle.getString("deploy_snapshot_desc") : (this.updateTestServer ? bundle.getString("redeploy_sandbox_desc") : bundle.getString("deploy_sandbox_desc"));
        return desc;
    }

    @Override
    public String getContainerTitle() {
        String title = null;
        FacesContext context = FacesContext.getCurrentInstance();
        ResourceBundle bundle = Application.getBundle(context);
        title = "live".equals(this.deployMode) ? bundle.getString("deploy_snapshot_title") : (this.updateTestServer ? bundle.getString("redeploy_sandbox_title") : bundle.getString("deploy_sandbox_title"));
        return title;
    }

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    protected AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
        }
        return this.avmService;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    protected ActionService getActionService() {
        if (this.actionService == null) {
            this.actionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getActionService();
        }
        return this.actionService;
    }

    public void setDeployTo(String[] deployTo) {
        this.deployTo = deployTo;
    }

    public String[] getDeployTo() {
        return this.deployTo;
    }

    public String getDeployMode() {
        return this.deployMode;
    }

    public NodeRef getWebProjectRef() {
        return this.webProjectRef;
    }

    public String getStore() {
        return this.store;
    }

    public int getSnapshotVersion() {
        return this.versionToDeploy;
    }
}

