/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.alfresco.web.bean.wcm.DeploymentMonitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeploymentProgressBean
implements Serializable {
    private static final long serialVersionUID = 3940559099944268131L;
    private static Log logger = LogFactory.getLog(DeploymentProgressBean.class);

    public void getStatus() throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        ResponseWriter out = context.getResponseWriter();
        Map params = context.getExternalContext().getRequestParameterMap();
        String monitorIds = (String)params.get("ids");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieving progress status for ids: " + monitorIds));
        }
        if (monitorIds != null && monitorIds.length() > 0) {
            StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?>");
            xml.append("<deployment-progess>");
            StringTokenizer tokenizer = new StringTokenizer(monitorIds, ",");
            while (tokenizer.hasMoreTokens()) {
                String id = tokenizer.nextToken().trim();
                DeploymentMonitor monitor = (DeploymentMonitor)context.getExternalContext().getSessionMap().get(id);
                if (monitor == null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found monitor object for id '" + id + "': " + monitor));
                }
                xml.append(monitor.toXML());
                if (!monitor.isFinished()) continue;
                context.getExternalContext().getSessionMap().remove(id);
            }
            xml.append("</deployment-progess>");
            out.write(xml.toString());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("returning XML: " + xml.toString()));
            }
        }
    }
}

