/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.faces.context.FacesContext;
import org.alfresco.model.WCMAppModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.web.bean.repository.Repository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DeploymentUtil {
    private static final Log logger = LogFactory.getLog(DeploymentUtil.class);

    public static List<NodeRef> findDeploymentAttempts(String store) {
        return DeploymentUtil.findDeploymentAttempts(store, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<NodeRef> findDeploymentAttempts(String store, Date fromDate, Date toDate) {
        FacesContext fc = FacesContext.getCurrentInstance();
        SearchService searchService = Repository.getServiceRegistry(fc).getSearchService();
        StringBuilder query = new StringBuilder("@");
        query.append("wca");
        query.append("\\:");
        query.append(WCMAppModel.PROP_DEPLOYATTEMPTSTORE.getLocalName());
        query.append(":\"");
        query.append(store);
        query.append("\"");
        if (fromDate != null) {
            if (toDate == null) {
                toDate = new Date();
            }
            boolean sameDate = false;
            GregorianCalendar fromCal = new GregorianCalendar();
            fromCal.setTime(fromDate);
            GregorianCalendar toCal = new GregorianCalendar();
            toCal.setTime(toDate);
            if (fromCal.get(1) == toCal.get(1) && fromCal.get(2) == toCal.get(2) && fromCal.get(5) == toCal.get(5)) {
                sameDate = true;
            }
            query.append(" AND @");
            query.append("wca");
            query.append("\\:");
            query.append(WCMAppModel.PROP_DEPLOYATTEMPTTIME.getLocalName());
            query.append(":");
            if (sameDate) {
                String queryDate = DeploymentUtil.formatLuceneQueryDate(fromDate, false);
                query.append("\"");
                query.append(queryDate);
                query.append("\"");
            } else {
                String queryFromDate = DeploymentUtil.formatLuceneQueryDate(fromDate, true);
                String queryToDate = DeploymentUtil.formatLuceneQueryDate(toDate, true);
                query.append("[");
                query.append(queryFromDate);
                query.append(" TO ");
                query.append(queryToDate);
                query.append("]");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Finding deploymentattempt nodes using query: " + query.toString()));
        }
        ResultSet results = null;
        ArrayList<NodeRef> attempts = new ArrayList<NodeRef>();
        try {
            SearchParameters sp = new SearchParameters();
            sp.addStore(Repository.getStoreRef());
            sp.setLanguage("lucene");
            sp.setQuery(query.toString());
            sp.addSort("@" + WCMAppModel.PROP_DEPLOYATTEMPTTIME, false);
            results = searchService.query(sp);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + results.length() + " deployment attempts"));
            }
            for (NodeRef attempt : results.getNodeRefs()) {
                attempts.add(attempt);
            }
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
        return attempts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeRef findDeploymentAttempt(String attemptId) {
        FacesContext fc = FacesContext.getCurrentInstance();
        SearchService searchService = Repository.getServiceRegistry(fc).getSearchService();
        StringBuilder query = new StringBuilder("@");
        query.append("wca");
        query.append("\\:");
        query.append(WCMAppModel.PROP_DEPLOYATTEMPTID.getLocalName());
        query.append(":\"");
        query.append(attemptId);
        query.append("\"");
        ResultSet results = null;
        NodeRef attempt = null;
        try {
            results = searchService.query(Repository.getStoreRef(), "lucene", query.toString());
            if (results.length() == 1) {
                attempt = results.getNodeRef(0);
            } else if (results.length() > 1) {
                throw new IllegalStateException("More than one deployment attempt node was found, there should only be one!");
            }
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
        return attempt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<NodeRef> findAllocatedTestServers(String store) {
        ArrayList<NodeRef> serverList = new ArrayList<NodeRef>();
        FacesContext fc = FacesContext.getCurrentInstance();
        SearchService searchService = Repository.getServiceRegistry(fc).getSearchService();
        StringBuilder query = new StringBuilder("@");
        query.append("wca");
        query.append("\\:");
        query.append(WCMAppModel.PROP_DEPLOYSERVERALLOCATEDTO.getLocalName());
        query.append(":\"");
        query.append(store);
        query.append("\"");
        ResultSet results = null;
        try {
            results = searchService.query(Repository.getStoreRef(), "lucene", query.toString());
            if (results.length() > 0) {
                for (int i = 0; i < results.length(); ++i) {
                    serverList.add(results.getNodeRef(i));
                }
            }
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
        return serverList;
    }

    private static String formatLuceneQueryDate(Date date, boolean range) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        StringBuilder queryDate = new StringBuilder();
        queryDate.append(cal.get(1));
        if (range) {
            queryDate.append("\\");
        }
        queryDate.append("-");
        queryDate.append(cal.get(2) + 1);
        if (range) {
            queryDate.append("\\");
        }
        queryDate.append("-");
        queryDate.append(cal.get(5));
        queryDate.append("T00:00:00");
        return queryDate.toString();
    }
}

