/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.content.EditContentPropertiesDialog;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMNode;
import org.alfresco.web.forms.FormInstanceData;
import org.alfresco.web.forms.FormsService;
import org.alfresco.web.forms.Rendition;
import org.alfresco.web.ui.common.Utils;

public class EditFilePropertiesDialog
extends EditContentPropertiesDialog {
    private static final long serialVersionUID = 635722726225138092L;
    protected AVMBrowseBean avmBrowseBean;
    private transient AVMService avmService;
    private transient FormsService formsService;

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    protected AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
        }
        return this.avmService;
    }

    public void setFormsService(FormsService formsService) {
        this.formsService = formsService;
    }

    protected FormsService getFormsService() {
        if (this.formsService == null) {
            this.formsService = (FormsService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "FormsService");
        }
        return this.formsService;
    }

    @Override
    protected Node initEditableNode() {
        return new Node(this.avmBrowseBean.getAvmActionNode().getNodeRef());
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        NodeRef nodeRef = this.editableNode.getNodeRef();
        Map<String, Object> editedProps = this.editableNode.getProperties();
        String name = (String)editedProps.get(ContentModel.PROP_NAME);
        if (name != null) {
            editedProps.remove(ContentModel.PROP_NAME);
        }
        Map repoProps = this.getNodeService().getProperties(nodeRef);
        String mimetype = (String)editedProps.get("mimetype");
        if (mimetype != null) {
            editedProps.remove("mimetype");
            ContentData contentData = (ContentData)editedProps.get(ContentModel.PROP_CONTENT);
            if (contentData != null) {
                contentData = ContentData.setMimetype((ContentData)contentData, (String)mimetype);
                editedProps.put(ContentModel.PROP_CONTENT.toString(), contentData);
            }
        }
        if (!this.getNodeService().hasAspect(nodeRef, ContentModel.ASPECT_TITLED)) {
            this.getNodeService().addAspect(nodeRef, ContentModel.ASPECT_TITLED, null);
        }
        for (String propName : editedProps.keySet()) {
            PropertyDefinition propDef;
            QName qname = QName.createQName((String)propName);
            Serializable propValue = (Serializable)editedProps.get(propName);
            if (propValue != null && propValue instanceof String && propValue.toString().length() == 0 && (propDef = this.getDictionaryService().getProperty(qname)) != null && (propDef.getDataType().getName().equals((Object)DataTypeDefinition.DOUBLE) || propDef.getDataType().getName().equals((Object)DataTypeDefinition.FLOAT) || propDef.getDataType().getName().equals((Object)DataTypeDefinition.INT) || propDef.getDataType().getName().equals((Object)DataTypeDefinition.LONG))) {
                propValue = null;
            }
            repoProps.put(qname, propValue);
        }
        DictionaryService dd = Repository.getServiceRegistry(context).getDictionaryService();
        HashMap avmProps = new HashMap();
        for (Map.Entry entry : repoProps.entrySet()) {
            PropertyDefinition propDef = dd.getProperty((QName)entry.getKey());
            if (propDef == null) continue;
            avmProps.put(entry.getKey(), new PropertyValue(propDef.getDataType().getName(), (Serializable)entry.getValue()));
        }
        this.getAvmService().setNodeProperties((String)AVMNodeConverter.ToAVMVersionPath((NodeRef)nodeRef).getSecond(), avmProps);
        String path = (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)nodeRef).getSecond();
        String parentPath = AVMNodeConverter.SplitBase((String)path)[0];
        String oldName = AVMNodeConverter.SplitBase((String)path)[1];
        if (name != null && !name.equals(oldName)) {
            FormInstanceData fid;
            if (this.getNodeService().hasAspect(nodeRef, WCMAppModel.ASPECT_RENDITION)) {
                throw new UnsupportedOperationException(this.getNodeService().getProperty(nodeRef, ContentModel.PROP_NAME) + " is a " + WCMAppModel.ASPECT_RENDITION + " and cannot be renamed");
            }
            if (this.getNodeService().hasAspect(nodeRef, WCMAppModel.ASPECT_FORM_INSTANCE_DATA)) {
                fid = this.getFormsService().getFormInstanceData(nodeRef);
                for (Rendition r : fid.getRenditions()) {
                    this.getAvmService().removeNode(r.getPath());
                }
                this.getNodeService().removeProperty(nodeRef, WCMAppModel.PROP_RENDITIONS);
            }
            this.getAvmService().rename(parentPath, oldName, parentPath, name);
            nodeRef = AVMNodeConverter.ToNodeRef((int)-1, (String)AVMNodeConverter.ExtendAVMPath((String)parentPath, (String)name));
            if (this.getNodeService().hasAspect(nodeRef, WCMAppModel.ASPECT_FORM_INSTANCE_DATA)) {
                fid = this.getFormsService().getFormInstanceData(nodeRef);
                for (FormInstanceData.RegenerateResult rr : fid.regenerateRenditions()) {
                    if (rr.getException() == null) continue;
                    outcome = null;
                    Utils.addErrorMessage("error regenerating rendition using " + rr.getRenderingEngineTemplate().getName() + ": " + rr.getException().getMessage(), rr.getException());
                }
            }
        }
        if (name != null) {
            editedProps.put(ContentModel.PROP_NAME.toString(), name);
        }
        return outcome;
    }

    @Override
    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        String name = this.editableNode.getName();
        String oldPath = (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.editableNode.getNodeRef()).getSecond();
        String newPath = oldPath.substring(0, oldPath.lastIndexOf(47) + 1) + name;
        this.avmBrowseBean.setAvmActionNode(new AVMNode(this.getAvmService().lookup(-1, newPath)));
        return outcome;
    }

    @Override
    protected String formatErrorMessage(Throwable exception) {
        if (exception instanceof FileExistsException) {
            return MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_exists"), ((FileExistsException)exception).getName());
        }
        if (exception instanceof InvalidNodeRefException) {
            return MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), this.avmBrowseBean.getAvmActionNode().getPath());
        }
        return super.formatErrorMessage(exception);
    }
}

