/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.LayeredFolderType;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.spaces.EditSpaceDialog;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMNode;
import org.alfresco.web.ui.common.component.UIListItem;

public class EditFolderPropertiesDialog
extends EditSpaceDialog {
    private static final long serialVersionUID = -6423913727249054187L;
    protected AVMBrowseBean avmBrowseBean;
    private transient AVMService avmService;

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    protected AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = (AVMService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "AVMLockingAwareService");
        }
        return this.avmService;
    }

    @Override
    protected Node initEditableNode() {
        return new Node(this.avmBrowseBean.getAvmActionNode().getNodeRef());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        NodeRef nodeRef = this.editableNode.getNodeRef();
        Map<String, Object> editedProps = this.editableNode.getProperties();
        String name = (String)editedProps.get(ContentModel.PROP_NAME);
        if (name != null) {
            editedProps.remove(ContentModel.PROP_NAME);
        }
        Map repoProps = this.getNodeService().getProperties(nodeRef);
        if (!this.getNodeService().hasAspect(nodeRef, ApplicationModel.ASPECT_UIFACETS)) {
            this.getNodeService().addAspect(nodeRef, ApplicationModel.ASPECT_UIFACETS, null);
        }
        for (String propName : editedProps.keySet()) {
            PropertyDefinition propDef;
            QName qname = QName.createQName((String)propName);
            Serializable propValue = (Serializable)editedProps.get(propName);
            if (propValue != null && propValue instanceof String && propValue.toString().length() == 0 && (propDef = this.getDictionaryService().getProperty(qname)) != null && (propDef.getDataType().getName().equals((Object)DataTypeDefinition.DOUBLE) || propDef.getDataType().getName().equals((Object)DataTypeDefinition.FLOAT) || propDef.getDataType().getName().equals((Object)DataTypeDefinition.INT) || propDef.getDataType().getName().equals((Object)DataTypeDefinition.LONG))) {
                propValue = null;
            }
            repoProps.put(qname, propValue);
        }
        DictionaryService dd = Repository.getServiceRegistry(context).getDictionaryService();
        HashMap avmProps = new HashMap();
        for (Map.Entry entry : repoProps.entrySet()) {
            PropertyDefinition propDef = dd.getProperty((QName)entry.getKey());
            if (propDef == null) continue;
            avmProps.put(entry.getKey(), new PropertyValue(propDef.getDataType().getName(), (Serializable)entry.getValue()));
        }
        this.getAvmService().setNodeProperties((String)AVMNodeConverter.ToAVMVersionPath((NodeRef)nodeRef).getSecond(), avmProps);
        if (name != null) {
            Boolean wasIssuedByWebClient = LayeredFolderType.isIssuedByWebClient();
            try {
                LayeredFolderType.setIssuedByWebClient((Boolean)true);
                this.getFileFolderService().rename(nodeRef, name);
                editedProps.put(ContentModel.PROP_NAME.toString(), name);
            }
            finally {
                LayeredFolderType.setIssuedByWebClient((Boolean)wasIssuedByWebClient);
            }
        }
        return outcome;
    }

    @Override
    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        String name = this.editableNode.getName();
        String oldPath = (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.editableNode.getNodeRef()).getSecond();
        String newPath = oldPath.substring(0, oldPath.lastIndexOf(47) + 1) + name;
        this.avmBrowseBean.setAvmActionNode(new AVMNode(this.getAvmService().lookup(-1, newPath)));
        return outcome;
    }

    @Override
    public List<UIListItem> getIcons() {
        ArrayList<UIListItem> icons = new ArrayList<UIListItem>(1);
        UIListItem item = new UIListItem();
        item.setValue("space-icon-default");
        item.setImage("/images/icons/space-icon-default.gif");
        icons.add(item);
        return icons;
    }
}

