/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.CreateFormWizard;
import org.alfresco.web.bean.wcm.WebProject;
import org.alfresco.web.forms.Form;
import org.alfresco.web.forms.RenderingEngineTemplate;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EditFormWizard
extends CreateFormWizard {
    private static final long serialVersionUID = -3260838389223325316L;
    private static final Log LOGGER = LogFactory.getLog(EditFormWizard.class);
    private List<CreateFormWizard.RenderingEngineTemplateData> removedRenderingEngineTemplates;
    private List<WebProject> associatedWebProjects;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        NodeRef formNodeRef = this.browseBean.getActionSpace().getNodeRef();
        if (formNodeRef == null) {
            throw new IllegalArgumentException("Edit Form wizard requires action node context.");
        }
        Form form = this.getFormsService().getForm(formNodeRef);
        this.setFormName(form.getName());
        this.setFormTitle(form.getTitle());
        this.setFormDescription(form.getDescription());
        this.setSchemaRootElementName(form.getSchemaRootElementName());
        NodeRef schemaNodeRef = (NodeRef)this.getNodeService().getProperty(formNodeRef, WCMAppModel.PROP_XML_SCHEMA);
        if (schemaNodeRef == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(WCMAppModel.PROP_XML_SCHEMA + " not set on " + formNodeRef + ", checking " + WCMAppModel.PROP_XML_SCHEMA_OLD));
            }
            if ((schemaNodeRef = (NodeRef)this.getNodeService().getProperty(formNodeRef, WCMAppModel.PROP_XML_SCHEMA_OLD)) != null) {
                this.getNodeService().setProperty(formNodeRef, WCMAppModel.PROP_XML_SCHEMA, (Serializable)schemaNodeRef);
            }
        }
        if (schemaNodeRef == null) {
            throw new NullPointerException("expected property " + WCMAppModel.PROP_XML_SCHEMA + " of " + formNodeRef + " for form " + form.getName() + " not to be null.");
        }
        this.setSchemaFileName((String)((Object)this.getNodeService().getProperty(schemaNodeRef, ContentModel.PROP_NAME)));
        try {
            this.schema = form.getSchema();
        }
        catch (Throwable t) {
            String msg = "unable to parse " + form.getName();
            Utils.addErrorMessage(msg, t);
        }
        WorkflowDefinition wf = form.getDefaultWorkflow();
        if (wf != null) {
            this.defaultWorkflowName = wf.getName();
        } else {
            this.applyDefaultWorkflow = false;
        }
        this.setOutputPathPatternForFormInstanceData(form.getOutputPathPattern());
        for (RenderingEngineTemplate ret : form.getRenderingEngineTemplates()) {
            CreateFormWizard.RenderingEngineTemplateData data = new CreateFormWizard.RenderingEngineTemplateData(ret);
            this.renderingEngineTemplates.add(data);
        }
        this.removedRenderingEngineTemplates = null;
        if (this.getIsWebForm()) {
            this.associatedWebProjects = this.getFormsService().getAssociatedWebProjects(form);
        }
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        NodeRef formNodeRef = this.browseBean.getActionSpace().getNodeRef();
        if (!this.getFormName().equals(this.getNodeService().getProperty(formNodeRef, ContentModel.PROP_NAME))) {
            this.getFileFolderService().rename(formNodeRef, this.getFormName());
        }
        this.getNodeService().setProperty(formNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)this.getFormTitle()));
        this.getNodeService().setProperty(formNodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)this.getFormDescription()));
        this.getNodeService().setProperty(formNodeRef, WCMAppModel.PROP_OUTPUT_PATH_PATTERN, (Serializable)((Object)this.getOutputPathPatternForFormInstanceData()));
        this.getNodeService().setProperty(formNodeRef, WCMAppModel.PROP_XML_SCHEMA_ROOT_ELEMENT_NAME, (Serializable)((Object)this.getSchemaRootElementName()));
        WorkflowDefinition wd = this.getDefaultWorkflowDefinition();
        List workflowRefs = this.getNodeService().getChildAssocs(formNodeRef, (QNamePattern)WCMAppModel.ASSOC_FORM_WORKFLOW_DEFAULTS, RegexQNamePattern.MATCH_ALL);
        if (wd != null && workflowRefs.size() == 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("adding workflow definition " + wd.getName() + " to form " + this.getFormName()));
            }
            HashMap<QName, String> props = new HashMap<QName, String>(1, 1.0f);
            props.put(WCMAppModel.PROP_WORKFLOW_NAME, wd.getName());
            this.getNodeService().createNode(formNodeRef, WCMAppModel.ASSOC_FORM_WORKFLOW_DEFAULTS, WCMAppModel.ASSOC_FORM_WORKFLOW_DEFAULTS, WCMAppModel.TYPE_WORKFLOW_DEFAULTS, props);
        } else if (wd != null && workflowRefs.size() == 1) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("setting workflow definition " + wd.getName() + " to form " + this.getFormName()));
            }
            this.getNodeService().setProperty(((ChildAssociationRef)workflowRefs.get(0)).getChildRef(), WCMAppModel.PROP_WORKFLOW_NAME, (Serializable)((Object)wd.getName()));
        } else if (wd == null && workflowRefs.size() == 1) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("removing workflow definitions from form " + this.getFormName()));
            }
            this.getNodeService().removeChild(formNodeRef, ((ChildAssociationRef)workflowRefs.get(0)).getChildRef());
        }
        if (this.getSchemaFile() != null) {
            FileInfo fileInfo = this.getFileFolderService().create(formNodeRef, this.getSchemaFileName(), ContentModel.TYPE_CONTENT);
            ContentWriter writer = this.contentService.getWriter(fileInfo.getNodeRef(), ContentModel.PROP_CONTENT, true);
            writer.setMimetype("text/xml");
            writer.setEncoding("UTF-8");
            writer.putContent(this.getSchemaFile());
            this.getNodeService().setProperty(formNodeRef, WCMAppModel.PROP_XML_SCHEMA, (Serializable)fileInfo.getNodeRef());
        }
        if (this.removedRenderingEngineTemplates != null) {
            for (CreateFormWizard.RenderingEngineTemplateData retd : this.removedRenderingEngineTemplates) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("removing rendering engine template " + retd));
                }
                assert (retd != null);
                assert (retd.getNodeRef() != null);
                this.getNodeService().removeAssociation(formNodeRef, retd.getNodeRef(), WCMAppModel.ASSOC_RENDERING_ENGINE_TEMPLATES);
                this.getNodeService().removeChild(formNodeRef, retd.getNodeRef());
                this.removeRenderingEngineTemplateFromWebProjects(formNodeRef, retd);
            }
        }
        for (CreateFormWizard.RenderingEngineTemplateData retd : this.renderingEngineTemplates) {
            if (retd.getFile() == null) continue;
            this.saveRenderingEngineTemplate(retd, formNodeRef);
            this.addRenderingEngineTemplateToWebProjects(formNodeRef, retd);
        }
        return outcome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRenderingEngineTemplateFromWebProjects(NodeRef formNodeRef, CreateFormWizard.RenderingEngineTemplateData retd) {
        List<WebProject> webProjects = this.getFormsService().getAssociatedWebProjects(this.getFormsService().getForm(formNodeRef));
        for (WebProject wp : webProjects) {
            ResultSet results = this.searchRenderingEngineTemplateInWebProject(wp, retd.getName());
            try {
                for (int i = 0; i < results.length(); ++i) {
                    NodeRef webformTemplateNodeRef = results.getNodeRef(i);
                    NodeRef webformNodeRef = this.getNodeService().getPrimaryParent(webformTemplateNodeRef).getParentRef();
                    this.getNodeService().removeChild(webformNodeRef, webformTemplateNodeRef);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)webformNodeRef);
                }
            }
            finally {
                results.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRenderingEngineTemplateToWebProjects(NodeRef formNodeRef, CreateFormWizard.RenderingEngineTemplateData retd) {
        Form form = this.getFormsService().getForm(formNodeRef);
        List<WebProject> webProjects = this.getFormsService().getAssociatedWebProjects(form);
        HashMap<QName, String> props = new HashMap<QName, String>(4, 1.0f);
        for (WebProject wp : webProjects) {
            ResultSet results = this.searchRenderingEngineTemplateInWebProject(wp, retd.getName());
            try {
                int resultsCount = results.length();
                if (resultsCount > 0) {
                    for (int i = 0; i < resultsCount; ++i) {
                        NodeRef webformTemplateNodeRef = results.getNodeRef(i);
                        if (retd.getOutputPathPatternForRendition() == null) continue;
                        props.clear();
                        props.put(WCMAppModel.PROP_OUTPUT_PATH_PATTERN, retd.getOutputPathPatternForRendition());
                        this.getNodeService().addAspect(webformTemplateNodeRef, WCMAppModel.ASPECT_OUTPUT_PATH_PATTERN, props);
                    }
                    continue;
                }
                String query = "+TYPE:\"" + WCMAppModel.TYPE_WEBFORM + "\"" + " +@" + Repository.escapeQName(WCMAppModel.PROP_FORMNAME) + ":\"" + form.getName() + "\"";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Search web forms query: " + query));
                }
                ResultSet webforms = this.getSearchService().query(wp.getNodeRef().getStoreRef(), "lucene", query);
                try {
                    for (int i = 0; i < webforms.length(); ++i) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("WebForm NodeRef: " + webforms.getNodeRef(i)));
                        }
                        props.clear();
                        props.put(WCMAppModel.PROP_BASE_RENDERING_ENGINE_TEMPLATE_NAME, retd.getName());
                        NodeRef templateRef = this.getNodeService().createNode(webforms.getNodeRef(i), WCMAppModel.ASSOC_WEBFORMTEMPLATE, WCMAppModel.ASSOC_WEBFORMTEMPLATE, WCMAppModel.TYPE_WEBFORMTEMPLATE, props).getChildRef();
                        if (retd.getOutputPathPatternForRendition() == null) continue;
                        props.clear();
                        props.put(WCMAppModel.PROP_OUTPUT_PATH_PATTERN, retd.getOutputPathPatternForRendition());
                        this.getNodeService().addAspect(templateRef, WCMAppModel.ASPECT_OUTPUT_PATH_PATTERN, props);
                    }
                }
                finally {
                    webforms.close();
                }
            }
            finally {
                results.close();
            }
        }
    }

    private ResultSet searchRenderingEngineTemplateInWebProject(WebProject wp, String name) {
        ResultSet result = null;
        StringBuilder query = new StringBuilder(256);
        query.append("+TYPE:\"").append(WCMAppModel.TYPE_WEBFORMTEMPLATE).append("\" ");
        query.append("+@").append(Repository.escapeQName(WCMAppModel.PROP_BASE_RENDERING_ENGINE_TEMPLATE_NAME)).append(":\"").append(name).append("\" ");
        StoreRef storeRef = wp.getNodeRef().getStoreRef();
        result = this.getSearchService().query(storeRef, "lucene", query.toString());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(">>>Web Project: " + wp));
            LOGGER.debug((Object)(">>>StoreRef: " + storeRef));
            LOGGER.debug((Object)(">>>Search query: " + query.toString()));
            LOGGER.debug((Object)(">>>Search results: " + result.length()));
        }
        return result;
    }

    @Override
    public void removeSelectedRenderingEngineTemplate(ActionEvent event) {
        CreateFormWizard.RenderingEngineTemplateData wrapper = (CreateFormWizard.RenderingEngineTemplateData)this.getRenderingEngineTemplatesDataModel().getRowData();
        if (wrapper != null) {
            if (this.removedRenderingEngineTemplates == null) {
                this.removedRenderingEngineTemplates = new LinkedList<CreateFormWizard.RenderingEngineTemplateData>();
            }
            this.removedRenderingEngineTemplates.add(wrapper);
        }
        super.removeSelectedRenderingEngineTemplate(event);
    }

    @Override
    public boolean getEditMode() {
        return true;
    }

    @Override
    public List<WebProject> getAssociatedWebProjects() {
        return this.associatedWebProjects;
    }
}

