/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.SelectItem;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.users.UserMembersBean;
import org.alfresco.web.bean.wcm.AVMNode;
import org.alfresco.web.bean.wcm.ManagePermissionsDialog;
import org.alfresco.web.bean.wcm.UpdatePermissionsDialog;
import org.alfresco.web.bean.wcm.WCMPermissionsUtils;
import org.alfresco.web.ui.common.component.UIActionLink;

public class EditPermissionsDialog
extends UpdatePermissionsDialog {
    private static final long serialVersionUID = 670465612383178325L;
    private static final String MSG_EDIT_PERMS_FOR = "edit_permissions_title";
    private boolean finishButtonDisabled = true;
    private List<UserMembersBean.PermissionWrapper> personPerms = null;
    private transient DataModel personPermsDataModel = null;
    private String personAuthority;

    public void setupAction(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        this.personAuthority = params.get("userName");
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setActiveNode(this.getAvmBrowseBean().getAvmActionNode());
        this.personPerms = new ArrayList<UserMembersBean.PermissionWrapper>(3);
        this.personPermsDataModel = null;
        NodeRef actionNode = this.getAvmBrowseBean().getAvmActionNode().getNodeRef();
        NodeRef parentRef = this.getNodeService().getPrimaryParent(actionNode).getParentRef();
        Set parentPermission = this.getPermissionService().getAllSetPermissions(parentRef);
        Set<String> permsForRemove = ManagePermissionsDialog.getPermissionsForType();
        Set allSetPerms = this.getPermissionService().getAllSetPermissions(this.getActiveNode().getNodeRef());
        for (AccessPermission perm : allSetPerms) {
            if (parentPermission.contains(perm) || !perm.getAuthority().equals(this.personAuthority) || !permsForRemove.contains(perm.getPermission())) continue;
            UserMembersBean.PermissionWrapper wraper = new UserMembersBean.PermissionWrapper(perm.getPermission(), perm.getPermission());
            this.personPerms.add(wraper);
        }
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return this.finishButtonDisabled;
    }

    @Override
    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        String pattern = Application.getMessage(fc, MSG_EDIT_PERMS_FOR);
        return MessageFormat.format(pattern, this.personAuthority);
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        this.setPermissions(this.getActiveNode());
        this.createLock(this.getActiveNode());
        this.finishButtonDisabled = true;
        return outcome;
    }

    @Override
    public String cancel() {
        this.finishButtonDisabled = true;
        return super.cancel();
    }

    private void setPermissions(AVMNode node) {
        NodeRef nodeRef = node.getNodeRef();
        Set<String> permsForRemove = ManagePermissionsDialog.getPermissionsForType();
        for (String perm : permsForRemove) {
            boolean needToSet = false;
            for (UserMembersBean.PermissionWrapper wrapper : this.personPerms) {
                if (!wrapper.getPermission().equals(perm)) continue;
                needToSet = true;
                break;
            }
            if (needToSet) {
                this.getPermissionService().setPermission(nodeRef, this.personAuthority, perm, true);
                continue;
            }
            this.getPermissionService().deletePermission(nodeRef, this.personAuthority, perm);
        }
    }

    public SelectItem[] getPerms() {
        return WCMPermissionsUtils.getPermissions();
    }

    public void addPermission(ActionEvent event) {
        UISelectOne permPicker = (UISelectOne)event.getComponent().findComponent("perms");
        String permission = (String)permPicker.getValue();
        if (permission != null) {
            UserMembersBean.PermissionWrapper wrapper;
            boolean foundExisting = false;
            for (int n = 0; n < this.personPerms.size(); ++n) {
                wrapper = this.personPerms.get(n);
                if (!wrapper.getPermission().equals(permission)) continue;
                foundExisting = true;
                break;
            }
            if (!foundExisting) {
                FacesContext context = FacesContext.getCurrentInstance();
                wrapper = new UserMembersBean.PermissionWrapper(permission, Application.getMessage(context, permission));
                this.personPerms.add(wrapper);
                this.finishButtonDisabled = false;
            }
        }
    }

    public DataModel getPersonPermsDataModel() {
        if (this.personPermsDataModel == null) {
            this.personPermsDataModel = new ListDataModel();
        }
        if (this.personPermsDataModel.getWrappedData() == null) {
            this.personPermsDataModel.setWrappedData(this.personPerms);
        }
        return this.personPermsDataModel;
    }

    public void removePermission(ActionEvent event) {
        UserMembersBean.PermissionWrapper wrapper = (UserMembersBean.PermissionWrapper)this.getPersonPermsDataModel().getRowData();
        if (wrapper != null) {
            this.personPerms.remove(wrapper);
            this.finishButtonDisabled = false;
        }
    }
}

