/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.alfresco.model.WCMAppModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.wcm.webproject.WebProjectInfo;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.CreateWebsiteWizard;

public class EditWebsiteWizard
extends CreateWebsiteWizard {
    private static final long serialVersionUID = -4856350244207566218L;
    protected AVMBrowseBean avmBrowseBean;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.editMode = true;
        NodeRef websiteRef = this.browseBean.getActionSpace().getNodeRef();
        if (websiteRef == null) {
            throw new IllegalArgumentException("Edit Web Project wizard requires action node context.");
        }
        this.webappsList = null;
        this.loadWebProjectModel(websiteRef, true, false);
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    @Override
    public List<SelectItem> getWebappsList() {
        if (this.webappsList == null) {
            List webApps = this.getWebProjectService().listWebApps(this.getWebProjectNodeRef());
            this.webappsList = new ArrayList(webApps.size());
            for (String webAppName : webApps) {
                this.webappsList.add(new SelectItem((Object)webAppName, webAppName));
            }
        }
        return this.webappsList;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        NodeRef nodeRef = this.browseBean.getActionSpace().getNodeRef();
        WebProjectInfo wpInfo = this.getWebProjectService().getWebProject(nodeRef);
        if (!wpInfo.getName().equals(this.name)) {
            this.getFileFolderService().rename(nodeRef, this.name);
        }
        wpInfo.setName(this.name);
        wpInfo.setTitle(this.title);
        wpInfo.setDescription(this.description);
        wpInfo.setIsTemplate(this.isSource);
        wpInfo.setPreviewProviderName(this.previewProvider);
        this.getWebProjectService().updateWebProject(wpInfo);
        this.clearWebProjectModel(nodeRef);
        if (this.webapp != null && this.webapp.length() != 0) {
            this.getNodeService().setProperty(nodeRef, WCMAppModel.PROP_DEFAULTWEBAPP, (Serializable)((Object)this.webapp));
            this.avmBrowseBean.setWebapp(this.webapp);
        }
        this.saveWebProjectModel(nodeRef);
        this.navigator.resetCurrentNodeProperties();
        return "wizard:close";
    }

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    private void clearWebProjectModel(NodeRef nodeRef) {
        List webFormRefs = this.getNodeService().getChildAssocs(nodeRef, (QNamePattern)WCMAppModel.ASSOC_WEBFORM, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef ref : webFormRefs) {
            this.getNodeService().removeChild(nodeRef, ref.getChildRef());
        }
        List wfRefs = this.getNodeService().getChildAssocs(nodeRef, (QNamePattern)WCMAppModel.ASSOC_WEBWORKFLOWDEFAULTS, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef ref : wfRefs) {
            this.getNodeService().removeChild(nodeRef, ref.getChildRef());
        }
        List serverRefs = this.getNodeService().getChildAssocs(nodeRef, (QNamePattern)WCMAppModel.ASSOC_DEPLOYMENTSERVER, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef ref : serverRefs) {
            this.getNodeService().removeChild(nodeRef, ref.getChildRef());
        }
    }
}

