/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.File;
import java.text.MessageFormat;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.wcm.asset.AssetService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.bean.FileUploadBean;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.ui.common.Utils;

public class ImportWebsiteDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -432986732265292504L;
    protected File file;
    protected String fileName;
    protected boolean isFinished = false;
    protected boolean highByteZip = false;
    protected AVMBrowseBean avmBrowseBean;
    private transient AssetService assetService;

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    protected AssetService getAssetService() {
        if (this.assetService == null) {
            this.assetService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAssetService();
        }
        return this.assetService;
    }

    public String getFileName() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        FileUploadBean fileBean = (FileUploadBean)ctx.getExternalContext().getSessionMap().get("alfresco.UploadBean");
        if (fileBean != null) {
            this.file = fileBean.getFile();
            this.fileName = fileBean.getFileName();
        }
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        FacesContext ctx = FacesContext.getCurrentInstance();
        FileUploadBean fileBean = (FileUploadBean)ctx.getExternalContext().getSessionMap().get("alfresco.UploadBean");
        if (fileBean != null) {
            fileBean.setFileName(this.fileName);
        }
    }

    public boolean isHighByteZip() {
        return this.highByteZip;
    }

    public void setHighByteZip(boolean highByteZip) {
        this.highByteZip = highByteZip;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return this.fileName == null || this.fileName.length() == 0;
    }

    public void start(ActionEvent event) {
        this.clearUpload();
        this.fileName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String finish() {
        String outcome = null;
        if (!this.isFinished) {
            this.isFinished = true;
            try {
                FacesContext context = FacesContext.getCurrentInstance();
                RetryingTransactionHelper.RetryingTransactionCallback<Object> cb = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    public Object execute() {
                        String rootPath = ImportWebsiteDialog.this.avmBrowseBean.getCurrentPath();
                        String[] parts = rootPath.split(":");
                        String sbStoreId = parts[0];
                        String parentFolderPath = parts[1];
                        ImportWebsiteDialog.this.getAssetService().bulkImport(sbStoreId, parentFolderPath, ImportWebsiteDialog.this.file, ImportWebsiteDialog.this.isHighByteZip());
                        return null;
                    }
                };
                Repository.getRetryingTransactionHelper(context).doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)cb);
                UIContextService.getInstance(context).notifyBeans();
                outcome = "dialog:close";
            }
            catch (Throwable e) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), e.getMessage()), e);
            }
            finally {
                this.isFinished = false;
            }
        }
        return outcome;
    }

    public String removeUploadedFile() {
        this.clearUpload();
        this.fileName = null;
        return null;
    }

    @Override
    public String cancel() {
        this.clearUpload();
        return "dialog:close";
    }

    protected void clearUpload() {
        if (this.file != null) {
            this.file.delete();
        }
        this.file = null;
        FacesContext ctx = FacesContext.getCurrentInstance();
        ctx.getExternalContext().getSessionMap().remove("alfresco.UploadBean");
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return null;
    }
}

