/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.alfresco.model.WCMAppModel;
import org.alfresco.wcm.webproject.WebProjectService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wizard.BaseInviteUsersWizard;
import org.alfresco.web.ui.common.Utils;

public class InviteWebsiteUsersWizard
extends BaseInviteUsersWizard {
    private static final long serialVersionUID = -8128781845465773847L;
    private Node website;
    private String avmStore;
    private boolean standalone = true;
    private transient WebProjectService wpService;

    public void setWebProjectService(WebProjectService wpService) {
        this.wpService = wpService;
    }

    protected WebProjectService getWebProjectService() {
        if (this.wpService == null) {
            this.wpService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getWebProjectService();
        }
        return this.wpService;
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.allowDuplicateAuthorities = false;
        this.website = null;
        this.avmStore = null;
        this.standalone = true;
    }

    public void reset() {
        this.isFinished = false;
        this.allowDuplicateAuthorities = false;
        this.website = null;
        this.avmStore = null;
        this.standalone = true;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        super.finishImpl(context, outcome);
        HashMap<String, String> selectedInvitees = new HashMap<String, String>(this.userGroupRoles.size());
        for (BaseInviteUsersWizard.UserGroupRole userRole : this.userGroupRoles) {
            selectedInvitees.put(userRole.getAuthority(), userRole.getRole());
        }
        this.getWebProjectService().inviteWebUsersGroups(this.getNode().getNodeRef(), selectedInvitees, true);
        return outcome;
    }

    @Override
    public String getSummary() {
        FacesContext fc = FacesContext.getCurrentInstance();
        StringBuilder buf = new StringBuilder(128);
        String currentUser = Application.getCurrentUser(fc).getUserName();
        boolean foundCurrentUser = false;
        for (BaseInviteUsersWizard.UserGroupRole userRole : this.userGroupRoles) {
            if (currentUser.equals(userRole.getAuthority())) {
                foundCurrentUser = true;
            }
            buf.append(Utils.encode((String)userRole.getLabel()));
            buf.append("<br>");
        }
        if (!this.isStandalone() && !foundCurrentUser) {
            buf.append(this.buildLabelForUserAuthorityRole(currentUser, "ContentManager"));
        }
        return this.buildSummary(new String[]{Application.getMessage(fc, "invite_users_summary")}, new String[]{buf.toString()});
    }

    @Override
    protected Set<String> getPermissionsForType() {
        return this.permissionService.getSettablePermissions(WCMAppModel.TYPE_AVMWEBFOLDER);
    }

    protected void setNode(Node node) {
        this.website = node;
    }

    @Override
    protected Node getNode() {
        if (this.website != null) {
            return this.website;
        }
        return this.browseBean.getActionSpace();
    }

    public String getAvmStore() {
        if (this.avmStore == null) {
            this.avmStore = (String)this.getNode().getProperties().get(WCMAppModel.PROP_AVMSTORE);
        }
        return this.avmStore;
    }

    public void setAvmStore(String avmStore) {
        this.avmStore = avmStore;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean editMode) {
        this.standalone = editMode;
    }

    @Override
    protected String getEmailTemplateXPath() {
        FacesContext fc = FacesContext.getCurrentInstance();
        String xpath = Application.getRootPath(fc) + "/" + Application.getGlossaryFolderName(fc) + "/" + Application.getEmailTemplatesFolderName(fc) + "/" + Application.getInviteEmailTemplatesFolderName(fc) + "//*";
        return xpath;
    }
}

