/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMNode;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.WebProject;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.forms.Form;
import org.alfresco.web.forms.FormInstanceData;
import org.alfresco.web.forms.FormNotFoundException;
import org.alfresco.web.forms.FormsService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PromptForWebFormDialog
extends BaseDialogBean {
    private static final long serialVersionUID = 8062203927131257236L;
    private static final Log logger = LogFactory.getLog(PromptForWebFormDialog.class);
    private transient AVMService avmService;
    protected AVMBrowseBean avmBrowseBean;
    private transient FormsService formsService;
    private transient List<SelectItem> formChoices;
    private String formName;
    private String cancelOutcome;
    private String finishOutcome;

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    protected AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
        }
        return this.avmService;
    }

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public void setFormsService(FormsService formsService) {
        this.formsService = formsService;
    }

    protected FormsService getFormsService() {
        if (this.formsService == null) {
            this.formsService = (FormsService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "FormsService");
        }
        return this.formsService;
    }

    public AVMNode getAvmNode() {
        return this.avmBrowseBean.getAvmActionNode();
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.cancelOutcome = this.parameters.containsKey("cancelOutcome") ? (String)this.parameters.get("cancelOutcome") : "dialog:editAvmFile";
        this.finishOutcome = this.parameters.containsKey("finishOutcome") ? (String)this.parameters.get("finishOutcome") : "wizard:editWebContent";
        this.formName = null;
        this.formChoices = null;
        String avmPath = this.getAvmNode().getPath();
        if (this.getAvmService().hasAspect(this.getAvmNode().getVersion(), avmPath, WCMAppModel.ASPECT_FORM_INSTANCE_DATA)) {
            FormInstanceData fid = null;
            try {
                fid = this.getFormsService().getFormInstanceData(this.getAvmNode().getVersion(), avmPath);
                Form f = fid.getForm();
                this.formName = f.getName();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(avmPath + ".getForm() did not throw a form not found.  why are we here?"));
                }
            }
            catch (FormNotFoundException fnfe) {
                String msg = fnfe.getWebProject() != null ? "prompt_for_web_form_form_not_found_error_in_web_project" : "prompt_for_web_form_form_not_found_error";
                msg = Application.getMessage(FacesContext.getCurrentInstance(), msg);
                if (fid != null) {
                    msg = fnfe.getWebProject() != null ? MessageFormat.format(msg, fnfe.getFormName(), fid.getName(), fnfe.getWebProject().getName()) : MessageFormat.format(msg, fnfe.getFormName(), fid.getName());
                }
                this.avmBrowseBean.displayStatusMessage(FacesContext.getCurrentInstance(), msg);
            }
        }
    }

    @Override
    public String cancel() {
        this.getAvmService().removeAspect(this.getAvmNode().getPath(), WCMAppModel.ASPECT_RENDITION);
        this.getAvmService().removeAspect(this.getAvmNode().getPath(), WCMAppModel.ASPECT_FORM_INSTANCE_DATA);
        return super.cancel();
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("configuring " + this.getAvmNode().getPath() + " to use form " + this.getFormName()));
        }
        if (!this.getAvmService().hasAspect(this.getAvmNode().getVersion(), this.getAvmNode().getPath(), WCMAppModel.ASPECT_FORM_INSTANCE_DATA)) {
            String cwd = AVMUtil.getCorrespondingPathInPreviewStore(this.avmBrowseBean.getCurrentPath());
            HashMap<QName, String> props = new HashMap<QName, String>(1, 1.0f);
            props.put(WCMAppModel.PROP_PARENT_FORM_NAME, this.getFormName());
            props.put(WCMAppModel.PROP_ORIGINAL_PARENT_PATH, cwd);
            this.getNodeService().addAspect(this.getAvmNode().getNodeRef(), WCMAppModel.ASPECT_FORM_INSTANCE_DATA, props);
        } else {
            this.getAvmService().setNodeProperty(this.getAvmNode().getPath(), WCMAppModel.PROP_PARENT_FORM_NAME, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)this.getFormName())));
        }
        return outcome;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return this.getFormChoices().size() == 0;
    }

    @Override
    protected String getDefaultCancelOutcome() {
        return super.getDefaultCancelOutcome() + ":" + this.cancelOutcome;
    }

    @Override
    protected String getDefaultFinishOutcome() {
        return super.getDefaultFinishOutcome() + ":" + this.finishOutcome;
    }

    public List<SelectItem> getFormChoices() {
        if (this.formChoices == null) {
            WebProject wp = new WebProject(this.getAvmNode().getPath());
            List<Form> forms = wp.getForms();
            this.formChoices = new ArrayList<SelectItem>(forms.size());
            for (Form f : forms) {
                this.formChoices.add(new SelectItem((Object)f.getName(), f.getTitle()));
            }
            QuickSort sorter = new QuickSort(this.formChoices, "label", true, "case-insensitive");
            sorter.sort();
        }
        return this.formChoices;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }
}

