/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.wcm.AVMNode;
import org.alfresco.web.bean.wcm.ManagePermissionsDialog;
import org.alfresco.web.bean.wcm.UpdatePermissionsDialog;
import org.alfresco.web.ui.common.component.UIActionLink;

public class RemovePermissionsDialog
extends UpdatePermissionsDialog {
    private static final long serialVersionUID = 7804466683515156182L;
    private static final String MSG_YES = "yes";
    private static final String MSG_NO = "no";
    private static final String MSG_REMOVE_PERMS_FOR = "remove_permissions_title";
    private String personAuthority = null;

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_YES);
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_NO);
    }

    @Override
    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        String pattern = Application.getMessage(fc, MSG_REMOVE_PERMS_FOR);
        return MessageFormat.format(pattern, this.personAuthority);
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setActiveNode(this.getAvmBrowseBean().getAvmActionNode());
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        this.removePermissions(this.getActiveNode());
        this.createLock(this.getActiveNode());
        return outcome;
    }

    private void removePermissions(AVMNode node) {
        Set<String> permsForRemove = ManagePermissionsDialog.getPermissionsForType();
        Set allSetPerms = this.getPermissionService().getAllSetPermissions(node.getNodeRef());
        for (AccessPermission perm : allSetPerms) {
            if (!perm.getAuthority().equals(this.personAuthority) || !permsForRemove.contains(perm.getPermission())) continue;
            this.getPermissionService().deletePermission(node.getNodeRef(), this.personAuthority, perm.getPermission());
        }
    }

    public void setupAction(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        this.personAuthority = params.get("userName");
    }
}

