/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.text.MessageFormat;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.alfresco.wcm.sandbox.SandboxService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;

public class RevertAllDialog
extends BaseDialogBean {
    private static final long serialVersionUID = 2693006540783155474L;
    private static final String MSG_REVERTALL_SUCCESS = "revertall_success";
    protected AVMBrowseBean avmBrowseBean;
    private transient SandboxService sbService;

    public void setSandboxService(SandboxService sbService) {
        this.sbService = sbService;
    }

    protected SandboxService getSandboxService() {
        if (this.sbService == null) {
            this.sbService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getSandboxService();
        }
        return this.sbService;
    }

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        String webApp = this.avmBrowseBean.getWebapp();
        String userSandboxId = this.avmBrowseBean.getSandbox();
        this.getSandboxService().revertWebApp(userSandboxId, webApp);
        String msg = MessageFormat.format(Application.getMessage(context, MSG_REVERTALL_SUCCESS), this.avmBrowseBean.getUsername());
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_INFO, msg, msg);
        context.addMessage("website:sandboxes-panel", facesMsg);
        return outcome;
    }

    public String getConfirmMessage() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "revert_all_confirm");
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }
}

