/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SnapshotSandboxDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -7325435181889945320L;
    private static final Log logger = LogFactory.getLog(SnapshotSandboxDialog.class);
    private static final String MSG_SNAPSHOT_FAILURE = "snapshot_failure";
    private static final String MSG_SNAPSHOT_SUCCESS = "snapshot_success";
    private transient AVMService avmService;
    protected AVMBrowseBean avmBrowseBean;
    private String label;
    private String description;

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    protected AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
        }
        return this.avmService;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.label = null;
        this.description = null;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        int oldVersion = this.getAvmService().getLatestSnapshotID(this.avmBrowseBean.getSandbox());
        int version = (Integer)this.getAvmService().createSnapshot(this.avmBrowseBean.getSandbox(), this.label, this.description).get(this.avmBrowseBean.getSandbox());
        if (version > oldVersion) {
            String msg = MessageFormat.format(Application.getMessage(context, MSG_SNAPSHOT_SUCCESS), this.label, this.avmBrowseBean.getSandbox());
            this.avmBrowseBean.displayStatusMessage(context, msg);
        } else {
            String msg = Application.getMessage(context, MSG_SNAPSHOT_FAILURE);
            this.avmBrowseBean.displayStatusMessage(context, msg);
        }
        return outcome;
    }
}

