/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.NameMatcher;
import org.alfresco.wcm.sandbox.SandboxFactory;
import org.alfresco.wcm.sandbox.SandboxService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.DownloadContentServlet;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.AVMWorkflowUtil;
import org.alfresco.web.bean.wcm.WorkflowConfiguration;
import org.alfresco.web.forms.Form;
import org.alfresco.web.forms.FormInstanceData;
import org.alfresco.web.forms.FormNotFoundException;
import org.alfresco.web.forms.FormsService;
import org.alfresco.web.forms.Rendition;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIListItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

public class SubmitDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -2445905376358150000L;
    public static final String PARAM_LOAD_SELECTED_NODES_FROM_BROWSE_BEAN = "loadSelectedNodesFromBrowseBean";
    private static final String SPACE_ICON = "/images/icons/space_small.gif";
    private static final String MSG_DELETED_ITEM = "avm_node_deleted";
    private static final String MSG_ERR_WORKFLOW_CONFIG = "submit_workflow_config_error";
    public static final String MSG_ERR_INVALID_LAUNCH_DATE = "msg_err_invalid_launch_date_on_submit";
    public static final String MSG_ERR_INVALID_EXPIRATION_DATE = "msg_err_invalid_expiration_date_on_submit";
    public static final String MSG_ERR_PATTERN_INVALID_EXPIRATION_DATE = "msg_err_pattern_invalid_expiration_date_on_submit";
    private String comment;
    private String label;
    private String[] workflowSelectedValue;
    private boolean enteringExpireDate = false;
    private boolean loadSelectedNodesFromBrowseBean = false;
    private boolean autoDeploy = false;
    private Date defaultExpireDate;
    private Date launchDate;
    private List<ItemWrapper> submitItems;
    private List<ItemWrapper> warningItems;
    private HashSet<FormWorkflowWrapper> workflows;
    private Map<String, Date> expirationDates;
    private List<UIListItem> workflowItems;
    private Map<QName, Serializable> workflowParams;
    protected AVMBrowseBean avmBrowseBean;
    private transient AVMService avmService;
    private transient WorkflowService workflowService;
    private transient AVMSyncService avmSyncService;
    private transient FormsService formsService;
    private transient SandboxFactory sandboxFactory;
    private transient SandboxService sandboxService;
    private transient NameMatcher nameMatcher;
    protected WorkflowConfiguration actionWorkflow = null;
    private static final Log logger = LogFactory.getLog(SubmitDialog.class);

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    protected AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
        }
        return this.avmService;
    }

    public void setAvmSyncService(AVMSyncService avmSyncService) {
        this.avmSyncService = avmSyncService;
    }

    protected AVMSyncService getAvmSyncService() {
        if (this.avmSyncService == null) {
            this.avmSyncService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMSyncService();
        }
        return this.avmSyncService;
    }

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected WorkflowService getWorkflowService() {
        if (this.workflowService == null) {
            this.workflowService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getWorkflowService();
        }
        return this.workflowService;
    }

    public void setNameMatcher(NameMatcher nameMatcher) {
        this.nameMatcher = nameMatcher;
    }

    protected NameMatcher getNameMatcher() {
        if (this.nameMatcher == null) {
            this.nameMatcher = (NameMatcher)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "globalPathExcluder");
        }
        return this.nameMatcher;
    }

    public void setFormsService(FormsService formsService) {
        this.formsService = formsService;
    }

    protected FormsService getFormsService() {
        if (this.formsService == null) {
            this.formsService = (FormsService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "FormsService");
        }
        return this.formsService;
    }

    public void setSandboxService(SandboxService sandboxService) {
        this.sandboxService = sandboxService;
    }

    protected SandboxService getSandboxService() {
        if (this.sandboxService == null) {
            this.sandboxService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getSandboxService();
        }
        return this.sandboxService;
    }

    public void setSandboxFactory(SandboxFactory sandboxFactory) {
        this.sandboxFactory = sandboxFactory;
    }

    protected SandboxFactory getSandboxFactory() {
        if (this.sandboxFactory == null) {
            this.sandboxFactory = (SandboxFactory)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "SandboxFactory");
        }
        return this.sandboxFactory;
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.comment = null;
        this.label = null;
        this.submitItems = null;
        this.warningItems = null;
        this.workflowItems = null;
        this.workflows = new HashSet(4);
        this.expirationDates = new HashMap<String, Date>(8);
        this.defaultExpireDate = new Date();
        this.workflowSelectedValue = null;
        this.launchDate = null;
        this.autoDeploy = false;
        this.workflowParams = null;
        this.loadSelectedNodesFromBrowseBean = Boolean.valueOf((String)this.parameters.get(PARAM_LOAD_SELECTED_NODES_FROM_BROWSE_BEAN));
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String finish() {
        if (this.getSubmitItemsSize() == 0) {
            return null;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        String outcome = null;
        if (!this.isFinished) {
            this.isFinished = true;
            try {
                String workflowName = null;
                if (this.workflowSelectedValue != null && this.workflowSelectedValue.length > 0) {
                    workflowName = this.workflowSelectedValue[0];
                    for (FormWorkflowWrapper wrapper : this.workflows) {
                        if (!wrapper.name.equals(workflowName)) continue;
                        this.workflowParams = wrapper.params;
                    }
                    if (this.workflowParams == null) {
                        Utils.addErrorMessage(Application.getMessage(context, MSG_ERR_WORKFLOW_CONFIG));
                        Iterator<FormWorkflowWrapper> i$ = outcome;
                        return i$;
                    }
                }
                final String finalWorkflowName = workflowName;
                List<ItemWrapper> items = this.getSubmitItems();
                final ArrayList<String> relativePaths = new ArrayList<String>(items.size());
                for (ItemWrapper wrapper : items) {
                    relativePaths.add(AVMUtil.getStoreRelativePath(wrapper.getDescriptor().getPath()));
                }
                Date currentDate = new Date();
                if (this.launchDate != null && this.launchDate.before(currentDate)) {
                    ItemWrapper wrapper;
                    Utils.addErrorMessage(Application.getMessage(context, MSG_ERR_INVALID_LAUNCH_DATE));
                    wrapper = null;
                    return wrapper;
                }
                if (this.submitItems != null && !this.submitItems.isEmpty() && this.expirationDates != null && !this.expirationDates.isEmpty()) {
                    StringBuilder errorMessage = new StringBuilder();
                    int errFlag = 0;
                    for (ItemWrapper wrapper : this.submitItems) {
                        String key = wrapper.descriptor.getPath();
                        Date expiritionDate = this.expirationDates.get(key);
                        if (expiritionDate == null) continue;
                        if (this.launchDate != null) {
                            if (!expiritionDate.before(this.launchDate)) continue;
                            errFlag = 1;
                            errorMessage.append(wrapper.descriptor.getName()).append(", ");
                            continue;
                        }
                        if (!expiritionDate.before(currentDate)) continue;
                        errorMessage.append(wrapper.descriptor.getName()).append(", ");
                        errFlag = 2;
                    }
                    if (errorMessage.length() > 0) {
                        errorMessage.delete(errorMessage.length() - 2, errorMessage.length());
                    }
                    switch (errFlag) {
                        case 1: {
                            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, MSG_ERR_PATTERN_INVALID_EXPIRATION_DATE), errorMessage.toString()));
                            Iterator<ItemWrapper> i$ = null;
                            return i$;
                        }
                        case 2: {
                            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, MSG_ERR_INVALID_EXPIRATION_DATE), errorMessage.toString()));
                            Iterator<ItemWrapper> i$ = null;
                            return i$;
                        }
                    }
                }
                final String sbStoreId = this.avmBrowseBean.getSandbox();
                String submitLabel = this.label;
                String submitComment = this.comment;
                if (submitLabel != null && submitLabel.length() > 255) {
                    submitLabel = submitLabel.substring(0, 255);
                }
                if (submitComment != null && submitComment.length() > 255) {
                    submitComment = submitComment.substring(0, 255);
                }
                final String finalSubmitLabel = submitLabel;
                final String finalSubmitComment = submitComment;
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        SubmitDialog.this.getSandboxService().submitListAssets(sbStoreId, relativePaths, finalWorkflowName, SubmitDialog.this.workflowParams, finalSubmitLabel, finalSubmitComment, SubmitDialog.this.expirationDates, SubmitDialog.this.launchDate, SubmitDialog.this.autoDeploy);
                        return null;
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
                outcome = this.getDefaultFinishOutcome();
            }
            finally {
                this.isFinished = false;
            }
        }
        return outcome;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return this.getSubmitItemsSize() == 0;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Date getDefaultExpireDate() {
        return this.defaultExpireDate;
    }

    public void setDefaultExpireDate(Date defaultExpireDate) {
        this.defaultExpireDate = defaultExpireDate;
    }

    public boolean isEnteringExpireDate() {
        return this.enteringExpireDate;
    }

    public Map<String, Date> getExpiredDates() {
        return this.expirationDates;
    }

    public String[] getWorkflowSelectedValue() {
        return this.workflowSelectedValue;
    }

    public void setWorkflowSelectedValue(String[] workflowSelectedValue) {
        this.workflowSelectedValue = workflowSelectedValue;
    }

    public Date getLaunchDate() {
        return this.launchDate;
    }

    public void setLaunchDate(Date launchDate) {
        this.launchDate = launchDate;
    }

    public boolean isAutoDeploy() {
        return this.autoDeploy;
    }

    public void setAutoDeploy(boolean autoDeploy) {
        this.autoDeploy = autoDeploy;
    }

    public List<UIListItem> getWorkflowList() {
        if (this.workflowItems == null) {
            this.calcluateListItemsAndWorkflows();
            NodeRef websiteRef = this.avmBrowseBean.getWebsite().getNodeRef();
            List webWorkflowRefs = this.getNodeService().getChildAssocs(websiteRef, (QNamePattern)WCMAppModel.ASSOC_WEBWORKFLOWDEFAULTS, RegexQNamePattern.MATCH_ALL);
            ArrayList<FormWorkflowWrapper> workflowMatchers = new ArrayList<FormWorkflowWrapper>(webWorkflowRefs.size());
            for (ChildAssociationRef ref : webWorkflowRefs) {
                NodeRef wfDefaultsRef = ref.getChildRef();
                String wfName = (String)((Object)this.getNodeService().getProperty(wfDefaultsRef, WCMAppModel.PROP_WORKFLOW_NAME));
                Map params = (Map)((Object)AVMWorkflowUtil.deserializeWorkflowParams(wfDefaultsRef));
                String matchPattern = (String)((Object)this.getNodeService().getProperty(wfDefaultsRef, WCMAppModel.PROP_FILENAMEPATTERN));
                if (matchPattern == null) continue;
                workflowMatchers.add(new FormWorkflowWrapper(wfName, params, matchPattern));
            }
            for (ItemWrapper wrapper : this.submitItems) {
                String path = wrapper.getPath();
                ArrayList matchers = new ArrayList(workflowMatchers);
                for (int i = 0; i < matchers.size(); ++i) {
                    FormWorkflowWrapper matcher = (FormWorkflowWrapper)matchers.get(i);
                    if (!matcher.matchesPath(path)) continue;
                    this.workflows.add(matcher);
                    workflowMatchers.remove(matcher);
                }
                if (workflowMatchers.size() != 0) continue;
                break;
            }
            ArrayList<UIListItem> items = new ArrayList<UIListItem>(this.workflows.size());
            for (FormWorkflowWrapper wrapper : this.workflows) {
                WorkflowDefinition workflowDef = this.getWorkflowService().getDefinitionByName(wrapper.name);
                UIListItem item = new UIListItem();
                item.setValue(workflowDef.getName());
                String label = workflowDef.getTitle();
                String desc = workflowDef.getDescription();
                if (desc != null && desc.length() > 0) {
                    label = label + "(" + desc + ")";
                }
                item.setLabel(label);
                items.add(item);
                if (this.workflowSelectedValue != null) continue;
                this.workflowSelectedValue = new String[]{workflowDef.getName()};
            }
            this.workflowItems = items;
        }
        return this.workflowItems;
    }

    public int getWorkflowListSize() {
        return this.getWorkflowList().size();
    }

    public List<ItemWrapper> getSubmitItems() {
        if (this.submitItems == null) {
            this.calcluateListItemsAndWorkflows();
        }
        return this.submitItems;
    }

    public int getSubmitItemsSize() {
        return this.getSubmitItems().size();
    }

    public List<ItemWrapper> getWarningItems() {
        if (this.warningItems == null) {
            this.calcluateListItemsAndWorkflows();
        }
        return this.warningItems;
    }

    public int getWarningItemsSize() {
        return this.getWarningItems().size();
    }

    private void calcluateListItemsAndWorkflows() {
        UserTransaction tx = null;
        try {
            List<AVMNodeDescriptor> selected;
            FacesContext context = FacesContext.getCurrentInstance();
            tx = Repository.getUserTransaction(context, true);
            tx.begin();
            if (this.loadSelectedNodesFromBrowseBean) {
                selected = this.avmBrowseBean.getNodesForSubmit();
                this.avmBrowseBean.setNodesForSubmit(null);
            } else if (this.avmBrowseBean.getAllItemsAction()) {
                String webapp = this.avmBrowseBean.getWebapp();
                String userStore = AVMUtil.buildStoreWebappPath(this.avmBrowseBean.getSandbox(), webapp);
                String stagingStore = AVMUtil.buildStoreWebappPath(this.avmBrowseBean.getStagingStore(), webapp);
                List diffs = this.getAvmSyncService().compare(-1, userStore, -1, stagingStore, this.getNameMatcher());
                selected = new ArrayList<AVMNodeDescriptor>(diffs.size());
                for (AVMDifference diff : diffs) {
                    selected.add(this.getAvmService().lookup(-1, diff.getSourcePath(), true));
                }
            } else if (this.avmBrowseBean.getAvmActionNode() == null) {
                selected = this.avmBrowseBean.getSelectedSandboxItems();
            } else {
                selected = new ArrayList<AVMNodeDescriptor>(1);
                selected.add(this.getAvmService().lookup(-1, this.avmBrowseBean.getAvmActionNode().getPath(), true));
            }
            if (selected == null) {
                this.submitItems = Collections.emptyList();
                this.warningItems = Collections.emptyList();
            } else {
                HashSet<String> submittedPaths = new HashSet<String>(selected.size());
                this.submitItems = new ArrayList<ItemWrapper>(selected.size());
                this.warningItems = new ArrayList<ItemWrapper>(selected.size() >> 1);
                for (AVMNodeDescriptor node : selected) {
                    if (AVMWorkflowUtil.isInActiveWorkflow(AVMUtil.getStoreName(node.getPath()), node)) {
                        this.warningItems.add(new ItemWrapper(node));
                        continue;
                    }
                    NodeRef ref = AVMNodeConverter.ToNodeRef((int)-1, (String)node.getPath());
                    if (submittedPaths.contains(node.getPath())) continue;
                    boolean isForm = this.getNodeService().hasAspect(ref, WCMAppModel.ASPECT_FORM_INSTANCE_DATA);
                    boolean isRendition = this.getNodeService().hasAspect(ref, WCMAppModel.ASPECT_RENDITION);
                    if (!isForm && !isRendition || node.isDeleted() && !isForm) {
                        this.submitItems.add(new ItemWrapper(node));
                        submittedPaths.add(node.getPath());
                        continue;
                    }
                    FormInstanceData fid = null;
                    try {
                        fid = isRendition ? this.getFormsService().getRendition(ref).getPrimaryFormInstanceData(true) : this.getFormsService().getFormInstanceData(ref);
                    }
                    catch (FormNotFoundException fnfe) {
                        logger.warn((Object)fnfe);
                    }
                    if (fid != null) {
                        if (!submittedPaths.contains(fid.getPath())) {
                            this.submitItems.add(new ItemWrapper(this.getAvmService().lookup(-1, fid.getPath(), true)));
                            submittedPaths.add(fid.getPath());
                        }
                        for (Rendition rendition : fid.getRenditions(true)) {
                            String renditionPath = rendition.getPath();
                            if (submittedPaths.contains(renditionPath)) continue;
                            this.submitItems.add(new ItemWrapper(this.getAvmService().lookup(-1, renditionPath, true)));
                            submittedPaths.add(renditionPath);
                        }
                        Form f = null;
                        try {
                            f = fid.getForm();
                            WorkflowDefinition defaultWfDef = f.getDefaultWorkflow();
                            if (defaultWfDef != null) {
                                this.workflows.add(new FormWorkflowWrapper(defaultWfDef.getName(), fid.getForm().getDefaultWorkflowParameters()));
                            }
                        }
                        catch (FormNotFoundException fnfe) {
                            logger.warn((Object)fnfe);
                        }
                    }
                    if (submittedPaths.contains(node.getPath())) continue;
                    this.submitItems.add(new ItemWrapper(node));
                    submittedPaths.add(node.getPath());
                }
            }
            tx.commit();
        }
        catch (Throwable e) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw (RuntimeException)e;
        }
    }

    public void setupConfigureWorkflow(ActionEvent event) {
        if (this.workflowSelectedValue != null) {
            String workflowName = this.workflowSelectedValue[0];
            for (WorkflowConfiguration workflowConfiguration : this.workflows) {
                if (!workflowConfiguration.getName().equals(workflowName)) continue;
                this.setActionWorkflow(workflowConfiguration);
            }
        }
    }

    public WorkflowConfiguration getActionWorkflow() {
        return this.actionWorkflow;
    }

    public void setActionWorkflow(WorkflowConfiguration actionWorkflow) {
        this.actionWorkflow = actionWorkflow;
    }

    public void applyDefaultExpireDateToAll(ActionEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("applying default expiration date of " + this.defaultExpireDate + " to all modified items"));
        }
        List<ItemWrapper> items = this.getSubmitItems();
        for (ItemWrapper item : items) {
            if (item.descriptor.getType() != 0) continue;
            this.expirationDates.put(item.descriptor.getPath(), this.defaultExpireDate);
        }
        this.enteringExpireDate = false;
    }

    public void enterExpireDate(ActionEvent event) {
        this.enteringExpireDate = true;
    }

    public class ItemWrapper
    implements Serializable {
        private static final long serialVersionUID = 6079164681664703986L;
        private static final String rootPath = "/avm_webapps";
        private AVMNodeDescriptor descriptor;

        public ItemWrapper(AVMNodeDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public boolean getFile() {
            return this.descriptor.isFile();
        }

        public boolean getExpirable() {
            return this.descriptor.isFile() && !this.descriptor.isDeleted();
        }

        public boolean getDeleted() {
            return this.descriptor.isDeleted();
        }

        public String getName() {
            String result = this.descriptor.getName();
            if (this.descriptor.isDeleted()) {
                result = result + " [" + Application.getMessage(FacesContext.getCurrentInstance(), SubmitDialog.MSG_DELETED_ITEM) + "]";
            }
            return result;
        }

        public String getModifiedDate() {
            return ISO8601DateFormat.format((Date)new Date(this.descriptor.getModDate()));
        }

        public String getExpirationDate() {
            String expireDate = null;
            Date date = (Date)SubmitDialog.this.expirationDates.get(this.descriptor.getPath());
            if (date != null) {
                expireDate = ISO8601DateFormat.format((Date)date);
            }
            return expireDate;
        }

        public String getDescription() {
            if (!this.descriptor.isDeleted()) {
                return (String)((Object)SubmitDialog.this.getNodeService().getProperty(AVMNodeConverter.ToNodeRef((int)-1, (String)this.descriptor.getPath()), ContentModel.PROP_DESCRIPTION));
            }
            return "";
        }

        public String getPath() {
            return this.descriptor.getPath().substring(this.descriptor.getPath().indexOf(rootPath) + rootPath.length());
        }

        public String getFullPath() {
            return this.descriptor.getPath();
        }

        public String getUrl() {
            return DownloadContentServlet.generateBrowserURL(AVMNodeConverter.ToNodeRef((int)-1, (String)this.descriptor.getPath()), this.descriptor.getName());
        }

        public String getPreviewUrl() {
            return AVMUtil.getPreviewURI(this.descriptor.getPath());
        }

        public AVMNodeDescriptor getDescriptor() {
            return this.descriptor;
        }

        public String getIcon() {
            return this.descriptor.isFile() || this.descriptor.isDeletedFile() ? FileTypeImageUtils.getFileTypeImage((String)this.descriptor.getName(), (boolean)true) : SubmitDialog.SPACE_ICON;
        }

        public boolean equals(Object obj) {
            return obj instanceof ItemWrapper && ((ItemWrapper)obj).descriptor.getPath().equals(this.descriptor.getPath());
        }

        public int hashCode() {
            return this.descriptor.getPath().hashCode();
        }
    }

    private static class FormWorkflowWrapper
    implements WorkflowConfiguration {
        private static final long serialVersionUID = -6264439015998987731L;
        private String name;
        private Map<QName, Serializable> params;
        private QName type;
        private String strFilenamePattern;
        private Pattern filenamePattern;

        FormWorkflowWrapper(String name, Map<QName, Serializable> params) {
            this.name = name;
            this.params = params;
        }

        FormWorkflowWrapper(String name, Map<QName, Serializable> params, String filenamePattern) {
            this.name = name;
            this.params = params;
            this.setFilenamePattern(filenamePattern);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getFilenamePattern() {
            return this.strFilenamePattern;
        }

        @Override
        public void setFilenamePattern(String pattern) {
            if (pattern != null) {
                this.strFilenamePattern = pattern;
                this.filenamePattern = Pattern.compile(pattern);
            }
        }

        @Override
        public Map<QName, Serializable> getParams() {
            return this.params;
        }

        @Override
        public void setParams(Map<QName, Serializable> params) {
            this.params = params;
        }

        @Override
        public QName getType() {
            return this.type;
        }

        @Override
        public void setType(QName type) {
            this.type = type;
        }

        boolean matchesPath(String path) {
            return this.filenamePattern != null && this.filenamePattern.matcher(path).matches();
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof FormWorkflowWrapper && this.name.equals(((FormWorkflowWrapper)obj).name);
        }
    }
}

