/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.util.Collections;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.wcm.util.WCMUtil;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMNode;
import org.alfresco.web.bean.wcm.BasePermissionsDialog;

public class UpdatePermissionsDialog
extends BasePermissionsDialog {
    private static final long serialVersionUID = 7189321059584956816L;
    private transient AVMLockingService avmLockingService;
    private transient AuthenticationService authenticationService;
    private AVMNode activeNode;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
    }

    public void setAvmLockingService(AVMLockingService avmLockingService) {
        this.avmLockingService = avmLockingService;
    }

    protected AVMLockingService getAvmLockingService() {
        if (this.avmLockingService == null) {
            this.avmLockingService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMLockingService();
        }
        return this.avmLockingService;
    }

    protected void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected AuthenticationService getAuthenticationService() {
        if (this.authenticationService == null) {
            this.authenticationService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAuthenticationService();
        }
        return this.authenticationService;
    }

    protected void createLock(AVMNode node) {
        String avmPath = node.getPath();
        String webProject = WCMUtil.getWebapp((String)avmPath);
        String avmStore = WCMUtil.getStoreName((String)avmPath);
        String relativePath = WCMUtil.getStoreRelativePath((String)avmPath);
        if (this.getAvmLockingService().getLockOwner(webProject, relativePath) == null && !node.isDirectory()) {
            String userName = this.getAuthenticationService().getCurrentUserName();
            Map<String, String> lockAttributes = Collections.singletonMap("avm-store-name", avmStore);
            this.getAvmLockingService().lock(webProject, relativePath, userName, lockAttributes);
        }
    }

    public AVMNode getActiveNode() {
        return this.activeNode;
    }

    public void setActiveNode(AVMNode activeNode) {
        this.activeNode = activeNode;
    }
}

