/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.UIModeList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ViewDeploymentReportDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -8054466371051782132L;
    protected String store;
    protected NodeRef attempt;
    protected String attemptDate;
    protected boolean panelExpanded = false;
    protected String dateFilter = "week";
    private static final Log logger = LogFactory.getLog(ViewDeploymentReportDialog.class);

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.store = parameters.get("store");
        this.dateFilter = "week";
        this.panelExpanded = false;
        this.attempt = null;
        this.attemptDate = null;
        if (this.store == null || this.store.length() == 0) {
            throw new IllegalArgumentException("store parameter is mandatory");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Initialising dialog to view deployment report for: " + this.store));
        }
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "close");
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return outcome;
    }

    @Override
    public String getContainerDescription() {
        String desc = null;
        desc = this.attempt == null ? Application.getMessage(FacesContext.getCurrentInstance(), "deployment_report_desc") : Application.getMessage(FacesContext.getCurrentInstance(), "deployment_previous_report_desc");
        return desc;
    }

    @Override
    public String getContainerTitle() {
        String title = null;
        if (this.attempt == null) {
            title = Application.getMessage(FacesContext.getCurrentInstance(), "deployment_report_title");
        } else {
            String pattern = Application.getMessage(FacesContext.getCurrentInstance(), "deployment_previous_report_title");
            title = MessageFormat.format(pattern, this.attemptDate);
        }
        return title;
    }

    public void dateFilterChanged(ActionEvent event) {
        UIModeList filterComponent = (UIModeList)event.getComponent();
        this.setDateFilter(filterComponent.getValue().toString());
    }

    public void attemptSelected(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String attempt = params.get("attemptRef");
        if (attempt != null && attempt.length() != 0) {
            this.attemptDate = params.get("attemptDate");
            this.attempt = new NodeRef(attempt);
        }
    }

    public void panelToggled(ActionEvent event) {
        this.panelExpanded = !this.panelExpanded;
    }

    public void showLastReport(ActionEvent event) {
        this.attempt = null;
        this.attemptDate = null;
        this.panelExpanded = false;
    }

    public String getStore() {
        return this.store;
    }

    public String getDateFilter() {
        return this.dateFilter;
    }

    public void setDateFilter(String dateFilter) {
        this.dateFilter = dateFilter;
    }

    public NodeRef getAttempt() {
        return this.attempt;
    }

    public boolean getPanelExpanded() {
        return this.panelExpanded;
    }
}

