/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wizard;

import javax.faces.context.FacesContext;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.wizard.IWizardBean;
import org.alfresco.web.ui.common.Utils;

public abstract class BaseWizardBean
extends BaseDialogBean
implements IWizardBean {
    private static final String MSG_NOT_SET = "value_not_set";

    @Override
    public String next() {
        if (this.isFinished()) {
            Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), "error_wizard_completed_already"));
        }
        return null;
    }

    @Override
    public String back() {
        if (this.isFinished()) {
            Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), "error_wizard_completed_already"));
        }
        return null;
    }

    @Override
    public boolean getNextButtonDisabled() {
        return false;
    }

    @Override
    public String getNextButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "next_button");
    }

    @Override
    public String getBackButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "back_button");
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "finish_button");
    }

    @Override
    public String getStepTitle() {
        return null;
    }

    @Override
    public String getStepDescription() {
        return null;
    }

    protected String buildSummary(String[] labels, String[] values) {
        if (labels == null || values == null || labels.length != values.length) {
            throw new IllegalArgumentException("Labels and Values passed to summary must be valid and of equal length.");
        }
        String msg = Application.getMessage(FacesContext.getCurrentInstance(), MSG_NOT_SET);
        String notSetMsg = "&lt;" + msg + "&gt;";
        StringBuilder buf = new StringBuilder(512);
        buf.append("<table cellspacing='4' cellpadding='2' border='0' class='summary'>");
        for (int i = 0; i < labels.length; ++i) {
            String value = values[i];
            buf.append("<tr><td valign='top'><b>");
            buf.append(labels[i]);
            buf.append(":</b></td><td>");
            buf.append(value != null ? value : notSetMsg);
            buf.append("</td></tr>");
        }
        buf.append("</table>");
        return buf.toString();
    }

    @Override
    protected String getDefaultCancelOutcome() {
        return "wizard:close";
    }

    @Override
    protected String getDefaultFinishOutcome() {
        return "wizard:close";
    }
}

