/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.workflow;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.transaction.UserTransaction;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.SortableSelectItem;
import org.alfresco.web.ui.common.Utils;

public abstract class BaseReassignDialog
extends BaseDialogBean {
    private static final long serialVersionUID = 3392941403282035753L;
    private static final String MSG_SEARCH_MINIMUM = "picker_search_min";
    private transient WorkflowService workflowService;
    private transient PersonService personService;

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected WorkflowService getWorkflowService() {
        if (this.workflowService == null) {
            this.workflowService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getWorkflowService();
        }
        return this.workflowService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPersonService();
        }
        return this.personService;
    }

    public SelectItem[] getFilters() {
        ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
        return new SelectItem[]{new SelectItem((Object)"0", bundle.getString("users"))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectItem[] pickerCallback(int filterIndex, String contains) {
        Object[] items;
        FacesContext context = FacesContext.getCurrentInstance();
        String search = contains.trim();
        int searchMin = Application.getClientConfig(context).getPickerSearchMinimum();
        if (search.length() < searchMin) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, MSG_SEARCH_MINIMUM), searchMin));
            return new SelectItem[0];
        }
        UserTransaction tx = null;
        Object resultSet = null;
        try {
            tx = Repository.getUserTransaction(context, true);
            tx.begin();
            int maxResults = Application.getClientConfig(context).getInviteUsersMaxResults();
            if (maxResults <= 0) {
                maxResults = Utils.getPersonMaxResults();
            }
            List persons = this.getPersonService().getPeople(Utils.generatePersonFilter(contains.trim()), true, Utils.generatePersonSort(), new PagingRequest(maxResults, null)).getPage();
            ArrayList<SortableSelectItem> itemList = new ArrayList<SortableSelectItem>(persons.size());
            for (PersonService.PersonInfo person : persons) {
                String username = person.getUserName();
                if (AuthenticationUtil.getGuestUserName().equals(username)) continue;
                String firstName = person.getFirstName();
                String lastName = person.getLastName();
                String name = (firstName != null ? firstName : "") + ' ' + (lastName != null ? lastName : "");
                SortableSelectItem item = new SortableSelectItem(username, name + " [" + username + "]", lastName != null ? lastName : username);
                itemList.add(item);
            }
            items = new SelectItem[itemList.size()];
            itemList.toArray(items);
            Arrays.sort(items);
            tx.commit();
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
            items = new SelectItem[]{};
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return items;
    }
}

