/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.workflow;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.transaction.UserTransaction;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.wcm.webproject.WebProjectService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.MapNode;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.NodePropertyResolver;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.TransientNode;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.bean.wcm.AVMNode;
import org.alfresco.web.bean.workflow.WorkflowUtil;
import org.alfresco.web.config.DialogsConfigElement;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.data.UIRichList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManageTaskDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -3209544870892993135L;
    private transient WorkflowService workflowService;
    private transient AVMService avmService;
    private transient AVMSyncService avmSyncService;
    private transient WebProjectService wpService;
    protected Node taskNode;
    private transient WorkflowTask task;
    private transient WorkflowInstance workflowInstance;
    private transient WorkflowTransition[] transitions;
    protected NodeRef workflowPackage;
    protected List<Node> resources;
    protected TaskCompleteResolver completeResolver = new TaskCompleteResolver();
    protected UIRichList packageItemsRichList;
    protected List<String> packageItemsToAdd;
    protected List<String> packageItemsToRemove;
    protected String[] itemsToAdd;
    protected boolean isItemBeingAdded = false;
    private static final Log LOGGER = LogFactory.getLog(ManageTaskDialog.class);
    protected static final String ID_PREFIX = "transition_";
    protected static final String CLIENT_ID_PREFIX = "dialog:transition_";

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.task = null;
        this.taskNode = null;
        this.workflowInstance = null;
        this.transitions = null;
        this.workflowPackage = null;
        this.resources = null;
        this.itemsToAdd = null;
        this.packageItemsToAdd = null;
        this.packageItemsToRemove = null;
        this.isItemBeingAdded = false;
        if (this.packageItemsRichList != null) {
            this.packageItemsRichList.setValue(null);
            this.packageItemsRichList = null;
        }
        String taskId = (String)this.parameters.get("id");
        this.task = this.getWorkflowService().getTaskById(taskId);
        if (this.task != null) {
            WorkflowTaskDefinition taskDef = this.task.definition;
            this.taskNode = new TransientNode(taskDef.metadata.getName(), "task_" + System.currentTimeMillis(), this.task.properties);
            this.workflowInstance = this.task.path.instance;
            this.workflowPackage = (NodeRef)this.task.properties.get(WorkflowModel.ASSOC_PACKAGE);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Task: " + this.task));
                LOGGER.debug((Object)("Trasient node: " + this.taskNode));
                Boolean isSystemPackage = (Boolean)this.getNodeService().getProperty(this.workflowPackage, WorkflowModel.PROP_IS_SYSTEM_PACKAGE);
                LOGGER.debug((Object)("Workflow package: " + this.workflowPackage + " system package: " + isSystemPackage));
                boolean isWCMWorkflow = this.workflowPackage.getStoreRef().getProtocol().equals("avm");
                LOGGER.debug((Object)("is wcm workflow: " + isWCMWorkflow));
            }
        }
    }

    @Override
    public void restored() {
        if (this.packageItemsRichList != null) {
            this.packageItemsRichList.setValue(null);
            this.packageItemsRichList = null;
        }
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        WorkflowTask checkTask;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Saving task: " + this.getWorkflowTask().id));
        }
        if ((checkTask = this.getWorkflowService().getTaskById(this.getWorkflowTask().id)) == null || checkTask.state == WorkflowTaskState.COMPLETED) {
            Utils.addErrorMessage(Application.getMessage(context, "invalid_task"));
            return outcome;
        }
        Map<QName, Serializable> params = WorkflowUtil.prepareTaskParams(this.taskNode);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Saving task with parameters: " + params));
        }
        this.updateResources();
        this.getWorkflowService().updateTask(this.getWorkflowTask().id, params, null, null);
        return outcome;
    }

    @Override
    public List<DialogsConfigElement.DialogButtonConfig> getAdditionalButtons() {
        ArrayList<DialogsConfigElement.DialogButtonConfig> buttons = null;
        if (this.getWorkflowTask() != null) {
            this.transitions = this.getWorkflowTask().path.node.transitions;
            boolean isPooledTask = this.isPooledTask();
            if (isPooledTask || this.transitions != null) {
                buttons = new ArrayList<DialogsConfigElement.DialogButtonConfig>(this.transitions.length + 1);
                if (isPooledTask) {
                    if (this.taskNode.getProperties().get(ContentModel.PROP_OWNER) == null) {
                        buttons.add(new DialogsConfigElement.DialogButtonConfig("button_take_ownership", null, "take_ownership", "#{DialogManager.bean.takeOwnership}", "false", null));
                    } else {
                        buttons.add(new DialogsConfigElement.DialogButtonConfig("button_return_to_pool", null, "return_ownership", "#{DialogManager.bean.returnOwnership}", "false", null));
                    }
                }
                if (this.transitions != null) {
                    Object hiddenTransitions = this.taskNode.getProperties().get(WorkflowModel.PROP_HIDDEN_TRANSITIONS);
                    for (WorkflowTransition trans : this.transitions) {
                        if (!(hiddenTransitions == null || hiddenTransitions instanceof String && ((String)hiddenTransitions).equals("") || hiddenTransitions instanceof String && !((String)hiddenTransitions).equals(trans.id)) && (!(hiddenTransitions instanceof List) || ((List)hiddenTransitions).contains(trans.id)) || this.taskNode.getProperties().get(ContentModel.PROP_OWNER) == null) continue;
                        buttons.add(new DialogsConfigElement.DialogButtonConfig(ID_PREFIX + trans.title, trans.title, null, "#{DialogManager.bean.transition}", "false", null));
                    }
                }
            }
        }
        return buttons;
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "save_changes");
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    @Override
    public String getContainerTitle() {
        String titleStart = Application.getMessage(FacesContext.getCurrentInstance(), "manage_task_title");
        return titleStart + ": " + this.getWorkflowTask().title;
    }

    @Override
    public String getContainerDescription() {
        return this.getWorkflowTask().description;
    }

    public String takeOwnership() {
        String outcome = this.getDefaultFinishOutcome();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Taking ownership of task: " + this.getWorkflowTask().id));
        }
        FacesContext context = FacesContext.getCurrentInstance();
        WorkflowTask checkTask = this.getWorkflowService().getTaskById(this.getWorkflowTask().id);
        if (checkTask == null || checkTask.state == WorkflowTaskState.COMPLETED) {
            Utils.addErrorMessage(Application.getMessage(context, "invalid_task"));
            return outcome;
        }
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(context);
            tx.begin();
            User user = Application.getCurrentUser(context);
            String userName = user.getUserName();
            HashMap<QName, String> params = new HashMap<QName, String>();
            params.put(ContentModel.PROP_OWNER, userName);
            this.updateResources();
            this.getWorkflowService().updateTask(this.getWorkflowTask().id, params, null, null);
            tx.commit();
        }
        catch (Throwable e) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            Utils.addErrorMessage(this.formatErrorMessage(e), e);
            outcome = this.getErrorOutcome(e);
        }
        return outcome;
    }

    public String returnOwnership() {
        String outcome = this.getDefaultFinishOutcome();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Returning ownership of task to pool: " + this.getWorkflowTask().id));
        }
        FacesContext context = FacesContext.getCurrentInstance();
        WorkflowTask checkTask = this.getWorkflowService().getTaskById(this.getWorkflowTask().id);
        if (checkTask == null || checkTask.state == WorkflowTaskState.COMPLETED) {
            Utils.addErrorMessage(Application.getMessage(context, "invalid_task"));
            return outcome;
        }
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(context);
            tx.begin();
            HashMap<QName, Object> params = new HashMap<QName, Object>();
            params.put(ContentModel.PROP_OWNER, null);
            this.updateResources();
            this.getWorkflowService().updateTask(this.getWorkflowTask().id, params, null, null);
            tx.commit();
        }
        catch (Throwable e) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            Utils.addErrorMessage(this.formatErrorMessage(e), e);
            outcome = this.getErrorOutcome(e);
        }
        return outcome;
    }

    public String transition() {
        String outcome = this.getDefaultFinishOutcome();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Transitioning task: " + this.getWorkflowTask().id));
        }
        FacesContext context = FacesContext.getCurrentInstance();
        WorkflowTask checkTask = this.getWorkflowService().getTaskById(this.getWorkflowTask().id);
        if (checkTask == null || checkTask.state == WorkflowTaskState.COMPLETED) {
            Utils.addErrorMessage(Application.getMessage(context, "invalid_task"));
            return outcome;
        }
        Map reqParams = context.getExternalContext().getRequestParameterMap();
        String selectedTransition = null;
        for (WorkflowTransition trans : this.getWorkflowTransitions()) {
            Object result = reqParams.get(CLIENT_ID_PREFIX + FacesHelper.makeLegalId(trans.title));
            if (result == null) continue;
            selectedTransition = trans.id;
            break;
        }
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(context);
            tx.begin();
            Map<QName, Serializable> params = WorkflowUtil.prepareTaskParams(this.taskNode);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Transitioning task with parameters: " + params));
            }
            this.updateResources();
            this.getWorkflowService().updateTask(this.getWorkflowTask().id, params, null, null);
            this.getWorkflowService().endTask(this.getWorkflowTask().id, selectedTransition);
            tx.commit();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Ended task with transition: " + selectedTransition));
            }
        }
        catch (Throwable e) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            Utils.addErrorMessage(this.formatErrorMessage(e), e);
            outcome = this.getErrorOutcome(e);
        }
        return outcome;
    }

    public void prepareForAdd(ActionEvent event) {
        this.isItemBeingAdded = true;
    }

    public void cancelAddPackageItems(ActionEvent event) {
        this.isItemBeingAdded = false;
    }

    public void addPackageItems(ActionEvent event) {
        if (this.itemsToAdd != null) {
            if (this.packageItemsToAdd == null) {
                this.packageItemsToAdd = new ArrayList<String>(this.itemsToAdd.length);
            }
            for (String item : this.itemsToAdd) {
                if (this.packageItemsToRemove != null && this.packageItemsToRemove.contains(item)) {
                    this.packageItemsToRemove.remove(item);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)("Removed item from the removed list: " + item));
                    continue;
                }
                this.packageItemsToAdd.add(item);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("Added item to the added list: " + item));
            }
            this.packageItemsRichList.setValue(null);
        }
        this.isItemBeingAdded = false;
        this.itemsToAdd = null;
    }

    public void removePackageItem(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String nodeRef = new NodeRef(Repository.getStoreRef(), params.get("id")).toString();
        if (this.packageItemsToAdd != null && this.packageItemsToAdd.contains(nodeRef)) {
            this.packageItemsToAdd.remove(nodeRef);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Removed item from the added list: " + nodeRef));
            }
        } else {
            if (this.packageItemsToRemove == null) {
                this.packageItemsToRemove = new ArrayList<String>(1);
            }
            this.packageItemsToRemove.add(nodeRef);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Added item to the removed list: " + nodeRef));
            }
        }
        this.packageItemsRichList.setValue(null);
    }

    public void togglePackageItemComplete(ActionEvent event) {
    }

    public String[] getItemsToAdd() {
        return this.itemsToAdd;
    }

    public void setItemsToAdd(String[] itemsToAdd) {
        this.itemsToAdd = itemsToAdd;
    }

    public boolean isItemBeingAdded() {
        return this.isItemBeingAdded;
    }

    public void setPackageItemsRichList(UIRichList richList) {
        this.packageItemsRichList = richList;
    }

    public UIRichList getPackageItemsRichList() {
        return this.packageItemsRichList;
    }

    public Node getTaskNode() {
        return this.taskNode;
    }

    public boolean isPooledTask() {
        List pooledActors = (List)this.taskNode.getAssociations().get(WorkflowModel.ASSOC_POOLED_ACTORS);
        return pooledActors != null && pooledActors.size() > 0;
    }

    public WorkflowInstance getWorkflowInstance() {
        if (this.workflowInstance == null) {
            this.workflowInstance = this.getWorkflowTask().path.instance;
        }
        return this.workflowInstance;
    }

    public String getWorkflowDefinitionImageUrl() {
        return "/workflowdefinitionimage/" + this.getWorkflowInstance().definition.id;
    }

    public String getPackageActionGroup() {
        return (String)this.getWorkflowTask().properties.get(WorkflowModel.PROP_PACKAGE_ACTION_GROUP);
    }

    public String getPackageItemActionGroup() {
        return (String)this.getWorkflowTask().properties.get(WorkflowModel.PROP_PACKAGE_ITEM_ACTION_GROUP);
    }

    public List<Node> getResources() {
        this.resources = new ArrayList<Node>(4);
        if (this.workflowPackage != null) {
            UserTransaction tx = null;
            try {
                FacesContext context = FacesContext.getCurrentInstance();
                tx = Repository.getUserTransaction(context, true);
                tx.begin();
                List contents = this.workflowService.getPackageContents(this.getWorkflowTask().id);
                for (NodeRef nodeRef : contents) {
                    if (nodeRef.getStoreRef().getProtocol().equals("avm")) {
                        Pair vp = AVMNodeConverter.ToAVMVersionPath((NodeRef)nodeRef);
                        this.addAVMNode(new AVMNode(this.getAvmService().lookup(((Integer)vp.getFirst()).intValue(), (String)vp.getSecond(), true)));
                        continue;
                    }
                    if (!this.getNodeService().exists(nodeRef)) continue;
                    QName type = this.getNodeService().getType(nodeRef);
                    if (this.getDictionaryService().getType(type) == null || !this.getDictionaryService().isSubClass(type, ContentModel.TYPE_CONTENT) && !ApplicationModel.TYPE_FILELINK.equals((Object)type) || this.packageItemsToRemove != null && this.packageItemsToRemove.contains(nodeRef.toString())) continue;
                    this.createAndAddNode(nodeRef);
                }
                if (this.packageItemsToAdd != null) {
                    for (String newItem : this.packageItemsToAdd) {
                        NodeRef nodeRef = new NodeRef(newItem);
                        if (this.getNodeService().exists(nodeRef)) {
                            this.createAndAddNode(nodeRef);
                            continue;
                        }
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug((Object)("Ignoring " + nodeRef + " as it has been removed from the repository"));
                    }
                }
                tx.commit();
            }
            catch (Throwable err) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
                this.resources = Collections.emptyList();
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception exception) {}
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Failed to find workflow package for task: " + this.getWorkflowTask().id));
        }
        return this.resources;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected WorkflowService getWorkflowService() {
        if (this.workflowService == null) {
            this.workflowService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getWorkflowService();
        }
        return this.workflowService;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    protected AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
        }
        return this.avmService;
    }

    public void setAvmSyncService(AVMSyncService avmSyncService) {
        this.avmSyncService = avmSyncService;
    }

    protected AVMSyncService getAvmSyncService() {
        if (this.avmSyncService == null) {
            this.avmSyncService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMSyncService();
        }
        return this.avmSyncService;
    }

    public void setWebProjectService(WebProjectService wpService) {
        this.wpService = wpService;
    }

    protected WebProjectService getWebProjectService() {
        if (this.wpService == null) {
            this.wpService = (WebProjectService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "WebProjectService");
        }
        return this.wpService;
    }

    protected WorkflowTask getWorkflowTask() {
        if (this.task == null) {
            String taskId = (String)this.parameters.get("id");
            this.task = this.getWorkflowService().getTaskById(taskId);
        }
        return this.task;
    }

    protected WorkflowTransition[] getWorkflowTransitions() {
        if (this.transitions == null) {
            this.transitions = this.getWorkflowTask().path.node.transitions;
        }
        return this.transitions;
    }

    protected void addAVMNode(AVMNode node) {
        node.getProperties().put("taskId", this.getWorkflowTask().id);
        node.addPropertyResolver("path", AVMNode.RESOLVER_SANDBOX_RELATIVE_PATH);
        node.addPropertyResolver("previewUrl", AVMNode.RESOLVER_PREVIEW_URL);
        node.addPropertyResolver("fileType16", AVMNode.RESOLVER_FILE_TYPE_16);
        node.addPropertyResolver("size", this.browseBean.resolverSize);
        if (!node.isDirectory()) {
            node.addPropertyResolver("url", this.browseBean.resolverUrl);
        }
        this.resources.add(node);
        if (node.isDirectory() && !node.getDescriptor().isDeleted()) {
            for (AVMNodeDescriptor d : this.getAvmService().getDirectoryListingArray(node.getDescriptor(), true)) {
                this.addAVMNode(new AVMNode(d));
            }
        }
    }

    protected void createAndAddNode(NodeRef nodeRef) {
        MapNode node = new MapNode(nodeRef, this.getNodeService(), true);
        this.browseBean.setupCommonBindingProperties(node);
        node.addPropertyResolver("path", this.browseBean.resolverPath);
        node.addPropertyResolver("displayPath", this.browseBean.resolverDisplayPath);
        node.getProperties().put("taskId", this.getWorkflowTask().id);
        this.resources.add(node);
    }

    protected void updateResources() {
        if (this.workflowPackage != null && this.packageItemsToRemove != null && this.packageItemsToRemove.size() > 0) {
            for (String removedItem : this.packageItemsToRemove) {
                this.getNodeService().removeChild(this.workflowPackage, new NodeRef(removedItem));
            }
        }
        if (this.workflowPackage != null && this.packageItemsToAdd != null && this.packageItemsToAdd.size() > 0) {
            for (String addedItem : this.packageItemsToAdd) {
                NodeRef addedNodeRef = new NodeRef(addedItem);
                this.getNodeService().addChild(this.workflowPackage, addedNodeRef, WorkflowModel.ASSOC_PACKAGE_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)((String)((Object)this.getNodeService().getProperty(addedNodeRef, ContentModel.PROP_NAME))))));
            }
        }
    }

    protected class TaskCompleteResolver
    implements NodePropertyResolver {
        private static final long serialVersionUID = 5862037943275638314L;

        protected TaskCompleteResolver() {
        }

        @Override
        public Object get(Node node) {
            String result = Application.getMessage(FacesContext.getCurrentInstance(), "no");
            List completedItems = (List)ManageTaskDialog.this.getWorkflowTask().properties.get(WorkflowModel.PROP_COMPLETED_ITEMS);
            if (completedItems != null && completedItems.size() > 0 && completedItems.contains(node.getNodeRef())) {
                result = Application.getMessage(FacesContext.getCurrentInstance(), "yes");
            }
            return result;
        }
    }
}

