/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.workflow;

import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.bean.workflow.BaseReassignDialog;
import org.alfresco.web.ui.common.component.UIGenericPicker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReassignWorkItemDialog
extends BaseReassignDialog {
    private static final long serialVersionUID = 6501900045849920148L;
    protected String workItemId;
    private static final Log logger = LogFactory.getLog(ReassignWorkItemDialog.class);

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.workItemId = (String)this.parameters.get("workitem-id");
        if (this.workItemId == null || this.workItemId.length() == 0) {
            throw new IllegalArgumentException("Reassign workitem dialog called without task id");
        }
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        UIComponent picker;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reassigning work item with id: " + this.workItemId));
        }
        if ((picker = context.getViewRoot().findComponent("dialog:dialog-body:user-picker")) != null && picker instanceof UIGenericPicker) {
            UIGenericPicker userPicker = (UIGenericPicker)picker;
            String[] user = userPicker.getSelectedResults();
            if (user != null && user.length > 0) {
                String userName = user[0];
                HashMap<QName, String> params = new HashMap<QName, String>(1);
                params.put(ContentModel.PROP_OWNER, userName);
                this.getWorkflowService().updateTask(this.workItemId, params, null, null);
            } else if (logger.isWarnEnabled()) {
                logger.warn((Object)"Failed to find selected user, reassign was unsuccessful");
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)"Failed to find user-picker component, reassign was unsuccessful");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reassigning work item with id: " + this.workItemId));
        }
        return outcome;
    }

    @Override
    protected String getErrorMessageId() {
        return "error_reassign_workitem";
    }
}

