/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.workflow;

import java.io.Serializable;
import javax.faces.context.FacesContext;
import org.alfresco.repo.workflow.WorkflowInterpreter;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.web.app.servlet.FacesHelper;

public class WorkflowConsoleBean
implements Serializable {
    private static final long serialVersionUID = -7531838393180855185L;
    private String command = "";
    private String submittedCommand = "none";
    private long duration = 0L;
    private String result = null;
    private transient WorkflowInterpreter workflowInterpreter;

    public void setWorkflowInterpreter(WorkflowInterpreter workflowInterpreter) {
        this.workflowInterpreter = workflowInterpreter;
    }

    private WorkflowInterpreter getWorkflowInterpreter() {
        if (this.workflowInterpreter == null) {
            this.workflowInterpreter = (WorkflowInterpreter)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "workflowInterpreter");
        }
        return this.workflowInterpreter;
    }

    public String getResult() {
        if (this.result == null) {
            this.interpretCommand("help");
        }
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getSubmittedCommand() {
        return this.submittedCommand;
    }

    public void setSubmittedCommand(String submittedCommand) {
        this.submittedCommand = submittedCommand;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String submitCommand() {
        this.interpretCommand(this.command);
        return "success";
    }

    public String getCurrentUserName() {
        return this.getWorkflowInterpreter().getCurrentUserName();
    }

    public String getCurrentWorkflowDef() {
        WorkflowDefinition def = this.getWorkflowInterpreter().getCurrentWorkflowDef();
        return def == null ? "None" : def.title + " v" + def.version;
    }

    private void interpretCommand(String command) {
        try {
            long startms = System.currentTimeMillis();
            String result = this.getWorkflowInterpreter().interpretCommand(command);
            this.setDuration(System.currentTimeMillis() - startms);
            this.setResult(result);
            this.setCommand("");
            this.setSubmittedCommand(command);
        }
        catch (Exception e) {
            this.setResult(e.toString());
        }
    }
}

