/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.workflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkflowUtil {
    private static Log logger = LogFactory.getLog(WorkflowUtil.class);

    public static void approve(final NodeRef ref, final NodeService nodeService, CopyService copyService) throws AlfrescoRuntimeException {
        Node docNode = new Node(ref);
        if (!docNode.hasAspect(ApplicationModel.ASPECT_SIMPLE_WORKFLOW)) {
            throw new AlfrescoRuntimeException("Cannot approve a node that is not part of a workflow.");
        }
        Map<String, Object> props = docNode.getProperties();
        Boolean approveMove = (Boolean)props.get(ApplicationModel.PROP_APPROVE_MOVE.toString());
        NodeRef approveFolder = (NodeRef)props.get(ApplicationModel.PROP_APPROVE_FOLDER.toString());
        if (approveMove.booleanValue()) {
            nodeService.removeAspect(ref, ApplicationModel.ASPECT_SIMPLE_WORKFLOW);
            String qname = QName.createValidLocalName((String)docNode.getName());
            nodeService.moveNode(ref, approveFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)qname));
        } else {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public String doWork() throws Exception {
                    nodeService.removeAspect(ref, ApplicationModel.ASPECT_SIMPLE_WORKFLOW);
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            String name = docNode.getName();
            String qname = QName.createValidLocalName((String)name);
            NodeRef newNode = copyService.copy(ref, approveFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)qname), true);
            nodeService.setProperty(newNode, ContentModel.PROP_NAME, (Serializable)((Object)name));
        }
        if (logger.isDebugEnabled()) {
            String movedCopied = approveMove != false ? "moved" : "copied";
            logger.debug((Object)("Node has been approved and " + movedCopied + " to folder with id of " + approveFolder.getId()));
        }
    }

    public static void reject(NodeRef ref, NodeService nodeService, CopyService copyService) throws AlfrescoRuntimeException {
        Node docNode = new Node(ref);
        if (!docNode.hasAspect(ApplicationModel.ASPECT_SIMPLE_WORKFLOW)) {
            throw new AlfrescoRuntimeException("Cannot reject a node that is not part of a workflow.");
        }
        Map<String, Object> props = docNode.getProperties();
        String rejectStep = (String)props.get(ApplicationModel.PROP_REJECT_STEP.toString());
        Boolean rejectMove = (Boolean)props.get(ApplicationModel.PROP_REJECT_MOVE.toString());
        NodeRef rejectFolder = (NodeRef)props.get(ApplicationModel.PROP_REJECT_FOLDER.toString());
        if (rejectStep == null && rejectMove == null && rejectFolder == null) {
            throw new AlfrescoRuntimeException("The workflow does not have a reject step defined.");
        }
        nodeService.removeAspect(ref, ApplicationModel.ASPECT_SIMPLE_WORKFLOW);
        if (rejectMove != null && rejectMove.booleanValue()) {
            String qname = QName.createValidLocalName((String)docNode.getName());
            nodeService.moveNode(ref, rejectFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)qname));
        } else {
            String name = docNode.getName();
            String qname = QName.createValidLocalName((String)name);
            NodeRef newNode = copyService.copy(ref, rejectFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)qname), true);
            nodeService.setProperty(newNode, ContentModel.PROP_NAME, (Serializable)((Object)name));
        }
        if (logger.isDebugEnabled()) {
            String movedCopied = rejectMove != false ? "moved" : "copied";
            logger.debug((Object)("Node has been rejected and " + movedCopied + " to folder with id of " + rejectFolder.getId()));
        }
    }

    public static Map<QName, Serializable> prepareTaskParams(Node node) {
        QName assocQName;
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        Map<String, Object> props = node.getProperties();
        for (String propName : props.keySet()) {
            QName propQName = Repository.resolveToQName(propName);
            params.put(propQName, (Serializable)props.get(propName));
        }
        Map<String, Map<String, AssociationRef>> assocs = node.getAddedAssociations();
        for (String assocName : assocs.keySet()) {
            assocQName = Repository.resolveToQName(assocName);
            Map<String, AssociationRef> addedAssocs = assocs.get(assocName);
            List originalAssocRefs = (List)node.getAssociations().get(assocName);
            ArrayList<NodeRef> targets = new ArrayList<NodeRef>(addedAssocs.size());
            if (originalAssocRefs != null) {
                for (AssociationRef assoc : originalAssocRefs) {
                    targets.add(assoc.getTargetRef());
                }
            }
            for (AssociationRef assoc : addedAssocs.values()) {
                targets.add(assoc.getTargetRef());
            }
            params.put(assocQName, targets);
        }
        assocs = node.getRemovedAssociations();
        for (String assocName : assocs.keySet()) {
            assocQName = Repository.resolveToQName(assocName);
            Map<String, AssociationRef> removedAssocs = assocs.get(assocName);
            ArrayList<NodeRef> targets = (ArrayList<NodeRef>)params.get(assocQName);
            if (targets == null) {
                List originalAssocRefs = (List)node.getAssociations().get(assocName);
                targets = new ArrayList<NodeRef>(originalAssocRefs.size());
                for (AssociationRef assoc : originalAssocRefs) {
                    targets.add(assoc.getTargetRef());
                }
            }
            for (AssociationRef assoc : removedAssocs.values()) {
                targets.remove(assoc.getTargetRef());
            }
            params.put(assocQName, targets);
        }
        Map<String, Map<String, ChildAssociationRef>> childAssocs = node.getAddedChildAssociations();
        if (childAssocs.size() > 0 && logger.isWarnEnabled()) {
            logger.warn((Object)"Child associations are present but are not supported for workflow tasks, ignoring...");
        }
        return params;
    }

    public static boolean isTaskEditable(String taskId, ServletContext sc) {
        if (taskId == null || taskId.isEmpty()) {
            return false;
        }
        ServiceRegistry serviceRegistry = Repository.getServiceRegistry(sc);
        String username = serviceRegistry.getAuthenticationService().getCurrentUserName();
        WorkflowService workflowService = serviceRegistry.getWorkflowService();
        WorkflowTask task = workflowService.getTaskById(taskId);
        return workflowService.isTaskEditable(task, username);
    }
}

