/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.action.ActionEvaluator;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.element.ConfigElementAdapter;

public class ActionsConfigElement
extends ConfigElementAdapter {
    public static final String CONFIG_ELEMENT_ID = "actions";
    private Map<String, ActionDefinition> actionDefs = new HashMap<String, ActionDefinition>(32, 1.0f);
    private Map<String, ActionGroup> actionGroups = new HashMap<String, ActionGroup>(16, 1.0f);

    public ActionsConfigElement() {
        super(CONFIG_ELEMENT_ID);
    }

    public ActionsConfigElement(String name) {
        super(name);
    }

    public List<ConfigElement> getChildren() {
        throw new ConfigException("Reading the Actions config via the generic interfaces is not supported");
    }

    public ConfigElement combine(ConfigElement configElement) {
        ActionsConfigElement newElement = (ActionsConfigElement)configElement;
        ActionsConfigElement combinedElement = new ActionsConfigElement();
        combinedElement.actionDefs.putAll(this.actionDefs);
        combinedElement.actionDefs.putAll(newElement.actionDefs);
        HashMap<String, ActionGroup> combinedActionGroups = new HashMap<String, ActionGroup>(this.actionGroups.size());
        try {
            for (ActionGroup group : this.actionGroups.values()) {
                combinedActionGroups.put(group.getId(), (ActionGroup)group.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new AlfrescoRuntimeException("clone() required on ActionGroup class.", (Throwable)e);
        }
        combinedElement.actionGroups = combinedActionGroups;
        for (ActionGroup newGroup : newElement.actionGroups.values()) {
            if (combinedElement.actionGroups.containsKey(newGroup.getId())) {
                ActionGroup combinedGroup = combinedElement.actionGroups.get(newGroup.getId());
                if (newGroup.ShowLink != combinedGroup.ShowLink) {
                    combinedGroup.ShowLink = newGroup.ShowLink;
                }
                if (newGroup.Style != null) {
                    combinedGroup.Style = newGroup.Style;
                }
                if (newGroup.StyleClass != null) {
                    combinedGroup.StyleClass = newGroup.StyleClass;
                }
                for (String actionRef : newGroup.getAllActions()) {
                    combinedGroup.addAction(actionRef);
                }
                for (String actionRef : newGroup.getHiddenActions()) {
                    combinedGroup.hideAction(actionRef);
                }
                continue;
            }
            combinedElement.actionGroups.put(newGroup.getId(), newGroup);
        }
        return combinedElement;
    }

    void addActionDefinition(ActionDefinition actionDef) {
        this.actionDefs.put(actionDef.getId(), actionDef);
    }

    public ActionDefinition getActionDefinition(String id) {
        return this.actionDefs.get(id);
    }

    void addActionGroup(ActionGroup group) {
        this.actionGroups.put(group.getId(), group);
    }

    public ActionGroup getActionGroup(String id) {
        return this.actionGroups.get(id);
    }

    public static class ActionGroup
    implements Iterable<String>,
    Cloneable {
        private String id;
        private Set<String> actions = new LinkedHashSet<String>(16, 1.0f);
        private Set<String> hiddenActions = new HashSet<String>(4, 1.0f);
        public boolean ShowLink;
        public String Style;
        public String StyleClass;

        public ActionGroup(String id) {
            if (id == null || id.length() == 0) {
                throw new IllegalArgumentException("ActionGroup ID is mandatory.");
            }
            this.id = id;
        }

        protected Object clone() throws CloneNotSupportedException {
            ActionGroup clone = new ActionGroup(this.id);
            clone.actions = (Set)((LinkedHashSet)this.actions).clone();
            clone.hiddenActions = (Set)((HashSet)this.hiddenActions).clone();
            clone.ShowLink = this.ShowLink;
            clone.Style = this.Style;
            clone.StyleClass = this.StyleClass;
            return clone;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public Iterator<String> iterator() {
            ArrayList<String> visibleActions = new ArrayList<String>(this.actions.size());
            for (String actionId : this.actions) {
                if (this.hiddenActions.contains(actionId)) continue;
                visibleActions.add(actionId);
            }
            visibleActions.trimToSize();
            return visibleActions.iterator();
        }

        void addAction(String actionId) {
            this.actions.add(actionId);
        }

        void hideAction(String actionId) {
            this.hiddenActions.add(actionId);
        }

        Set<String> getAllActions() {
            return this.actions;
        }

        Set<String> getHiddenActions() {
            return this.hiddenActions;
        }
    }

    public static class ActionDefinition {
        String id;
        private List<String> permissionAllow = null;
        private List<String> permissionDeny = null;
        private Map<String, String> params = null;
        public ActionEvaluator Evaluator = null;
        public String Label;
        public String LabelMsg;
        public String Tooltip;
        public String TooltipMsg;
        public boolean ShowLink = true;
        public String Style;
        public String StyleClass;
        public String Image;
        public String ActionListener;
        public String Action;
        public String Href;
        public String Target;
        public String Script;
        public String Onclick;

        public ActionDefinition(String id) {
            if (id == null || id.length() == 0) {
                throw new IllegalArgumentException("ActionDefinition ID is mandatory.");
            }
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void addAllowPermission(String permission) {
            if (this.permissionAllow == null) {
                this.permissionAllow = new ArrayList<String>(2);
            }
            this.permissionAllow.add(permission);
        }

        public void addDenyPermission(String permission) {
            if (this.permissionDeny == null) {
                this.permissionDeny = new ArrayList<String>(1);
            }
            this.permissionDeny.add(permission);
        }

        public List<String> getAllowPermissions() {
            return this.permissionAllow;
        }

        public List<String> getDenyPermissions() {
            return this.permissionDeny;
        }

        public void addParam(String name, String value) {
            if (this.params == null) {
                this.params = new HashMap<String, String>(1, 1.0f);
            }
            this.params.put(name, value);
        }

        public Map<String, String> getParams() {
            return this.params;
        }
    }
}

