/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.util.Iterator;
import org.alfresco.web.action.ActionEvaluator;
import org.alfresco.web.config.ActionsConfigElement;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

public class ActionsElementReader
implements ConfigElementReader {
    public static final String ELEMENT_ACTION = "action";
    public static final String ELEMENT_ACTIONGROUP = "action-group";
    public static final String ELEMENT_PERMISSIONS = "permissions";
    public static final String ELEMENT_PERMISSION = "permission";
    public static final String ELEMENT_EVALUATOR = "evaluator";
    public static final String ELEMENT_LABEL = "label";
    public static final String ELEMENT_LABELMSG = "label-id";
    public static final String ELEMENT_TOOLTIP = "tooltip";
    public static final String ELEMENT_TOOLTIPMSG = "tooltip-id";
    public static final String ELEMENT_SHOWLINK = "show-link";
    public static final String ELEMENT_STYLE = "style";
    public static final String ELEMENT_STYLECLASS = "style-class";
    public static final String ELEMENT_IMAGE = "image";
    public static final String ELEMENT_ACTIONLISTENER = "action-listener";
    public static final String ELEMENT_ONCLICK = "onclick";
    public static final String ELEMENT_HREF = "href";
    public static final String ELEMENT_TARGET = "target";
    public static final String ELEMENT_SCRIPT = "script";
    public static final String ELEMENT_PARAMS = "params";
    public static final String ELEMENT_PARAM = "param";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_IDREF = "idref";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_ALLOW = "allow";
    public static final String ATTRIBUTE_HIDE = "hide";

    public ConfigElement parse(Element element) {
        ActionsConfigElement configElement = new ActionsConfigElement();
        if (element != null) {
            if (!"actions".equals(element.getName())) {
                throw new ConfigException("ActionsElementReader can only parse config elements of type 'Actions'");
            }
            Iterator actionItr = element.elementIterator(ELEMENT_ACTION);
            while (actionItr.hasNext()) {
                Element actionElement = (Element)actionItr.next();
                ActionsConfigElement.ActionDefinition actionDef = this.parseActionDefinition(actionElement);
                configElement.addActionDefinition(actionDef);
            }
            Iterator actionGroupItr = element.elementIterator(ELEMENT_ACTIONGROUP);
            while (actionGroupItr.hasNext()) {
                Element groupElement = (Element)actionGroupItr.next();
                String groupId = groupElement.attributeValue(ATTRIBUTE_ID);
                if (groupId == null || groupId.length() == 0) {
                    throw new ConfigException("'action-group' config element specified without mandatory 'id' attribute.");
                }
                ActionsConfigElement.ActionGroup actionGroup = new ActionsConfigElement.ActionGroup(groupId);
                Iterator actionRefItr = groupElement.elementIterator(ELEMENT_ACTION);
                while (actionRefItr.hasNext()) {
                    Element actionRefElement = (Element)actionRefItr.next();
                    String idRef = actionRefElement.attributeValue(ATTRIBUTE_IDREF);
                    if (idRef == null || idRef.length() == 0) {
                        String id = actionRefElement.attributeValue(ATTRIBUTE_ID);
                        if (id == null || id.length() == 0) continue;
                        ActionsConfigElement.ActionDefinition def = this.parseActionDefinition(actionRefElement);
                        def.id = actionGroup.getId() + '_' + def.getId();
                        configElement.addActionDefinition(def);
                        actionGroup.addAction(def.getId());
                        continue;
                    }
                    String hide = actionRefElement.attributeValue(ATTRIBUTE_HIDE);
                    if (hide != null && Boolean.parseBoolean(hide)) {
                        actionGroup.hideAction(idRef);
                        continue;
                    }
                    actionGroup.addAction(idRef);
                }
                actionGroup.Style = groupElement.elementTextTrim(ELEMENT_STYLE);
                actionGroup.StyleClass = groupElement.elementTextTrim(ELEMENT_STYLECLASS);
                if (groupElement.element(ELEMENT_SHOWLINK) != null) {
                    actionGroup.ShowLink = Boolean.parseBoolean(groupElement.element(ELEMENT_SHOWLINK).getTextTrim());
                }
                configElement.addActionGroup(actionGroup);
            }
        }
        return configElement;
    }

    public ActionsConfigElement.ActionDefinition parseActionDefinition(Element actionElement) {
        Element paramsElement;
        Element evaluatorElement;
        String actionId = actionElement.attributeValue(ATTRIBUTE_ID);
        if (actionId == null || actionId.length() == 0) {
            throw new ConfigException("'action' config element specified without mandatory 'id' attribute.");
        }
        ActionsConfigElement.ActionDefinition actionDef = new ActionsConfigElement.ActionDefinition(actionId);
        Element permissionsElement = actionElement.element(ELEMENT_PERMISSIONS);
        if (permissionsElement != null) {
            Iterator permissionItr = permissionsElement.elementIterator(ELEMENT_PERMISSION);
            while (permissionItr.hasNext()) {
                Element permissionElement = (Element)permissionItr.next();
                boolean allow = true;
                if (permissionElement.attributeValue(ATTRIBUTE_ALLOW) != null) {
                    allow = Boolean.parseBoolean(permissionElement.attributeValue(ATTRIBUTE_ALLOW));
                }
                String permissionValue = permissionElement.getTextTrim();
                if (allow) {
                    actionDef.addAllowPermission(permissionValue);
                    continue;
                }
                actionDef.addDenyPermission(permissionValue);
            }
        }
        if ((evaluatorElement = actionElement.element(ELEMENT_EVALUATOR)) != null) {
            Object evaluator;
            String className = evaluatorElement.getTextTrim();
            try {
                Class<?> clazz = Class.forName(className);
                evaluator = clazz.newInstance();
            }
            catch (Throwable err) {
                throw new ConfigException("Unable to construct action '" + actionId + "' evaluator classname: " + className);
            }
            if (!(evaluator instanceof ActionEvaluator)) {
                throw new ConfigException("Action '" + actionId + "' evaluator class '" + className + "' does not implement ActionEvaluator interface.");
            }
            actionDef.Evaluator = (ActionEvaluator)evaluator;
        }
        if ((paramsElement = actionElement.element(ELEMENT_PARAMS)) != null) {
            Iterator paramsItr = paramsElement.elementIterator(ELEMENT_PARAM);
            while (paramsItr.hasNext()) {
                Element paramElement = (Element)paramsItr.next();
                String name = paramElement.attributeValue(ATTRIBUTE_NAME);
                if (name == null || name.length() == 0) {
                    throw new ConfigException("Action '" + actionId + "' param does not have mandatory 'name' attribute.");
                }
                String value = paramElement.getTextTrim();
                if (value == null || value.length() == 0) {
                    throw new ConfigException("Action '" + actionId + "' param '" + name + "'" + "' does not have a value.");
                }
                actionDef.addParam(name, value);
            }
        }
        actionDef.Label = actionElement.elementTextTrim(ELEMENT_LABEL);
        actionDef.LabelMsg = actionElement.elementTextTrim(ELEMENT_LABELMSG);
        actionDef.Tooltip = actionElement.elementTextTrim(ELEMENT_TOOLTIP);
        actionDef.TooltipMsg = actionElement.elementTextTrim(ELEMENT_TOOLTIPMSG);
        actionDef.Href = actionElement.elementTextTrim(ELEMENT_HREF);
        actionDef.Target = actionElement.elementTextTrim(ELEMENT_TARGET);
        actionDef.Script = actionElement.elementTextTrim(ELEMENT_SCRIPT);
        actionDef.Action = actionElement.elementTextTrim(ELEMENT_ACTION);
        actionDef.ActionListener = actionElement.elementTextTrim(ELEMENT_ACTIONLISTENER);
        actionDef.Onclick = actionElement.elementTextTrim(ELEMENT_ONCLICK);
        actionDef.Image = actionElement.elementTextTrim(ELEMENT_IMAGE);
        actionDef.Style = actionElement.elementTextTrim(ELEMENT_STYLE);
        actionDef.StyleClass = actionElement.elementTextTrim(ELEMENT_STYLECLASS);
        if (actionElement.element(ELEMENT_SHOWLINK) != null) {
            actionDef.ShowLink = Boolean.parseBoolean(actionElement.element(ELEMENT_SHOWLINK).getTextTrim());
        }
        return actionDef;
    }
}

