/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.element.ConfigElementAdapter;

public class CommandServletConfigElement
extends ConfigElementAdapter {
    public static final String CONFIG_ELEMENT_ID = "command-servlet";
    private Map<String, Class> commandProcessors = new HashMap<String, Class>(4, 1.0f);

    public CommandServletConfigElement() {
        super(CONFIG_ELEMENT_ID);
    }

    public CommandServletConfigElement(String name) {
        super(name);
    }

    public List<ConfigElement> getChildren() {
        throw new ConfigException("Reading the Command Servlet config via the generic interfaces is not supported");
    }

    public ConfigElement combine(ConfigElement configElement) {
        CommandServletConfigElement newElement = (CommandServletConfigElement)configElement;
        CommandServletConfigElement combinedElement = new CommandServletConfigElement();
        for (String name : this.commandProcessors.keySet()) {
            combinedElement.addCommandProcessor(name, this.commandProcessors.get(name));
        }
        for (String name : newElement.commandProcessors.keySet()) {
            combinedElement.addCommandProcessor(name, newElement.commandProcessors.get(name));
        }
        return combinedElement;
    }

    void addCommandProcessor(String name, String className) {
        try {
            Class<?> clazz = Class.forName(className);
            this.commandProcessors.put(name, clazz);
        }
        catch (Throwable err) {
            throw new ConfigException("Unable to load command proccessor class: " + className + " due to " + err.getMessage());
        }
    }

    private void addCommandProcessor(String name, Class clazz) {
        this.commandProcessors.put(name, clazz);
    }

    public Class getCommandProcessor(String name) {
        return this.commandProcessors.get(name);
    }
}

