/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.element.ConfigElementAdapter;

public class DashboardsConfigElement
extends ConfigElementAdapter {
    public static final String CONFIG_ELEMENT_ID = "dashboards";
    private Map<String, LayoutDefinition> layoutDefs = new LinkedHashMap<String, LayoutDefinition>(4, 1.0f);
    private Map<String, DashletDefinition> dashletDefs = new LinkedHashMap<String, DashletDefinition>(8, 1.0f);
    private List<String> defaultDashlets = null;
    private boolean allowGuestConfig = false;

    public DashboardsConfigElement() {
        super(CONFIG_ELEMENT_ID);
    }

    public DashboardsConfigElement(String name) {
        super(name);
    }

    public List<ConfigElement> getChildren() {
        throw new ConfigException("Reading the Dashboards config via the generic interfaces is not supported");
    }

    public ConfigElement combine(ConfigElement configElement) {
        DashboardsConfigElement newElement = (DashboardsConfigElement)configElement;
        DashboardsConfigElement combinedElement = new DashboardsConfigElement();
        combinedElement.dashletDefs.putAll(this.dashletDefs);
        combinedElement.dashletDefs.putAll(newElement.dashletDefs);
        combinedElement.layoutDefs.putAll(this.layoutDefs);
        combinedElement.layoutDefs.putAll(newElement.layoutDefs);
        if (newElement.allowGuestConfig != combinedElement.allowGuestConfig) {
            combinedElement.allowGuestConfig = newElement.allowGuestConfig;
        }
        if (newElement.defaultDashlets != null) {
            combinedElement.defaultDashlets = (List)((ArrayList)newElement.defaultDashlets).clone();
        } else if (this.defaultDashlets != null) {
            combinedElement.defaultDashlets = (List)((ArrayList)this.defaultDashlets).clone();
        }
        return combinedElement;
    }

    void setAllowGuestConfig(boolean allow) {
        this.allowGuestConfig = allow;
    }

    public boolean getAllowGuestConfig() {
        return this.allowGuestConfig;
    }

    void addLayoutDefinition(LayoutDefinition def) {
        this.layoutDefs.put(def.Id, def);
    }

    public LayoutDefinition getLayoutDefinition(String id) {
        return this.layoutDefs.get(id);
    }

    void addDashletDefinition(DashletDefinition def) {
        this.dashletDefs.put(def.Id, def);
    }

    public DashletDefinition getDashletDefinition(String id) {
        return this.dashletDefs.get(id);
    }

    public Collection<LayoutDefinition> getLayouts() {
        return this.layoutDefs.values();
    }

    public Collection<DashletDefinition> getDashlets() {
        return this.dashletDefs.values();
    }

    void addDefaultDashlet(String id) {
        if (this.defaultDashlets == null) {
            this.defaultDashlets = new ArrayList<String>(2);
        }
        this.defaultDashlets.add(id);
    }

    public Collection<String> getDefaultDashlets() {
        return this.defaultDashlets;
    }

    public static class DashletDefinition
    implements Serializable {
        private static final long serialVersionUID = -5755903997700459631L;
        public String Id;
        public boolean AllowNarrow = true;
        public String Label;
        public String LabelId;
        public String Description;
        public String DescriptionId;
        public String JSPPage;
        public String ConfigJSPPage;

        DashletDefinition(String id) {
            this.Id = id;
        }
    }

    public static class LayoutDefinition
    implements Serializable {
        private static final long serialVersionUID = -3014156293576142077L;
        public String Id;
        public String Image;
        public int Columns;
        public int ColumnLength;
        public String Label;
        public String LabelId;
        public String Description;
        public String DescriptionId;
        public String JSPPage;

        LayoutDefinition(String id) {
            this.Id = id;
        }
    }
}

