/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.alfresco.web.config.DialogsConfigElement;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

public class DialogsElementReader
implements ConfigElementReader {
    public static final String ELEMENT_DIALOGS = "dialogs";
    public static final String ELEMENT_DIALOG = "dialog";
    public static final String ELEMENT_BUTTONS = "buttons";
    public static final String ELEMENT_BUTTON = "button";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_PAGE = "page";
    public static final String ATTR_MANAGED_BEAN = "managed-bean";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_TITLE = "title";
    public static final String ATTR_TITLE_ID = "title-id";
    public static final String ATTR_SUBTITLE = "subtitle";
    public static final String ATTR_SUBTITLE_ID = "subtitle-id";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_DESCRIPTION_ID = "description-id";
    public static final String ATTR_ERROR_MSG_ID = "error-message-id";
    public static final String ATTR_SHOW_OK_BUTTON = "show-ok-button";
    public static final String ATTR_ACTIONS_CONFIG_ID = "actions-config-id";
    public static final String ATTR_ACTIONS_AS_MENU = "actions-as-menu";
    public static final String ATTR_ACTIONS_MENU_LABEL = "actions-menu-label";
    public static final String ATTR_ACTIONS_MENU_LABEL_ID = "actions-menu-label-id";
    public static final String ATTR_MORE_ACTIONS_CONFIG_ID = "more-actions-config-id";
    public static final String ATTR_MORE_ACTIONS_MENU_LABEL = "more-actions-menu-label";
    public static final String ATTR_MORE_ACTIONS_MENU_LABEL_ID = "more-actions-menu-label-id";
    public static final String ATTR_ID = "id";
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_LABEL_ID = "label-id";
    public static final String ATTR_ACTION = "action";
    public static final String ATTR_DISABLED = "disabled";
    public static final String ATTR_ONCLICK = "onclick";

    public ConfigElement parse(Element element) {
        DialogsConfigElement configElement = null;
        if (element != null) {
            String elementName = element.getName();
            if (!elementName.equals(ELEMENT_DIALOGS)) {
                throw new ConfigException("DialogsElementReader can only parse dialogselements, the element passed was '" + elementName + "'");
            }
            configElement = new DialogsConfigElement();
            Iterator items = element.elementIterator(ELEMENT_DIALOG);
            while (items.hasNext()) {
                Element item = (Element)items.next();
                String name = item.attributeValue(ATTR_NAME);
                String page = item.attributeValue(ATTR_PAGE);
                String bean = item.attributeValue(ATTR_MANAGED_BEAN);
                String icon = item.attributeValue(ATTR_ICON);
                String title = item.attributeValue(ATTR_TITLE);
                String titleId = item.attributeValue(ATTR_TITLE_ID);
                String subTitle = item.attributeValue(ATTR_SUBTITLE);
                String subTitleId = item.attributeValue(ATTR_SUBTITLE_ID);
                String description = item.attributeValue(ATTR_DESCRIPTION);
                String descriptionId = item.attributeValue(ATTR_DESCRIPTION_ID);
                String errorMsgId = item.attributeValue(ATTR_ERROR_MSG_ID);
                String showOK = item.attributeValue(ATTR_SHOW_OK_BUTTON);
                boolean isOKButtonVisible = true;
                if (showOK != null) {
                    isOKButtonVisible = Boolean.parseBoolean(showOK);
                }
                String actionsConfigId = item.attributeValue(ATTR_ACTIONS_CONFIG_ID);
                boolean useMenuForActions = false;
                String asMenu = item.attributeValue(ATTR_ACTIONS_AS_MENU);
                if (asMenu != null) {
                    useMenuForActions = Boolean.parseBoolean(asMenu);
                }
                String actionsMenuLabel = item.attributeValue(ATTR_ACTIONS_MENU_LABEL);
                String actionsMenuLabelId = item.attributeValue(ATTR_ACTIONS_MENU_LABEL_ID);
                String moreActionsConfigId = item.attributeValue(ATTR_MORE_ACTIONS_CONFIG_ID);
                String moreActionsMenuLabel = item.attributeValue(ATTR_MORE_ACTIONS_MENU_LABEL);
                String moreActionsMenuLabelId = item.attributeValue(ATTR_MORE_ACTIONS_MENU_LABEL_ID);
                List<DialogsConfigElement.DialogButtonConfig> buttons = this.parseButtons(item);
                DialogsConfigElement.DialogAttributes attrs = new DialogsConfigElement.DialogAttributes(name, page, bean);
                attrs.setIcon(icon);
                attrs.setTitle(title);
                attrs.setTitleId(titleId);
                attrs.setSubTitle(subTitle);
                attrs.setSubTitleId(subTitleId);
                attrs.setDescription(description);
                attrs.setDescriptionId(descriptionId);
                attrs.setErrorMessageId(errorMsgId);
                attrs.setOKButtonVisible(isOKButtonVisible);
                attrs.setButtons(buttons);
                attrs.setActionsConfigId(actionsConfigId);
                attrs.setActionsAsMenu(useMenuForActions);
                attrs.setActionsMenuLabel(actionsMenuLabel);
                attrs.setActionsMenuLabelId(actionsMenuLabelId);
                attrs.setMoreActionsConfigId(moreActionsConfigId);
                attrs.setMoreActionsMenuLabel(moreActionsMenuLabel);
                attrs.setMoreActionsMenuLabelId(moreActionsMenuLabelId);
                DialogsConfigElement.DialogConfig cfg = new DialogsConfigElement.DialogConfig(attrs);
                configElement.addDialog(cfg);
            }
        }
        return configElement;
    }

    protected List<DialogsConfigElement.DialogButtonConfig> parseButtons(Element dialog) {
        ArrayList<DialogsConfigElement.DialogButtonConfig> buttons = null;
        Element buttonsConfig = dialog.element(ELEMENT_BUTTONS);
        if (buttonsConfig != null) {
            buttons = new ArrayList<DialogsConfigElement.DialogButtonConfig>(4);
            Iterator children = buttonsConfig.elementIterator(ELEMENT_BUTTON);
            while (children.hasNext()) {
                Element button = (Element)children.next();
                String id = button.attributeValue(ATTR_ID);
                String label = button.attributeValue(ATTR_LABEL);
                String labelId = button.attributeValue(ATTR_LABEL_ID);
                String action = button.attributeValue(ATTR_ACTION);
                String disabled = button.attributeValue(ATTR_DISABLED);
                String onclick = button.attributeValue(ATTR_ONCLICK);
                DialogsConfigElement.DialogButtonConfig btnCfg = new DialogsConfigElement.DialogButtonConfig(id, label, labelId, action, disabled, onclick);
                buttons.add(btnCfg);
            }
        }
        return buttons;
    }
}

