/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.element.ConfigElementAdapter;

public class LanguagesConfigElement
extends ConfigElementAdapter {
    public static final String CONFIG_ELEMENT_ID = "languages";
    private Map<String, String> localeMap = new HashMap<String, String>();
    private List<String> languages = new ArrayList<String>(8);

    public LanguagesConfigElement() {
        super(CONFIG_ELEMENT_ID);
    }

    public LanguagesConfigElement(String name) {
        super(name);
    }

    public List<ConfigElement> getChildren() {
        throw new ConfigException("Reading the languages config via the generic interfaces is not supported");
    }

    public ConfigElement combine(ConfigElement configElement) {
        LanguagesConfigElement newElement = (LanguagesConfigElement)configElement;
        LanguagesConfigElement combinedElement = new LanguagesConfigElement();
        for (String locale : this.languages) {
            combinedElement.addLanguage(locale, this.localeMap.get(locale));
        }
        List<String> languages = newElement.getLanguages();
        for (String locale : languages) {
            if (combinedElement.getLabelForLanguage(locale) != null) continue;
            String label = newElement.getLabelForLanguage(locale);
            combinedElement.addLanguage(locale, label);
        }
        return combinedElement;
    }

    void addLanguage(String locale, String label) {
        this.localeMap.put(locale, label);
        this.languages.add(locale);
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public String getLabelForLanguage(String locale) {
        return this.localeMap.get(locale);
    }
}

