/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.util.HashMap;
import java.util.List;
import org.alfresco.web.config.NavigationResult;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.element.ConfigElementAdapter;
import org.springframework.extensions.config.element.GenericConfigElement;

public class NavigationConfigElement
extends ConfigElementAdapter {
    private HashMap<String, NavigationResult> viewIds = new HashMap();
    private HashMap<String, NavigationResult> outcomes = new HashMap();
    private boolean kidsPopulated = false;

    public NavigationConfigElement() {
        super("navigation");
    }

    public NavigationConfigElement(String name) {
        super(name);
    }

    public List<ConfigElement> getChildren() {
        List kids = null;
        if (this.viewIds.size() > 0 || this.outcomes.size() > 0) {
            if (!this.kidsPopulated) {
                String result;
                NavigationResult navRes;
                GenericConfigElement ce;
                for (String fromViewId : this.viewIds.keySet()) {
                    ce = new GenericConfigElement("override");
                    ce.addAttribute("from-view-id", fromViewId);
                    navRes = this.viewIds.get(fromViewId);
                    result = navRes.getResult();
                    if (navRes.isOutcome()) {
                        ce.addAttribute("to-outcome", result);
                    } else {
                        ce.addAttribute("to-view-id", result);
                    }
                    this.children.add(ce);
                }
                for (String fromOutcome : this.outcomes.keySet()) {
                    ce = new GenericConfigElement("override");
                    ce.addAttribute("from-outcome", fromOutcome);
                    navRes = this.outcomes.get(fromOutcome);
                    result = navRes.getResult();
                    if (navRes.isOutcome()) {
                        ce.addAttribute("to-outcome", result);
                    } else {
                        ce.addAttribute("to-view-id", result);
                    }
                    this.children.add(ce);
                }
                this.kidsPopulated = true;
            }
            kids = super.getChildren();
        }
        return kids;
    }

    public ConfigElement combine(ConfigElement configElement) {
        NavigationConfigElement newElement = (NavigationConfigElement)configElement;
        NavigationConfigElement combinedElement = new NavigationConfigElement();
        for (String fromViewId : this.viewIds.keySet()) {
            combinedElement.addOverride(fromViewId, null, this.viewIds.get(fromViewId));
        }
        for (String fromOutcome : this.outcomes.keySet()) {
            combinedElement.addOverride(null, fromOutcome, this.outcomes.get(fromOutcome));
        }
        HashMap<String, NavigationResult> viewIds = newElement.getViewIds();
        for (String fromViewId : viewIds.keySet()) {
            combinedElement.addOverride(fromViewId, null, viewIds.get(fromViewId));
        }
        HashMap<String, NavigationResult> outcomes = newElement.getOutcomes();
        for (String fromOutcome : outcomes.keySet()) {
            combinedElement.addOverride(null, fromOutcome, outcomes.get(fromOutcome));
        }
        return combinedElement;
    }

    public HashMap<String, NavigationResult> getViewIds() {
        return this.viewIds;
    }

    public HashMap<String, NavigationResult> getOutcomes() {
        return this.outcomes;
    }

    public void addOverride(String fromViewId, String fromOutcome, String toViewId, String toOutcome) {
        NavigationResult result = new NavigationResult(toViewId, toOutcome);
        this.addOverride(fromViewId, fromOutcome, result);
    }

    public void addOverride(String fromViewId, String fromOutcome, NavigationResult result) {
        if (fromViewId != null && fromOutcome != null) {
            throw new IllegalStateException("You can not have both a from-view-id and from-outcome");
        }
        if (fromViewId != null) {
            this.viewIds.put(fromViewId, result);
        } else if (fromOutcome != null) {
            this.outcomes.put(fromOutcome, result);
        }
    }

    public NavigationResult getOverride(String fromViewId, String fromOutcome) {
        NavigationResult result = null;
        if (fromOutcome != null) {
            result = this.outcomes.get(fromOutcome);
        } else if (fromViewId != null) {
            result = this.viewIds.get(fromViewId);
        }
        return result;
    }
}

