/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.element.ConfigElementAdapter;
import org.springframework.extensions.surf.util.ParameterCheck;

public class SidebarConfigElement
extends ConfigElementAdapter
implements Serializable {
    private static final long serialVersionUID = -251308123183340915L;
    public static final String CONFIG_ELEMENT_ID = "sidebar";
    private String defaultPlugin;
    private Map<String, SidebarPluginConfig> plugins = new LinkedHashMap<String, SidebarPluginConfig>(8, 10.0f);

    public SidebarConfigElement() {
        super(CONFIG_ELEMENT_ID);
    }

    public SidebarConfigElement(String name) {
        super(name);
    }

    public List<ConfigElement> getChildren() {
        throw new ConfigException("Reading the sidebar config via the generic interfaces is not supported");
    }

    public ConfigElement combine(ConfigElement configElement) {
        SidebarConfigElement newElement = (SidebarConfigElement)configElement;
        SidebarConfigElement combinedElement = new SidebarConfigElement();
        for (SidebarPluginConfig plugin : this.getPlugins().values()) {
            combinedElement.addPlugin(plugin);
        }
        for (SidebarPluginConfig plugin : newElement.getPlugins().values()) {
            combinedElement.addPlugin(plugin);
        }
        String newDefaultPlugin = newElement.getDefaultPlugin();
        if (newDefaultPlugin != null) {
            combinedElement.setDefaultPlugin(newDefaultPlugin);
        } else {
            combinedElement.setDefaultPlugin(this.getDefaultPlugin());
        }
        return combinedElement;
    }

    public SidebarPluginConfig getPlugin(String id) {
        return this.plugins.get(id);
    }

    public Map<String, SidebarPluginConfig> getPlugins() {
        return this.plugins;
    }

    public String getDefaultPlugin() {
        return this.defaultPlugin;
    }

    public void setDefaultPlugin(String defaultPlugin) {
        this.defaultPlugin = defaultPlugin;
    }

    void addPlugin(SidebarPluginConfig pluginConfig) {
        this.plugins.put(pluginConfig.getId(), pluginConfig);
    }

    public static class SidebarPluginConfig
    implements Serializable {
        private static final long serialVersionUID = 1400852211128756652L;
        protected String id;
        protected String page;
        protected String actionsConfigId;
        protected String icon;
        protected String label;
        protected String labelId;
        protected String description;
        protected String descriptionId;

        public SidebarPluginConfig(String id, String page, String label, String labelId, String description, String descriptionId, String actionsConfigId, String icon) {
            ParameterCheck.mandatoryString((String)"id", (String)id);
            ParameterCheck.mandatoryString((String)"page", (String)page);
            this.id = id;
            this.page = page;
            this.icon = icon;
            this.label = label;
            this.labelId = labelId;
            this.description = description;
            this.descriptionId = descriptionId;
            this.actionsConfigId = actionsConfigId;
        }

        public String getId() {
            return this.id;
        }

        public String getPage() {
            return this.page;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getlabel() {
            return this.label;
        }

        public String getlabelId() {
            return this.labelId;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDescriptionId() {
            return this.descriptionId;
        }

        public String getActionsConfigId() {
            return this.actionsConfigId;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(super.toString());
            buffer.append(" (id=").append(this.id);
            buffer.append(" page=").append(this.page);
            buffer.append(" icon=").append(this.icon);
            buffer.append(" label=").append(this.label);
            buffer.append(" labelId=").append(this.labelId);
            buffer.append(" description=").append(this.description);
            buffer.append(" descriptionId=").append(this.descriptionId);
            buffer.append(" actions-config-id=").append(this.actionsConfigId).append(")");
            return buffer.toString();
        }
    }
}

